/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration.document;

import java.io.PrintStream;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItemContainer;
import org.w3c.dom.Element;

public class ForLoopDocumentItem
extends DocumentItemContainer {
    public static final String TRADITIONAL = "traditional";
    public static final String FOREACH = "foreach";
    private String type = "foreach";
    private String varName = "";
    private String conditional = "";
    private String transform = "";

    public ForLoopDocumentItem(WebserviceBindingManager manager) {
        super(manager);
    }

    public String getType() {
        return this.type;
    }

    public String getVariableName() {
        return this.varName;
    }

    public String getConditional() {
        return this.conditional;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setForEach(String varName, String sourceName) {
        this.type = FOREACH;
        this.varName = varName;
        this.transform = sourceName;
        this.conditional = "";
    }

    public void setTraditional(String varName, String conditional, String transform) {
        this.type = TRADITIONAL;
        this.varName = varName;
        this.conditional = conditional;
        this.transform = transform;
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element conditionalItemElement = parentElement.getOwnerDocument().createElementNS(null, "for-loop-item");
        parentElement.appendChild(conditionalItemElement);
        return conditionalItemElement;
    }

    @Override
    public void readConfiguration(Element conditionalItemElement) {
        this.type = conditionalItemElement.getAttribute("type");
        if (this.type.equals("")) {
            this.type = FOREACH;
        }
        this.varName = conditionalItemElement.getAttribute("variable-name");
        this.conditional = conditionalItemElement.getAttribute("conditional");
        this.transform = conditionalItemElement.getAttribute("transform");
        super.readConfiguration(conditionalItemElement);
    }

    @Override
    public void writeConfiguration(Element conditionalItemElement) {
        conditionalItemElement.setAttribute("type", this.type);
        conditionalItemElement.setAttribute("variable-name", this.varName);
        conditionalItemElement.setAttribute("conditional", this.conditional);
        conditionalItemElement.setAttribute("transform", this.transform);
        super.writeConfiguration(conditionalItemElement);
    }

    @Override
    public void dumpContents(PrintStream out) {
        out.println("[For Loop: " + this.type);
        out.println("Variable being iterated: " + this.varName);
        if (this.type.equals(TRADITIONAL)) {
            out.println("Conditional Item: " + this.conditional);
            out.println("Transform: " + this.transform);
        }
        super.dumpContents(out);
    }
}

