/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.widgets.UIHelper;
import org.eclipse.vtp.desktop.editors.core.widgets.ValueControl;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.schema.AbstractElementObject;
import org.eclipse.vtp.desktop.model.core.schema.AttributeItem;
import org.eclipse.vtp.desktop.model.core.schema.ComplexContentModel;
import org.eclipse.vtp.desktop.model.core.schema.ComplexType;
import org.eclipse.vtp.desktop.model.core.schema.ContentModel;
import org.eclipse.vtp.desktop.model.core.schema.ElementGroup;
import org.eclipse.vtp.desktop.model.core.schema.ElementItem;
import org.eclipse.vtp.desktop.model.core.schema.SimpleContentModel;
import org.eclipse.vtp.desktop.model.core.schema.SimpleType;
import org.eclipse.vtp.desktop.model.core.schema.Type;
import org.eclipse.vtp.desktop.model.core.wsdl.ElementPart;
import org.eclipse.vtp.desktop.model.core.wsdl.Part;
import org.eclipse.vtp.desktop.model.core.wsdl.TypedPart;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBindingOperation;
import org.eclipse.vtp.modules.webservice.ui.Activator;
import org.eclipse.vtp.modules.webservice.ui.automata.CCSSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Command;
import org.eclipse.vtp.modules.webservice.ui.automata.CommandListener;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerBoundaryCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ElementSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ElseIfSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ElseSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ForLoopSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizeDocumentItemCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizeElementItemCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.SchemaEngine;
import org.eclipse.vtp.modules.webservice.ui.automata.SuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.TextSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandedBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.InputDocumentStructure;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ConditionalContainerSet;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ConditionalDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItemContainer;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElementAttributeDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElementDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElseDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ForLoopDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.TextDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.properties.IOperationListener;
import org.eclipse.vtp.modules.webservice.ui.properties.SoapServiceSelectionPropertiesPanel;
import org.eclipse.vtp.modules.webservice.ui.widgets.ObjectDefinitionFilter;
import org.eclipse.vtp.modules.webservice.ui.widgets.ValueStack;
import org.eclipse.vtp.modules.webservice.ui.widgets.VariableBrowserDialog;

public class SoapInputDocumentPropertiesPanel
extends DesignElementPropertiesPanel
implements IOperationListener {
    private WebserviceBindingManager manager = null;
    private InputDocumentStructure structure = null;
    private SoapBindingOperation currentOperation = null;
    private ScrolledComposite scrollComp = null;
    private Composite rootComp = null;
    boolean composing = true;
    private SchemaEngine schemaEngine = null;
    private List<Variable> variables = new ArrayList<Variable>();
    List<BrandedUIItem> valueStacks = new LinkedList<BrandedUIItem>();
    Map<UIContentComposite, List<Variable>> variableScopes = new HashMap<UIContentComposite, List<Variable>>();
    private Map<DocumentItem, Map<String, Boolean>> expansionStates = new HashMap<DocumentItem, Map<String, Boolean>>();
    Point origin = null;
    LinkedList<Composite> comps = new LinkedList();
    LinkedList<DocumentItemContainer> containers = new LinkedList();
    LinkedList<DocumentItem> lastItems = new LinkedList();
    LinkedList<Integer> siblingCounters = new LinkedList();
    LinkedList<Boolean> hasIf = new LinkedList();
    int depth = 0;
    UISuggestionComposite suggestionComp = null;
    List<SuggestionCommand> suggestions = new LinkedList<SuggestionCommand>();
    LinkedList<UIContentComposite> uiScopes = new LinkedList();
    private Map<String, Object> lastContext = null;

    public SoapInputDocumentPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        this.manager = (WebserviceBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.webservicecall");
        this.structure = this.manager.getInputDocumentStructure();
        this.variables = element.getDesign().getVariablesFor(element);
    }

    public void createControls(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setBackground(parent.getBackground());
        mainComp.setLayout((Layout)new GridLayout(1, false));
        Section contentSection = toolkit.createSection(mainComp, 256);
        GridData gd = new GridData(770);
        gd.horizontalSpan = 1;
        contentSection.setLayoutData((Object)gd);
        contentSection.setText("Input Document Contents");
        this.scrollComp = new ScrolledComposite(mainComp, 2560);
        this.scrollComp.setAlwaysShowScrollBars(true);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(false);
        this.scrollComp.getVerticalBar().setIncrement(10);
        this.scrollComp.setBackgroundMode(1);
        this.scrollComp.setBackground(parent.getDisplay().getSystemColor(1));
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 400;
        layoutData.widthHint = 600;
        this.scrollComp.setLayoutData((Object)layoutData);
        this.buildDocumentDisplay();
    }

    public void markOrigin() {
        this.origin = this.scrollComp.getOrigin();
    }

    public void restoreOrigin() {
        this.scrollComp.setOrigin(this.origin);
    }

    public void buildDocumentDisplay() {
        this.scrollComp.setLayoutDeferred(true);
        if (this.rootComp != null) {
            for (BrandedUIItem brandedItem : this.valueStacks) {
                brandedItem.getValueStack().save();
            }
            this.rootComp.dispose();
        }
        this.valueStacks.clear();
        this.rootComp = new Composite((Composite)this.scrollComp, 0);
        this.scrollComp.setContent((Control)this.rootComp);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        this.rootComp.setLayout((Layout)layout);
        if (this.currentOperation == null) {
            Label messageText = new Label(this.rootComp, 0);
            messageText.setText("No soap operation has been selected.");
            messageText.setSize(10, 200);
            this.scrollComp.setMinSize(1, 200);
        } else {
            try {
                List bodyParts = this.currentOperation.getInput().getBody().getParts();
                for (Part part : bodyParts) {
                    if (part instanceof TypedPart) {
                        TypedPart tp = (TypedPart)part;
                        Type type = tp.getType();
                        this.schemaEngine = new SchemaEngine(type);
                        continue;
                    }
                    ElementPart ep = (ElementPart)part;
                    ElementItem ei = ep.getElementItem();
                    ComplexType rootType = new ComplexType(ei.getOwnerSchema(), "roottype");
                    ComplexContentModel ccm = new ComplexContentModel(false);
                    ElementGroup eg = new ElementGroup(ei.getOwnerSchema(), "sequence");
                    eg.addElementObject((AbstractElementObject)ei);
                    ccm.setElementGroup(eg);
                    rootType.setContentModel((ContentModel)ccm);
                    this.schemaEngine = new SchemaEngine((Type)rootType);
                }
                this.processStructure();
                if (this.lastContext != null) {
                    this.setConfigurationContext(this.lastContext);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rootComp.setSize(this.rootComp.computeSize(this.scrollComp.getClientArea().width - 1, -1));
        }
        this.scrollComp.setLayoutDeferred(false);
    }

    private void postNewContainer(UIContentComposite content, DocumentItemContainer container) {
        UIContentComposite comp = content;
        if (content instanceof UIContentContainer) {
            comp = ((UIContentContainer)content).getContainerComposite();
        }
        if (comp != null) {
            this.comps.offerLast(comp);
            ++this.depth;
            this.siblingCounters.offerLast(0);
        }
        this.containers.offerLast(container);
        this.lastItems.offerLast(null);
        this.hasIf.offerLast(false);
        this.uiScopes.offerLast(content);
    }

    private void processStructure() {
        this.comps.clear();
        this.containers.clear();
        this.lastItems.clear();
        this.siblingCounters.clear();
        this.hasIf.clear();
        this.comps.offerLast(this.rootComp);
        this.containers.offerLast(this.structure);
        this.lastItems.offerLast(null);
        this.hasIf.offerLast(false);
        this.siblingCounters.offerLast(0);
        this.depth = 0;
        this.suggestionComp = null;
        this.suggestions.clear();
        this.uiScopes.clear();
        this.uiScopes.offerLast(null);
        CommandListener cl = new CommandListener(){

            @Override
            public void proccess(Command command) {
                try {
                    if (command instanceof ContainerBoundaryCommand) {
                        if (!(SoapInputDocumentPropertiesPanel.this.containers.peekLast() instanceof ConditionalContainerSet)) {
                            SoapInputDocumentPropertiesPanel.this.comps.removeLast();
                            --SoapInputDocumentPropertiesPanel.this.depth;
                            SoapInputDocumentPropertiesPanel.this.siblingCounters.removeLast();
                        }
                        SoapInputDocumentPropertiesPanel.this.containers.removeLast();
                        SoapInputDocumentPropertiesPanel.this.lastItems.removeLast();
                        SoapInputDocumentPropertiesPanel.this.hasIf.removeLast();
                        SoapInputDocumentPropertiesPanel.this.suggestionComp = null;
                        SoapInputDocumentPropertiesPanel.this.suggestions.clear();
                        SoapInputDocumentPropertiesPanel.this.uiScopes.removeLast();
                    } else if (command instanceof RealizeDocumentItemCommand) {
                        RealizeDocumentItemCommand itemCommand = (RealizeDocumentItemCommand)command;
                        DocumentItem item = itemCommand.getDocumentItem();
                        if (item instanceof ForLoopDocumentItem) {
                            ForLoopDocumentItem forContainer = (ForLoopDocumentItem)item;
                            UIForContent forContent = new UIForContent(SoapInputDocumentPropertiesPanel.this.uiScopes.peekLast(), SoapInputDocumentPropertiesPanel.this.comps.peekLast(), true);
                            forContent.setContent(forContainer);
                            forContent.setValidated(itemCommand.isValid());
                            Integer order = SoapInputDocumentPropertiesPanel.this.siblingCounters.pollLast();
                            order = order + 1;
                            SoapInputDocumentPropertiesPanel.this.siblingCounters.offerLast(order);
                            SoapInputDocumentPropertiesPanel.this.lastItems.removeLast();
                            SoapInputDocumentPropertiesPanel.this.lastItems.offerLast(item);
                            SoapInputDocumentPropertiesPanel.this.postNewContainer(forContent, forContainer);
                        } else if (item instanceof ConditionalContainerSet) {
                            SoapInputDocumentPropertiesPanel.this.lastItems.offerLast(item);
                            SoapInputDocumentPropertiesPanel.this.postNewContainer(null, (DocumentItemContainer)item);
                        } else if (item instanceof ConditionalDocumentItem) {
                            ConditionalDocumentItem conditionalContainer = (ConditionalDocumentItem)item;
                            UIConditionalContent conditionalContent = new UIConditionalContent(SoapInputDocumentPropertiesPanel.this.uiScopes.peekLast(), SoapInputDocumentPropertiesPanel.this.comps.peekLast(), true);
                            conditionalContent.setContent(conditionalContainer);
                            conditionalContent.setElseIf(SoapInputDocumentPropertiesPanel.this.hasIf.pollLast());
                            conditionalContent.setValidated(itemCommand.isValid());
                            Integer order = SoapInputDocumentPropertiesPanel.this.siblingCounters.pollLast();
                            order = order + 1;
                            SoapInputDocumentPropertiesPanel.this.siblingCounters.offerLast(order);
                            SoapInputDocumentPropertiesPanel.this.hasIf.offerLast(true);
                            SoapInputDocumentPropertiesPanel.this.postNewContainer(conditionalContent, conditionalContainer);
                        } else if (item instanceof ElseDocumentItem) {
                            ElseDocumentItem elseContainer = (ElseDocumentItem)item;
                            UIElseContent elseContent = new UIElseContent(SoapInputDocumentPropertiesPanel.this.uiScopes.peekLast(), SoapInputDocumentPropertiesPanel.this.comps.peekLast(), true);
                            elseContent.setContent(elseContainer);
                            elseContent.setValidated(itemCommand.isValid());
                            Integer order = SoapInputDocumentPropertiesPanel.this.siblingCounters.pollLast();
                            order = order + 1;
                            SoapInputDocumentPropertiesPanel.this.siblingCounters.offerLast(order);
                            SoapInputDocumentPropertiesPanel.this.postNewContainer(elseContent, elseContainer);
                        } else if (item instanceof TextDocumentItem) {
                            Composite comp = SoapInputDocumentPropertiesPanel.this.comps.peekLast();
                            if (comp instanceof UIElementContent && ((UIElementContent)comp).isTextOnly()) {
                                UIElementContent edi = (UIElementContent)comp;
                                edi.setText((TextDocumentItem)item);
                            } else {
                                UITextContent textContent = new UITextContent(SoapInputDocumentPropertiesPanel.this.uiScopes.peekLast(), SoapInputDocumentPropertiesPanel.this.comps.peekLast(), true);
                                textContent.setContent((TextDocumentItem)item);
                                textContent.setValidated(itemCommand.isValid());
                                Integer order = SoapInputDocumentPropertiesPanel.this.siblingCounters.pollLast();
                                order = order + 1;
                                SoapInputDocumentPropertiesPanel.this.siblingCounters.offerLast(order);
                                SoapInputDocumentPropertiesPanel.this.lastItems.removeLast();
                                SoapInputDocumentPropertiesPanel.this.lastItems.offerLast(item);
                            }
                        } else if (item instanceof ElementDocumentItem) {
                            ElementDocumentItem elementContainer = (ElementDocumentItem)item;
                            UIElementContent elementContent = new UIElementContent(SoapInputDocumentPropertiesPanel.this.uiScopes.peekLast(), SoapInputDocumentPropertiesPanel.this.comps.peekLast(), true, ((RealizeElementItemCommand)command).isTextOnly());
                            elementContent.setContent(elementContainer);
                            elementContent.setValidated(itemCommand.isValid());
                            Integer order = SoapInputDocumentPropertiesPanel.this.siblingCounters.pollLast();
                            order = order + 1;
                            SoapInputDocumentPropertiesPanel.this.siblingCounters.offerLast(order);
                            SoapInputDocumentPropertiesPanel.this.lastItems.removeLast();
                            SoapInputDocumentPropertiesPanel.this.lastItems.offerLast(item);
                            SoapInputDocumentPropertiesPanel.this.postNewContainer(elementContent, elementContainer);
                        }
                        SoapInputDocumentPropertiesPanel.this.suggestions.clear();
                        SoapInputDocumentPropertiesPanel.this.suggestionComp = null;
                    } else if (command instanceof SuggestionCommand) {
                        boolean matched = false;
                        Composite currentComp = SoapInputDocumentPropertiesPanel.this.comps.peekLast();
                        DocumentItemContainer currentContainer = SoapInputDocumentPropertiesPanel.this.containers.peekLast();
                        DocumentItem lastItem = SoapInputDocumentPropertiesPanel.this.lastItems.peekLast();
                        for (SuggestionCommand sc : SoapInputDocumentPropertiesPanel.this.suggestions) {
                            if (!sc.getClass().equals(command.getClass())) continue;
                            if (!(command instanceof ElementSuggestionCommand)) {
                                matched = true;
                                break;
                            }
                            ElementSuggestionCommand esc = (ElementSuggestionCommand)command;
                            ElementSuggestionCommand esc2 = (ElementSuggestionCommand)sc;
                            if (esc2.getElement().getName() != esc.getElement().getName()) continue;
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            SuggestionCommand sc;
                            sc = (SuggestionCommand)command;
                            SoapInputDocumentPropertiesPanel.this.suggestions.add(sc);
                            if (SoapInputDocumentPropertiesPanel.this.suggestionComp == null) {
                                SoapInputDocumentPropertiesPanel.this.suggestionComp = new UISuggestionComposite(currentComp, 0);
                            }
                            if (command instanceof ForLoopSuggestionCommand) {
                                ForLoopSuggestion fls = new ForLoopSuggestion(currentContainer, sc.isRequired());
                                fls.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(fls);
                            } else if (command instanceof CCSSuggestionCommand) {
                                IfSuggestion ifSuggestion = new IfSuggestion(currentContainer, sc.isRequired());
                                ifSuggestion.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(ifSuggestion);
                            } else if (command instanceof ElseIfSuggestionCommand) {
                                ElseIfSuggestion elseIfSuggestion = new ElseIfSuggestion(currentContainer, sc.isRequired());
                                elseIfSuggestion.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(elseIfSuggestion);
                            } else if (command instanceof ElseSuggestionCommand) {
                                ElseSuggestion elseSuggestion = new ElseSuggestion(currentContainer, sc.isRequired());
                                elseSuggestion.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(elseSuggestion);
                            } else if (command instanceof TextSuggestionCommand) {
                                TextSuggestion textSuggestion = new TextSuggestion(currentContainer, sc.isRequired());
                                textSuggestion.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(textSuggestion);
                            } else if (command instanceof ElementSuggestionCommand) {
                                ElementSuggestion elementSuggestion = new ElementSuggestion(((ElementSuggestionCommand)command).getElement(), currentContainer, sc.isRequired());
                                elementSuggestion.setInsertionPoint(lastItem);
                                SoapInputDocumentPropertiesPanel.this.suggestionComp.addSuggestion(elementSuggestion);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.schemaEngine.addCommandListener(cl);
        this.schemaEngine.processDocumentStructure(this.structure);
        this.schemaEngine.removeCommandListener(cl);
    }

    public void save() {
        for (BrandedUIItem brandedItem : this.valueStacks) {
            brandedItem.getValueStack().save();
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void setConfigurationContext(Map<String, Object> values) {
        this.lastContext = values;
        IBrand brand = (IBrand)values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        for (BrandedUIItem brandedItem : this.valueStacks) {
            BrandBinding brandBinding = brandedItem.getBinding().getBrandBinding(brand);
            brandedItem.getValueStack().setSetting(brandBinding);
        }
    }

    public void resolve() {
        List panels = this.getContainer().getPanels();
        for (ComponentPropertiesPanel panel : panels) {
            if (!(panel instanceof SoapServiceSelectionPropertiesPanel)) continue;
            ((SoapServiceSelectionPropertiesPanel)panel).addOperationListener(this);
            break;
        }
    }

    @Override
    public void operationChanged(SoapBindingOperation operation) {
        if (operation != this.currentOperation) {
            this.currentOperation = operation;
            if (this.scrollComp != null) {
                this.valueStacks.clear();
                this.buildDocumentDisplay();
                this.variableScopes.clear();
            }
        }
    }

    public static interface BrandedUIItem {
        public BrandedBinding getBinding();

        public ValueStack getValueStack();
    }

    public class ElementSuggestion
    extends Suggestion {
        private ElementItem element;

        public ElementSuggestion(ElementItem element, DocumentItemContainer container, boolean required) {
            super(container, required);
            this.element = null;
            this.element = element;
        }

        public boolean isTextOnly() {
            Type type = this.element.getType();
            if (type instanceof SimpleType) {
                return true;
            }
            ComplexType complexType = (ComplexType)type;
            ContentModel contentModel = complexType.getContentModel();
            return contentModel instanceof SimpleContentModel;
        }

        @Override
        public void createControls(Composite parent) {
            final Hyperlink nameLink = new Hyperlink(parent, 0);
            nameLink.setText("Element: " + this.element.getName() + " " + (this.isRequired() ? " (Required)" : ""));
            nameLink.setLayoutData((Object)new GridData(768));
            nameLink.setForeground(parent.getDisplay().getSystemColor(9));
            nameLink.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    System.out.println(nameLink.getSize());
                }
            });
            nameLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    nameLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    nameLink.setUnderlined(false);
                }

                public void linkActivated(HyperlinkEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    ElementDocumentItem elementItem = new ElementDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                    elementItem.setName(ElementSuggestion.this.element.getName());
                    elementItem.setNamespace(ElementSuggestion.this.element.getOwnerSchema().getTargetNamespace());
                    Type type = ElementSuggestion.this.element.getType();
                    if (type instanceof ComplexType) {
                        ComplexType complexType = (ComplexType)type;
                        ContentModel contentModel = complexType.getContentModel();
                        List attributes = contentModel.getAttributes();
                        for (AttributeItem attributeItem : attributes) {
                            ElementAttributeDocumentItem attributeDocumentItem = new ElementAttributeDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                            attributeDocumentItem.setName(attributeItem.getName());
                            attributeDocumentItem.setOptional(!attributeItem.isRequired());
                            elementItem.addAttribute(attributeDocumentItem);
                        }
                    } else {
                        elementItem.setSimple(true);
                    }
                    ElementSuggestion.this.getContainer().insertItem((DocumentItem)elementItem, ElementSuggestion.this.getInsertionPoint());
                    if (ElementSuggestion.this.isTextOnly()) {
                        elementItem.insertItem((DocumentItem)new TextDocumentItem(SoapInputDocumentPropertiesPanel.this.manager), null);
                    }
                    SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }
            });
        }
    }

    public class ElseIfSuggestion
    extends Suggestion {
        public ElseIfSuggestion(DocumentItemContainer container, boolean required) {
            super(container, required);
        }

        @Override
        public void createControls(Composite parent) {
            final Hyperlink nameLink = new Hyperlink(parent, 0);
            nameLink.setText("ELSE IF");
            nameLink.setLayoutData((Object)new GridData(768));
            nameLink.setForeground(parent.getDisplay().getSystemColor(9));
            nameLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    nameLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    nameLink.setUnderlined(false);
                }

                public void linkActivated(HyperlinkEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    ConditionalDocumentItem conditional = new ConditionalDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                    ((ConditionalContainerSet)ElseIfSuggestion.this.getContainer()).addItem(conditional);
                    SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }
            });
        }
    }

    public class ElseSuggestion
    extends Suggestion {
        public ElseSuggestion(DocumentItemContainer container, boolean required) {
            super(container, required);
        }

        @Override
        public void createControls(Composite parent) {
            final Hyperlink nameLink = new Hyperlink(parent, 0);
            nameLink.setText("ELSE" + (this.isRequired() ? " (Required)" : ""));
            nameLink.setLayoutData((Object)new GridData(768));
            nameLink.setForeground(parent.getDisplay().getSystemColor(9));
            nameLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    nameLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    nameLink.setUnderlined(false);
                }

                public void linkActivated(HyperlinkEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    try {
                        ElseDocumentItem conditional = new ElseDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                        ((ConditionalContainerSet)ElseSuggestion.this.getContainer()).setElse(conditional);
                        SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }
            });
        }
    }

    public class ForLoopSuggestion
    extends Suggestion {
        public ForLoopSuggestion(DocumentItemContainer container, boolean required) {
            super(container, required);
        }

        @Override
        public void createControls(Composite parent) {
            final Hyperlink nameLink = new Hyperlink(parent, 0);
            nameLink.setText("FOR" + (this.isRequired() ? " (Required)" : ""));
            nameLink.setLayoutData((Object)new GridData(768));
            nameLink.setForeground(parent.getDisplay().getSystemColor(9));
            nameLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    nameLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    nameLink.setUnderlined(false);
                }

                public void linkActivated(HyperlinkEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    ForLoopDocumentItem forItem = new ForLoopDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                    ForLoopSuggestion.this.getContainer().insertItem((DocumentItem)forItem, ForLoopSuggestion.this.getInsertionPoint());
                    SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }
            });
        }
    }

    public class IfSuggestion
    extends Suggestion {
        public IfSuggestion(DocumentItemContainer container, boolean required) {
            super(container, required);
        }

        @Override
        public void createControls(Composite parent) {
            final Hyperlink nameLink = new Hyperlink(parent, 0);
            nameLink.setText("IF");
            nameLink.setLayoutData((Object)new GridData(768));
            nameLink.setForeground(parent.getDisplay().getSystemColor(9));
            nameLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    nameLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    nameLink.setUnderlined(false);
                }

                public void linkActivated(HyperlinkEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    ConditionalContainerSet conditionalSet = new ConditionalContainerSet(SoapInputDocumentPropertiesPanel.this.manager);
                    IfSuggestion.this.getContainer().insertItem((DocumentItem)conditionalSet, IfSuggestion.this.getInsertionPoint());
                    ConditionalDocumentItem conditional = new ConditionalDocumentItem(SoapInputDocumentPropertiesPanel.this.manager);
                    conditionalSet.setIf(conditional);
                    SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }
            });
        }
    }

    public abstract class Suggestion {
        private DocumentItemContainer container = null;
        private boolean active = false;
        private boolean required = false;
        private DocumentItem insertionPoint = null;

        public Suggestion(DocumentItemContainer container, boolean required) {
            this.container = container;
            this.required = required;
        }

        public DocumentItemContainer getContainer() {
            return this.container;
        }

        public DocumentItem getInsertionPoint() {
            return this.insertionPoint;
        }

        public void setInsertionPoint(DocumentItem insertionPoint) {
            this.insertionPoint = insertionPoint;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isRequired() {
            return this.required;
        }

        public abstract void createControls(Composite var1);
    }

    public class TextSuggestion
    extends Suggestion {
        public TextSuggestion(DocumentItemContainer container, boolean required) {
            super(container, required);
        }

        @Override
        public void createControls(Composite parent) {
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Text Content (" + (this.isRequired() ? "Required" : "Optional") + ")");
            nameLabel.setLayoutData((Object)new GridData(768));
            nameLabel.addMouseListener(new MouseListener(){

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    SoapInputDocumentPropertiesPanel.this.markOrigin();
                    try {
                        TextSuggestion.this.getContainer().insertItem((DocumentItem)new TextDocumentItem(SoapInputDocumentPropertiesPanel.this.manager), TextSuggestion.this.getInsertionPoint());
                        SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
    }

    public class UIConditionalContent
    extends UIContentContainer {
        private ConditionalDocumentItem ifItem;
        private Text conditionText;
        private boolean elseif;
        private Composite propertiesComp;
        private Composite container;
        private Twistie propertiesExpander;
        private Twistie contentsExpander;

        public UIConditionalContent(UIContentComposite scoping, Composite parent, boolean composing) {
            super(scoping, parent, 14, composing);
            this.ifItem = null;
            this.conditionText = null;
            this.elseif = false;
            this.propertiesComp = null;
            this.container = null;
            this.propertiesExpander = null;
            this.contentsExpander = null;
            this.setIcon(Activator.getDefault().getImageRegistry().get("SCRIPT"));
            Composite bodyComp = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            bodyComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 15;
            bodyComp.setLayoutData((Object)gd);
            this.propertiesExpander = new Twistie(bodyComp, 524288);
            this.propertiesExpander.setExpanded(true);
            Label propertiesIconLabel = new Label(bodyComp, 0);
            propertiesIconLabel.setImage(Activator.getDefault().getImageRegistry().get("ATTRIBUTE_GROUP"));
            propertiesIconLabel.setLayoutData((Object)new GridData());
            Label propertiesLabel = new Label(bodyComp, 0);
            propertiesLabel.setText("Properties");
            propertiesLabel.setLayoutData((Object)new GridData(768));
            this.propertiesComp = new Composite(bodyComp, 0);
            this.propertiesExpander.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    GridData gd = (GridData)UIConditionalContent.this.propertiesComp.getLayoutData();
                    gd.exclude = !UIConditionalContent.this.propertiesExpander.isExpanded();
                    UIConditionalContent.this.propertiesComp.setVisible(UIConditionalContent.this.propertiesExpander.isExpanded());
                    SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                    HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIConditionalContent.this.ifItem);
                    if (states == null) {
                        states = new HashMap<String, Boolean>();
                        SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIConditionalContent.this.ifItem, states);
                    }
                    states.put("properties", UIConditionalContent.this.propertiesExpander.isExpanded());
                }
            });
            this.propertiesComp.setLayout((Layout)new GridLayout(2, false));
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = 3;
            layoutData.horizontalIndent = 17;
            this.propertiesComp.setLayoutData((Object)layoutData);
            Label conditionLabel = new Label(this.propertiesComp, 0);
            conditionLabel.setText("Condition");
            conditionLabel.setLayoutData((Object)new GridData());
            this.conditionText = new Text(this.propertiesComp, 2052);
            this.conditionText.setLayoutData((Object)new GridData(768));
            this.conditionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UIConditionalContent.this.ifItem.setCondition(UIConditionalContent.this.conditionText.getText());
                }
            });
            this.contentsExpander = new Twistie(bodyComp, 524288);
            this.contentsExpander.setExpanded(true);
            Label contentsIconLabel = new Label(bodyComp, 0);
            contentsIconLabel.setImage(Activator.getDefault().getImageRegistry().get("COMPLEX_TYPE"));
            contentsIconLabel.setLayoutData((Object)new GridData());
            Label contentsLabel = new Label(bodyComp, 0);
            contentsLabel.setText("Contents");
            contentsLabel.setLayoutData((Object)new GridData(768));
            this.container = new Composite(bodyComp, 0);
            this.contentsExpander.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    GridData gd = (GridData)UIConditionalContent.this.container.getLayoutData();
                    gd.exclude = !UIConditionalContent.this.contentsExpander.isExpanded();
                    UIConditionalContent.this.container.setVisible(UIConditionalContent.this.contentsExpander.isExpanded());
                    HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIConditionalContent.this.ifItem);
                    if (states == null) {
                        states = new HashMap<String, Boolean>();
                        SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIConditionalContent.this.ifItem, states);
                    }
                    states.put("contents", UIConditionalContent.this.contentsExpander.isExpanded());
                    SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                }
            });
            layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            this.container.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.horizontalIndent = 17;
            this.container.setLayoutData((Object)gd);
        }

        @Override
        public Composite getContainerComposite() {
            return this.container;
        }

        public void setElseIf(boolean elseif) {
            this.elseif = elseif;
            int flags = this.getButtonFlags();
            List<ConditionalDocumentItem> elseifs = ((ConditionalContainerSet)this.ifItem.getParent()).getElseIfs();
            if (elseif) {
                this.setTitle("ELSE IF");
                flags |= 4;
                int i = 0;
                while (i < elseifs.size() - 1) {
                    if (elseifs.get(i).equals(this.ifItem)) {
                        flags |= 8;
                        break;
                    }
                    ++i;
                }
            } else {
                this.setTitle("IF");
                if (elseifs.size() > 0) {
                    flags |= 8;
                }
            }
            this.updateButtons(flags);
        }

        public void setContent(ConditionalDocumentItem ifItem) {
            this.ifItem = ifItem;
            Map states = (Map)SoapInputDocumentPropertiesPanel.this.expansionStates.get(ifItem);
            if (states != null) {
                Boolean state = (Boolean)states.get("properties");
                if (state == null) {
                    state = true;
                }
                this.propertiesExpander.setExpanded(state.booleanValue());
                GridData gd = (GridData)this.propertiesComp.getLayoutData();
                gd.exclude = !this.propertiesExpander.isExpanded();
                this.propertiesComp.setVisible(this.propertiesExpander.isExpanded());
                state = (Boolean)states.get("contents");
                if (state == null) {
                    state = true;
                }
                this.contentsExpander.setExpanded(state.booleanValue());
                gd = (GridData)this.container.getLayoutData();
                gd.exclude = !this.contentsExpander.isExpanded();
                this.container.setVisible(this.contentsExpander.isExpanded());
                SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
            }
            this.conditionText.setText(ifItem.getCondition() == null ? "" : ifItem.getCondition());
        }

        @Override
        protected void delete() {
            ConditionalContainerSet parent = (ConditionalContainerSet)this.ifItem.getParent();
            if (this.elseif) {
                parent.removeItem(this.ifItem);
                SoapInputDocumentPropertiesPanel.this.expansionStates.remove(this.ifItem);
            } else {
                List<ConditionalDocumentItem> elseIfs = parent.getElseIfs();
                if (elseIfs.size() > 0) {
                    ConditionalDocumentItem firstElseIf = elseIfs.get(0);
                    parent.removeItem(firstElseIf);
                    SoapInputDocumentPropertiesPanel.this.expansionStates.remove(this.ifItem);
                    parent.setIf(firstElseIf);
                } else {
                    SoapInputDocumentPropertiesPanel.this.expansionStates.remove(parent.getIf());
                    for (ConditionalDocumentItem elseIf : parent.getElseIfs()) {
                        SoapInputDocumentPropertiesPanel.this.expansionStates.remove(elseIf);
                    }
                    if (parent.getElse() != null) {
                        SoapInputDocumentPropertiesPanel.this.expansionStates.remove(parent.getElse());
                    }
                    parent.getParent().removeItem(parent);
                }
            }
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }

        @Override
        protected void moveUp() {
            ConditionalContainerSet parent = (ConditionalContainerSet)this.ifItem.getParent();
            List<ConditionalDocumentItem> elseIfs = parent.getElseIfs();
            int i = 0;
            while (i < elseIfs.size()) {
                if (elseIfs.get(i).equals(this.ifItem)) break;
                ++i;
            }
            if (i == 0) {
                ConditionalDocumentItem oi = parent.getIf();
                parent.removeItem(this.ifItem);
                parent.setIf(this.ifItem);
                parent.insertItem(oi, 0);
            } else {
                parent.removeItem(this.ifItem);
                parent.insertItem(this.ifItem, i - 1);
            }
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }

        @Override
        protected void moveDown() {
            ConditionalContainerSet parent = (ConditionalContainerSet)this.ifItem.getParent();
            if (!this.elseif) {
                ConditionalDocumentItem oi = parent.getElseIfs().get(0);
                parent.removeItem(oi);
                parent.setIf(oi);
                parent.insertItem(this.ifItem, 0);
            } else {
                List<ConditionalDocumentItem> elseIfs = parent.getElseIfs();
                int i = 0;
                while (i < elseIfs.size() - 1) {
                    if (elseIfs.get(i).equals(this.ifItem)) break;
                    ++i;
                }
                parent.removeItem(this.ifItem);
                parent.insertItem(this.ifItem, i + 1);
            }
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }

        @Override
        protected void populateDeleteMenu(Menu menu) {
            final ConditionalContainerSet parent = (ConditionalContainerSet)this.ifItem.getParent();
            if (parent != null) {
                if (!this.elseif) {
                    MenuItem removeEntireSet = new MenuItem(menu, 0);
                    removeEntireSet.setText("Remove Entire Conditional Set");
                    removeEntireSet.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            parent.getParent().removeItem(parent);
                            SoapInputDocumentPropertiesPanel.this.markOrigin();
                            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
                            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
                        }
                    });
                }
                if (parent.getElseIfs().size() > 0) {
                    MenuItem removeConditional = new MenuItem(menu, 0);
                    removeConditional.setText("Remove This Condition");
                    removeConditional.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            UIConditionalContent.this.delete();
                        }
                    });
                }
            }
        }
    }

    public class UIContentComposite
    extends Composite {
        public static final int SINGLE_DELETE = 1;
        public static final int COMPLEX_DELETE = 2;
        public static final int MOVE_UP = 4;
        public static final int MOVE_DOWN = 8;
        public static final int MOVE_OUT = 16;
        public static final int MOVE_IN = 32;
        private int depth;
        private int order;
        private int buttonFlags;
        private boolean validated;
        private boolean composing;
        private Color borderColor;
        protected Color accentColor;
        private Image icon;
        private String title;
        private Composite titleComp;
        private Label iconLabel;
        private Label titleLabel;
        private CoolBar coolBar;
        private ToolBar buttonBar;
        private ToolItem deleteItem;
        private ToolItem moveDownItem;
        private ToolItem moveUpItem;
        private ToolItem moveInItem;
        private ToolItem moveOutItem;
        private UIContentComposite scoping;

        public UIContentComposite(UIContentComposite scoping, Composite parent, int style, boolean composing) {
            super(parent, 0);
            this.depth = 0;
            this.order = 0;
            this.buttonFlags = 0;
            this.validated = true;
            this.composing = true;
            this.borderColor = null;
            this.accentColor = null;
            this.icon = null;
            this.title = null;
            this.titleComp = null;
            this.iconLabel = null;
            this.titleLabel = null;
            this.coolBar = null;
            this.buttonBar = null;
            this.deleteItem = null;
            this.moveDownItem = null;
            this.moveUpItem = null;
            this.moveInItem = null;
            this.moveOutItem = null;
            this.scoping = null;
            this.scoping = scoping;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC g = e.gc;
                    Color oldForground = g.getForeground();
                    g.setForeground(UIContentComposite.this.borderColor);
                    g.drawLine(0, 0, UIContentComposite.this.getSize().x - 10, 0);
                    g.drawLine(0, 0, 0, UIContentComposite.this.getSize().y - 10);
                    g.setForeground(oldForground);
                }
            });
            this.buttonFlags = style & 3;
            this.composing = composing;
            this.setBackgroundMode(1);
            this.borderColor = new Color((Device)this.getDisplay(), 231, 233, 238);
            this.accentColor = new Color((Device)this.getDisplay(), 246, 249, 254);
            this.setLayoutData(new GridData(768));
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginLeft = 0;
            layout.verticalSpacing = 0;
            this.setLayout((Layout)layout);
            this.titleComp = new Composite((Composite)this, 0);
            layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.titleComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 7;
            this.titleComp.setLayoutData((Object)gd);
            this.iconLabel = new Label(this.titleComp, 0);
            this.iconLabel.setText("");
            gd = new GridData();
            this.iconLabel.setLayoutData((Object)gd);
            this.titleLabel = new Label(this.titleComp, 0);
            this.titleLabel.setLayoutData((Object)new GridData(768));
            this.coolBar = new CoolBar(this.titleComp, 0x800100);
            this.coolBar.setLocked(true);
            this.buttonBar = new ToolBar((Composite)this.coolBar, 0x800000);
            CoolItem buttonBarItem = new CoolItem(this.coolBar, 0);
            buttonBarItem.setControl((Control)this.buttonBar);
            if ((style & 0x10) > 0) {
                this.moveOutItem = new ToolItem(this.buttonBar, 8);
                this.moveOutItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        UIContentComposite.this.moveOut();
                    }
                });
                this.moveOutItem.setEnabled(false);
            }
            if ((style & 0x20) > 0) {
                this.moveInItem = new ToolItem(this.buttonBar, 8);
                this.moveInItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        UIContentComposite.this.moveIn();
                    }
                });
                this.moveInItem.setEnabled(false);
            }
            if ((style & 4) > 0) {
                this.moveUpItem = new ToolItem(this.buttonBar, 8);
                this.moveUpItem.setImage(Activator.getDefault().getImageRegistry().get("MOVE_UP"));
                this.moveUpItem.setDisabledImage(Activator.getDefault().getImageRegistry().get("MOVE_UP_DISABLED"));
                this.moveUpItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        UIContentComposite.this.moveUp();
                    }
                });
                this.moveUpItem.setEnabled(false);
            }
            if ((style & 8) > 0) {
                this.moveDownItem = new ToolItem(this.buttonBar, 8);
                this.moveDownItem.setImage(Activator.getDefault().getImageRegistry().get("MOVE_DOWN"));
                this.moveDownItem.setDisabledImage(Activator.getDefault().getImageRegistry().get("MOVE_DOWN_DISABLED"));
                this.moveDownItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        UIContentComposite.this.moveDown();
                    }
                });
                this.moveDownItem.setEnabled(false);
            }
            if ((style & 1) > 0) {
                this.deleteItem = new ToolItem(this.buttonBar, 8);
            } else {
                this.deleteItem = new ToolItem(this.buttonBar, 4);
                this.deleteItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.detail == 4) {
                            final Menu menu = new Menu((Decorations)UIContentComposite.this.buttonBar.getShell(), 8);
                            UIContentComposite.this.populateDeleteMenu(menu);
                            Rectangle rect = UIContentComposite.this.deleteItem.getBounds();
                            Point pt = new Point(rect.x, rect.y + rect.height);
                            pt = UIContentComposite.this.buttonBar.toDisplay(pt);
                            menu.setLocation(pt.x, pt.y);
                            menu.setVisible(true);
                            menu.addMenuListener(new MenuListener(){

                                public void menuHidden(MenuEvent e) {
                                    menu.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            menu.dispose();
                                        }
                                    });
                                }

                                public void menuShown(MenuEvent e) {
                                }
                            });
                        }
                    }
                });
            }
            this.deleteItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail != 4) {
                        UIContentComposite.this.delete();
                    }
                }
            });
            this.deleteItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            this.buttonBar.pack();
            buttonBarItem.setSize(this.buttonBar.computeSize(-1, -1));
            this.coolBar.pack();
            gd = new GridData();
            Point size = this.coolBar.computeSize(-1, -1);
            gd.widthHint = size.x + 20;
            gd.heightHint = size.y;
            this.coolBar.setLayoutData((Object)gd);
        }

        public List<Variable> getVariableScope() {
            if (this.scoping != null) {
                return this.scoping.getVariableScope();
            }
            return SoapInputDocumentPropertiesPanel.this.variables;
        }

        protected void postScopeChange() {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof UIContentComposite) {
                    ((UIContentComposite)child).scopeChanged();
                }
                ++n2;
            }
        }

        protected void scopeChanged() {
            this.postScopeChange();
        }

        protected int getButtonFlags() {
            return this.buttonFlags;
        }

        protected void updateButtons(int buttonFlags) {
            boolean moveDown;
            this.buttonFlags = buttonFlags;
            boolean moveOut = (buttonFlags & 0x10) > 0;
            boolean moveIn = (buttonFlags & 0x20) > 0;
            boolean moveUp = (buttonFlags & 4) > 0;
            boolean bl = moveDown = (buttonFlags & 8) > 0;
            if (this.moveOutItem != null) {
                this.moveOutItem.setEnabled(moveOut);
            }
            if (this.moveInItem != null) {
                this.moveInItem.setEnabled(moveIn);
            }
            if (this.moveUpItem != null) {
                this.moveUpItem.setEnabled(moveUp);
            }
            if (this.moveDownItem != null) {
                this.moveDownItem.setEnabled(moveDown);
            }
        }

        public void dispose() {
            this.borderColor.dispose();
            this.accentColor.dispose();
            super.dispose();
        }

        public boolean isValidated() {
            return this.validated;
        }

        public void setValidated(boolean validated) {
            this.validated = validated;
            if (!validated) {
                this.titleLabel.setForeground(this.getDisplay().getSystemColor(3));
            }
        }

        public boolean isComposing() {
            return this.composing;
        }

        public void updateContext(IBrand brand) {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof UIContentComposite) {
                    ((UIContentComposite)c).updateContext(brand);
                }
                ++n2;
            }
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        public void setIcon(Image icon) {
            this.iconLabel.setImage(icon);
            ((GridData)this.iconLabel.getLayoutData()).exclude = icon == null;
            this.titleComp.layout(true, true);
        }

        protected void delete() {
        }

        protected void populateDeleteMenu(Menu menu) {
        }

        protected void moveUp() {
        }

        protected void moveDown() {
        }

        protected void moveOut() {
        }

        protected void moveIn() {
        }
    }

    public abstract class UIContentContainer
    extends UIContentComposite {
        public UIContentContainer(UIContentComposite scoping, Composite parent, int style, boolean composing) {
            super(scoping, parent, style, composing);
        }

        @Override
        protected void postScopeChange() {
            Control[] controlArray = this.getContainerComposite().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof UIContentComposite) {
                    ((UIContentComposite)child).scopeChanged();
                }
                ++n2;
            }
        }

        public abstract Composite getContainerComposite();
    }

    public class UIElementContent
    extends UIContentContainer
    implements BrandedUIItem {
        private boolean textOnly;
        private ElementDocumentItem elementItem;
        private TextDocumentItem textItem;
        private ValueStack valueStack;
        private Text contentArea;
        private boolean updating;
        private Composite container;
        private Composite contentsComp;
        private Label attributesIconLabel;
        private Label attributesLabel;
        private Composite attributesComp;
        private Twistie propertiesExpander;
        private Twistie contentsExpander;

        public UIElementContent(UIContentComposite scoping, Composite parent, boolean composing, boolean textOnly) {
            super(scoping, parent, 1, composing);
            this.textOnly = false;
            this.elementItem = null;
            this.textItem = null;
            this.valueStack = null;
            this.contentArea = null;
            this.updating = false;
            this.container = null;
            this.contentsComp = null;
            this.attributesIconLabel = null;
            this.attributesLabel = null;
            this.attributesComp = null;
            this.propertiesExpander = null;
            this.contentsExpander = null;
            this.setIcon(Activator.getDefault().getImageRegistry().get("XML_ELEMENT"));
            this.textOnly = textOnly;
            Composite bodyComp = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            bodyComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 15;
            bodyComp.setLayoutData((Object)gd);
            if (textOnly) {
                this.container = this;
                this.propertiesExpander = new Twistie(bodyComp, 524288);
                this.propertiesExpander.setExpanded(true);
                this.propertiesExpander.setLayoutData((Object)new GridData());
                this.attributesIconLabel = new Label(bodyComp, 0);
                this.attributesIconLabel.setImage(Activator.getDefault().getImageRegistry().get("ATTRIBUTE_GROUP"));
                this.attributesIconLabel.setLayoutData((Object)new GridData());
                this.attributesLabel = new Label(bodyComp, 0);
                this.attributesLabel.setText("Attributes");
                this.attributesLabel.setLayoutData((Object)new GridData(768));
                this.attributesComp = new Composite(bodyComp, 0);
                this.propertiesExpander.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        GridData gd = (GridData)UIElementContent.this.attributesComp.getLayoutData();
                        gd.exclude = !UIElementContent.this.propertiesExpander.isExpanded();
                        UIElementContent.this.attributesComp.setVisible(UIElementContent.this.propertiesExpander.isExpanded());
                        SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                        HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIElementContent.this.elementItem);
                        if (states == null) {
                            states = new HashMap<String, Boolean>();
                            SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIElementContent.this.elementItem, states);
                        }
                        states.put("attributes", UIElementContent.this.propertiesExpander.isExpanded());
                    }
                });
                this.attributesComp.setLayout((Layout)new GridLayout(3, false));
                GridData layoutData = new GridData(768);
                layoutData.horizontalSpan = 3;
                layoutData.horizontalIndent = 17;
                this.attributesComp.setLayoutData((Object)layoutData);
                this.contentsExpander = new Twistie(bodyComp, 524288);
                this.contentsExpander.setExpanded(true);
                this.contentsExpander.setLayoutData((Object)new GridData());
                Label contentsIconLabel = new Label(bodyComp, 0);
                contentsIconLabel.setImage(Activator.getDefault().getImageRegistry().get("COMPLEX_TYPE"));
                contentsIconLabel.setLayoutData((Object)new GridData());
                Label contentsLabel = new Label(bodyComp, 0);
                contentsLabel.setText("Contents");
                contentsLabel.setLayoutData((Object)new GridData(768));
                this.contentsComp = UIHelper.createWrapperComposite((Composite)bodyComp, (int)17);
                this.contentsExpander.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        GridData gd = (GridData)UIElementContent.this.contentsComp.getLayoutData();
                        gd.exclude = !UIElementContent.this.contentsExpander.isExpanded();
                        UIElementContent.this.contentsComp.setVisible(UIElementContent.this.contentsExpander.isExpanded());
                        HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIElementContent.this.elementItem);
                        if (states == null) {
                            states = new HashMap<String, Boolean>();
                            SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIElementContent.this.elementItem, states);
                        }
                        states.put("contents", UIElementContent.this.contentsExpander.isExpanded());
                        SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                    }
                });
                layout = (GridLayout)this.contentsComp.getLayout();
                layout.marginWidth = 5;
                this.contentsComp.setBackground(null);
                this.contentsComp.setBackgroundMode(1);
                this.contentsComp.setLayoutData((Object)new GridData(768));
                this.valueStack = new ValueStack("", "", this.getVariableScope());
                this.valueStack.createControls(this.contentsComp);
                this.contentArea = new Text(this.valueStack.getValueComposite(), 2304);
                this.valueStack.setValueControl(new ValueControl(){

                    public String getValue() {
                        return UIElementContent.this.contentArea.getText();
                    }

                    public void setValue(String value) {
                        UIElementContent.this.updating = true;
                        UIElementContent.this.contentArea.setText(value == null ? "" : value);
                        UIElementContent.this.updating = false;
                    }
                });
                this.contentArea.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Point size = UIElementContent.this.contentArea.computeSize(((UIElementContent)UIElementContent.this).contentArea.getSize().x, -1, true);
                        GridData gd = (GridData)UIElementContent.this.contentArea.getLayoutData();
                        gd.minimumHeight = Math.max(18, size.y);
                        if (!UIElementContent.this.updating) {
                            SoapInputDocumentPropertiesPanel.this.rootComp.setSize(SoapInputDocumentPropertiesPanel.this.rootComp.computeSize(((SoapInputDocumentPropertiesPanel)((UIElementContent)UIElementContent.this).SoapInputDocumentPropertiesPanel.this).scrollComp.getClientArea().width - 1, -1));
                            SoapInputDocumentPropertiesPanel.this.scrollComp.layout(true, true);
                        }
                    }
                });
                this.contentArea.addListener(37, new Listener(){

                    public void handleEvent(Event event) {
                        Point origin = SoapInputDocumentPropertiesPanel.this.scrollComp.getOrigin();
                        origin.y -= event.count;
                        event.doit = false;
                        SoapInputDocumentPropertiesPanel.this.scrollComp.setOrigin(origin);
                    }
                });
                gd = new GridData(768);
                gd.minimumHeight = 18;
                gd.widthHint = 5000;
                this.contentArea.setLayoutData((Object)gd);
                SoapInputDocumentPropertiesPanel.this.valueStacks.add(this);
                ((GridData)this.contentsComp.getLayoutData()).horizontalSpan = 3;
            } else {
                this.propertiesExpander = new Twistie(bodyComp, 524288);
                this.propertiesExpander.setExpanded(true);
                this.propertiesExpander.setLayoutData((Object)new GridData());
                Label attributesIconLabel = new Label(bodyComp, 0);
                attributesIconLabel.setImage(Activator.getDefault().getImageRegistry().get("ATTRIBUTE_GROUP"));
                attributesIconLabel.setLayoutData((Object)new GridData());
                Label attributesLabel = new Label(bodyComp, 0);
                attributesLabel.setText("Attributes");
                attributesLabel.setLayoutData((Object)new GridData(768));
                this.attributesComp = new Composite(bodyComp, 0);
                this.propertiesExpander.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        GridData gd = (GridData)UIElementContent.this.attributesComp.getLayoutData();
                        gd.exclude = !UIElementContent.this.propertiesExpander.isExpanded();
                        UIElementContent.this.attributesComp.setVisible(UIElementContent.this.propertiesExpander.isExpanded());
                        SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                        HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIElementContent.this.elementItem);
                        if (states == null) {
                            states = new HashMap<String, Boolean>();
                            SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIElementContent.this.elementItem, states);
                        }
                        states.put("attributes", UIElementContent.this.propertiesExpander.isExpanded());
                    }
                });
                this.attributesComp.setLayout((Layout)new GridLayout(3, false));
                GridData layoutData = new GridData(768);
                layoutData.horizontalSpan = 3;
                layoutData.horizontalIndent = 17;
                this.attributesComp.setLayoutData((Object)layoutData);
                this.contentsExpander = new Twistie(bodyComp, 524288);
                this.contentsExpander.setExpanded(true);
                this.contentsExpander.setLayoutData((Object)new GridData());
                Label contentsIconLabel = new Label(bodyComp, 0);
                contentsIconLabel.setImage(Activator.getDefault().getImageRegistry().get("COMPLEX_TYPE"));
                contentsIconLabel.setLayoutData((Object)new GridData());
                Label contentsLabel = new Label(bodyComp, 0);
                contentsLabel.setText("Contents");
                contentsLabel.setLayoutData((Object)new GridData(768));
                this.container = this.contentsComp = new Composite(bodyComp, 0);
                this.contentsExpander.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        GridData gd = (GridData)UIElementContent.this.contentsComp.getLayoutData();
                        gd.exclude = !UIElementContent.this.contentsExpander.isExpanded();
                        UIElementContent.this.contentsComp.setVisible(UIElementContent.this.contentsExpander.isExpanded());
                        HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIElementContent.this.elementItem);
                        if (states == null) {
                            states = new HashMap<String, Boolean>();
                            SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIElementContent.this.elementItem, states);
                        }
                        states.put("contents", UIElementContent.this.contentsExpander.isExpanded());
                        SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                    }
                });
                layout = new GridLayout(1, false);
                layout.marginWidth = 0;
                layout.marginLeft = 5;
                this.contentsComp.setLayout((Layout)layout);
                gd = new GridData(768);
                gd.horizontalIndent = 17;
                gd.horizontalSpan = 3;
                this.contentsComp.setLayoutData((Object)gd);
            }
        }

        @Override
        public Composite getContainerComposite() {
            return this.container;
        }

        @Override
        public BrandedBinding getBinding() {
            return this.textItem;
        }

        @Override
        protected void scopeChanged() {
            if (this.textOnly) {
                this.valueStack.setVariables(this.getVariableScope());
            } else {
                super.scopeChanged();
            }
        }

        @Override
        public ValueStack getValueStack() {
            return this.valueStack;
        }

        public void setContent(ElementDocumentItem elementItem) {
            this.elementItem = elementItem;
            this.setTitle(elementItem.getName());
            HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(elementItem);
            if (states != null) {
                Boolean state = (Boolean)states.get("attributes");
                if (state == null) {
                    state = true;
                }
                this.propertiesExpander.setExpanded(state.booleanValue());
                GridData gd = (GridData)this.attributesComp.getLayoutData();
                gd.exclude = !this.propertiesExpander.isExpanded();
                this.attributesComp.setVisible(this.propertiesExpander.isExpanded());
                state = (Boolean)states.get("contents");
                if (state == null) {
                    state = true;
                }
                this.contentsExpander.setExpanded(state.booleanValue());
                gd = (GridData)this.contentsComp.getLayoutData();
                gd.exclude = !this.contentsExpander.isExpanded();
                this.contentsComp.setVisible(this.contentsExpander.isExpanded());
                SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
            }
            if (elementItem.isSimple()) {
                ((GridData)this.propertiesExpander.getLayoutData()).exclude = true;
                this.propertiesExpander.setVisible(false);
                ((GridData)this.attributesIconLabel.getLayoutData()).exclude = true;
                this.attributesIconLabel.setVisible(false);
                ((GridData)this.attributesLabel.getLayoutData()).exclude = true;
                this.attributesLabel.setVisible(false);
                ((GridData)this.attributesComp.getLayoutData()).exclude = true;
                this.attributesComp.setVisible(false);
                this.layout();
                return;
            }
            List<ElementAttributeDocumentItem> attributes = elementItem.getAttributes();
            for (ElementAttributeDocumentItem attribute : attributes) {
                Button attributePresent = new Button(this.attributesComp, 32);
                attributePresent.setLayoutData((Object)new GridData());
                Label attributeName = new Label(this.attributesComp, 0);
                attributeName.setText(attribute.getName());
                attributeName.setLayoutData((Object)new GridData());
                attributePresent.setSelection(!attribute.isOptional() || attribute.isPresent());
                final ValueStack attributeValueStack = new ValueStack("", "", this.getVariableScope());
                attributeValueStack.createControls(this.attributesComp);
                final Text valueText = new Text(attributeValueStack.getValueComposite(), 2052);
                attributeValueStack.setValueControl(new ValueControl(){

                    public String getValue() {
                        return valueText.getText();
                    }

                    public void setValue(String value) {
                        valueText.setText(value == null ? "" : value);
                    }
                });
                GridData gd = new GridData(768);
                gd.minimumHeight = 18;
                gd.widthHint = 5000;
                valueText.setLayoutData((Object)gd);
                final ElementAttributeDocumentItem attributeRef = attribute;
                SoapInputDocumentPropertiesPanel.this.valueStacks.add(new BrandedUIItem(){

                    @Override
                    public BrandedBinding getBinding() {
                        return attributeRef;
                    }

                    @Override
                    public ValueStack getValueStack() {
                        return attributeValueStack;
                    }
                });
            }
            if (attributes.size() == 0) {
                if (states == null) {
                    states = new HashMap<String, Boolean>();
                    SoapInputDocumentPropertiesPanel.this.expansionStates.put(elementItem, states);
                }
                states.put("attributes", false);
                Label noAttributesLabel = new Label(this.attributesComp, 0);
                noAttributesLabel.setText("None");
                GridData gd = new GridData(768);
                gd.horizontalSpan = 3;
                noAttributesLabel.setLayoutData((Object)gd);
                this.propertiesExpander.setExpanded(false);
                gd = (GridData)this.attributesComp.getLayoutData();
                gd.exclude = !this.propertiesExpander.isExpanded();
                this.attributesComp.setVisible(this.propertiesExpander.isExpanded());
                SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
            }
        }

        public void setText(TextDocumentItem textItem) {
            if (this.textOnly) {
                this.textItem = textItem;
            }
        }

        @Override
        protected void delete() {
            this.elementItem.getParent().removeItem(this.elementItem);
            SoapInputDocumentPropertiesPanel.this.expansionStates.remove(this.elementItem);
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }

        public boolean isTextOnly() {
            return this.textOnly;
        }
    }

    public class UIElseContent
    extends UIContentContainer {
        private ElseDocumentItem elseItem;
        private Composite container;
        private Twistie contentsExpander;

        public UIElseContent(UIContentComposite scoping, Composite parent, boolean composing) {
            super(scoping, parent, 1, composing);
            this.elseItem = null;
            this.container = null;
            this.contentsExpander = null;
            this.setTitle("Else");
            Composite bodyComp = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            bodyComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 15;
            bodyComp.setLayoutData((Object)gd);
            this.contentsExpander = new Twistie(bodyComp, 524288);
            this.contentsExpander.setExpanded(true);
            Label contentsIconLabel = new Label(bodyComp, 0);
            contentsIconLabel.setImage(Activator.getDefault().getImageRegistry().get("COMPLEX_TYPE"));
            contentsIconLabel.setLayoutData((Object)new GridData());
            Label contentsLabel = new Label(bodyComp, 0);
            contentsLabel.setText("Contents");
            contentsLabel.setLayoutData((Object)new GridData(768));
            this.container = new Composite(bodyComp, 0);
            this.contentsExpander.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    GridData gd = (GridData)UIElseContent.this.container.getLayoutData();
                    gd.exclude = !UIElseContent.this.contentsExpander.isExpanded();
                    UIElseContent.this.container.setVisible(UIElseContent.this.contentsExpander.isExpanded());
                    HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIElseContent.this.elseItem);
                    if (states == null) {
                        states = new HashMap<String, Boolean>();
                        SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIElseContent.this.elseItem, states);
                    }
                    states.put("contents", UIElseContent.this.contentsExpander.isExpanded());
                    SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                }
            });
            this.container.setLayout((Layout)new GridLayout(1, false));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.horizontalIndent = 17;
            this.container.setLayoutData((Object)gd);
        }

        @Override
        public Composite getContainerComposite() {
            return this.container;
        }

        public void setContent(ElseDocumentItem elseItem) {
            this.elseItem = elseItem;
            Map states = (Map)SoapInputDocumentPropertiesPanel.this.expansionStates.get(elseItem);
            if (states != null) {
                Boolean state = (Boolean)states.get("contents");
                if (state == null) {
                    state = true;
                }
                this.contentsExpander.setExpanded(state.booleanValue());
                GridData gd = (GridData)this.container.getLayoutData();
                gd.exclude = !this.contentsExpander.isExpanded();
                this.container.setVisible(this.contentsExpander.isExpanded());
                SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
            }
        }

        @Override
        protected void delete() {
            ((ConditionalContainerSet)this.elseItem.getParent()).setElse(null);
            SoapInputDocumentPropertiesPanel.this.expansionStates.remove(this.elseItem);
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }
    }

    public class UIForContent
    extends UIContentContainer {
        private ForLoopDocumentItem forItem;
        private Text arrayNameText;
        private Button browseButton;
        private Text varNameText;
        private List<Variable> parentScope;
        private ObjectDefinition arraySelection;
        private Variable cursorVariable;
        private boolean updating;
        private Twistie propertiesExpander;
        private Composite propertiesComp;
        private Twistie contentsExpander;
        private Composite container;

        public UIForContent(UIContentComposite scoping, Composite parent, boolean composing) {
            super(scoping, parent, 1, composing);
            this.forItem = null;
            this.arrayNameText = null;
            this.browseButton = null;
            this.varNameText = null;
            this.parentScope = null;
            this.arraySelection = null;
            this.cursorVariable = null;
            this.updating = false;
            this.propertiesExpander = null;
            this.propertiesComp = null;
            this.contentsExpander = null;
            this.container = null;
            this.cursorVariable = new Variable("forLoopCursor", FieldType.STRING);
            VariableHelper.buildObjectFields((ObjectDefinition)this.cursorVariable, (IBusinessObjectSet)SoapInputDocumentPropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
            this.parentScope = super.getVariableScope();
            this.setTitle("For Each");
            Composite bodyComp = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            bodyComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 15;
            bodyComp.setLayoutData((Object)gd);
            this.propertiesExpander = new Twistie(bodyComp, 524288);
            this.propertiesExpander.setExpanded(true);
            Label propertiesIconLabel = new Label(bodyComp, 0);
            propertiesIconLabel.setImage(Activator.getDefault().getImageRegistry().get("ATTRIBUTE_GROUP"));
            propertiesIconLabel.setLayoutData((Object)new GridData());
            Label propertiesLabel = new Label(bodyComp, 0);
            propertiesLabel.setText("Properties");
            propertiesLabel.setLayoutData((Object)new GridData(768));
            this.propertiesComp = new Composite(bodyComp, 0);
            this.propertiesExpander.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    GridData gd = (GridData)UIForContent.this.propertiesComp.getLayoutData();
                    gd.exclude = !UIForContent.this.propertiesExpander.isExpanded();
                    UIForContent.this.propertiesComp.setVisible(UIForContent.this.propertiesExpander.isExpanded());
                    SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                    HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIForContent.this.forItem);
                    if (states == null) {
                        states = new HashMap<String, Boolean>();
                        SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIForContent.this.forItem, states);
                    }
                    states.put("properties", UIForContent.this.propertiesExpander.isExpanded());
                }
            });
            this.propertiesComp.setLayout((Layout)new GridLayout(2, false));
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = 3;
            layoutData.horizontalIndent = 17;
            this.propertiesComp.setLayoutData((Object)layoutData);
            Label sourceNameLabel = new Label(this.propertiesComp, 0);
            sourceNameLabel.setText("Object In");
            sourceNameLabel.setLayoutData((Object)new GridData());
            Composite browseComp = new Composite(this.propertiesComp, 0);
            browseComp.setLayout((Layout)new GridLayout(2, false));
            browseComp.setLayoutData((Object)new GridData(768));
            this.arrayNameText = new Text(browseComp, 2052);
            this.arrayNameText.setLayoutData((Object)new GridData(768));
            this.arrayNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!UIForContent.this.updating) {
                        UIForContent.this.arraySelection = null;
                        String[] parts = UIForContent.this.arrayNameText.getText().split("\\.");
                        LinkedList<Variable> defs = new LinkedList<Variable>(UIForContent.this.getVariableScope());
                        int i = 0;
                        block0: while (i < parts.length) {
                            for (ObjectDefinition objectDefinition : defs) {
                                if (!objectDefinition.getName().equals(parts[i]) || i != parts.length - 1) continue;
                                UIForContent.this.arrayNameText.setBackground(null);
                                UIForContent.this.forItem.setForEach(UIForContent.this.cursorVariable.getName(), objectDefinition.getPath());
                                UIForContent.this.arraySelection = objectDefinition;
                                break block0;
                            }
                            ++i;
                        }
                        if (UIForContent.this.arraySelection == null) {
                            UIForContent.this.arrayNameText.setBackground(UIForContent.this.getDisplay().getSystemColor(3));
                            UIForContent.this.forItem.setForEach(UIForContent.this.cursorVariable.getName(), null);
                        }
                        UIForContent.this.updateCursor();
                    }
                }
            });
            this.browseButton = new Button(browseComp, 8);
            this.browseButton.setText("pick");
            this.browseButton.setLayoutData((Object)new GridData());
            this.browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    VariableBrowserDialog browserDialog = new VariableBrowserDialog(UIForContent.this.getDisplay().getActiveShell(), UIForContent.super.getVariableScope());
                    browserDialog.setFilter(new ObjectDefinitionFilter(){

                        @Override
                        public boolean isApplicable(ObjectDefinition definition) {
                            return !definition.getType().isObject() && definition.getType().getPrimitiveType() == FieldType.Primitive.ARRAY;
                        }
                    });
                    if (browserDialog.open() == 0) {
                        UIForContent.this.updating = true;
                        UIForContent.this.arraySelection = browserDialog.getSelectedDefinition();
                        if (UIForContent.this.arraySelection != null) {
                            UIForContent.this.arrayNameText.setText(UIForContent.this.arraySelection.getPath());
                            UIForContent.this.arrayNameText.setBackground(null);
                            UIForContent.this.forItem.setForEach(UIForContent.this.cursorVariable.getName(), UIForContent.this.arraySelection.getPath());
                        } else {
                            UIForContent.this.arrayNameText.setText("");
                            UIForContent.this.arrayNameText.setBackground(UIForContent.this.getDisplay().getSystemColor(3));
                            UIForContent.this.forItem.setForEach(UIForContent.this.cursorVariable.getName(), null);
                        }
                        UIForContent.this.updateCursor();
                        UIForContent.this.updating = false;
                    }
                }
            });
            Label varNameLabel = new Label(this.propertiesComp, 0);
            varNameLabel.setText("Called");
            varNameLabel.setLayoutData((Object)new GridData());
            this.varNameText = new Text(this.propertiesComp, 2052);
            this.varNameText.setLayoutData((Object)new GridData(768));
            this.varNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UIForContent.this.forItem.setForEach(UIForContent.this.varNameText.getText(), UIForContent.this.arraySelection == null ? null : UIForContent.this.arraySelection.getPath());
                    UIForContent.this.updateCursor();
                }
            });
            this.contentsExpander = new Twistie(bodyComp, 524288);
            this.contentsExpander.setExpanded(true);
            Label contentsIconLabel = new Label(bodyComp, 0);
            contentsIconLabel.setImage(Activator.getDefault().getImageRegistry().get("COMPLEX_TYPE"));
            contentsIconLabel.setLayoutData((Object)new GridData());
            Label contentsLabel = new Label(bodyComp, 0);
            contentsLabel.setText("Contents");
            contentsLabel.setLayoutData((Object)new GridData(768));
            this.container = new Composite(bodyComp, 0);
            this.contentsExpander.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    GridData gd = (GridData)UIForContent.this.container.getLayoutData();
                    gd.exclude = !UIForContent.this.contentsExpander.isExpanded();
                    UIForContent.this.container.setVisible(UIForContent.this.contentsExpander.isExpanded());
                    HashMap<String, Boolean> states = (HashMap<String, Boolean>)SoapInputDocumentPropertiesPanel.this.expansionStates.get(UIForContent.this.forItem);
                    if (states == null) {
                        states = new HashMap<String, Boolean>();
                        SoapInputDocumentPropertiesPanel.this.expansionStates.put(UIForContent.this.forItem, states);
                    }
                    states.put("contents", UIForContent.this.contentsExpander.isExpanded());
                    SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
                }
            });
            layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            this.container.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.horizontalIndent = 17;
            this.container.setLayoutData((Object)gd);
        }

        @Override
        public Composite getContainerComposite() {
            return this.container;
        }

        private void updateCursor() {
            System.out.println("updating variable: " + this.cursorVariable);
            FieldType oldType = this.cursorVariable.getType();
            String oldName = this.cursorVariable.getName();
            this.cursorVariable.setName(this.varNameText.getText());
            if (this.arraySelection == null) {
                this.cursorVariable.setType(FieldType.STRING);
                this.cursorVariable.clearFields();
                VariableHelper.buildObjectFields((ObjectDefinition)this.cursorVariable, (IBusinessObjectSet)SoapInputDocumentPropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
            } else {
                FieldType arrayType = this.arraySelection.getType();
                if (arrayType.isObjectBaseType()) {
                    this.cursorVariable.setType(new FieldType(arrayType.getObjectBaseType()));
                } else {
                    this.cursorVariable.setType(new FieldType(arrayType.getPrimitiveBaseType()));
                }
                this.cursorVariable.clearFields();
                VariableHelper.buildObjectFields((ObjectDefinition)this.cursorVariable, (IBusinessObjectSet)SoapInputDocumentPropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
            }
            if (!this.cursorVariable.getName().equals(oldName)) {
                SoapInputDocumentPropertiesPanel.this.variableScopes.remove((Object)this);
            }
            this.postScopeChange();
        }

        @Override
        protected void scopeChanged() {
            SoapInputDocumentPropertiesPanel.this.variableScopes.remove((Object)this);
            this.arrayNameText.setText(this.arraySelection.getPath());
            this.varNameText.setText(this.varNameText.getText());
        }

        @Override
        public synchronized List<Variable> getVariableScope() {
            List<Variable> scope = SoapInputDocumentPropertiesPanel.this.variableScopes.get((Object)this);
            if (scope == null) {
                scope = new ArrayList<Variable>();
                scope.add(this.cursorVariable);
                List<Variable> parentScope = super.getVariableScope();
                for (Variable var : parentScope) {
                    if (var.getName().equals(this.cursorVariable.getName())) continue;
                    scope.add(var);
                }
                SoapInputDocumentPropertiesPanel.this.variableScopes.put(this, scope);
            }
            return scope;
        }

        public void setContent(ForLoopDocumentItem ifItem) {
            this.forItem = ifItem;
            Map states = (Map)SoapInputDocumentPropertiesPanel.this.expansionStates.get(ifItem);
            if (states != null) {
                Boolean state = (Boolean)states.get("properties");
                if (state == null) {
                    state = true;
                }
                this.propertiesExpander.setExpanded(state.booleanValue());
                GridData gd = (GridData)this.propertiesComp.getLayoutData();
                gd.exclude = !this.propertiesExpander.isExpanded();
                this.propertiesComp.setVisible(this.propertiesExpander.isExpanded());
                state = (Boolean)states.get("contents");
                if (state == null) {
                    state = true;
                }
                this.contentsExpander.setExpanded(state.booleanValue());
                gd = (GridData)this.container.getLayoutData();
                gd.exclude = !this.contentsExpander.isExpanded();
                this.container.setVisible(this.contentsExpander.isExpanded());
                SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
            }
            this.arrayNameText.setText(this.forItem.getTransform() == null ? "" : this.forItem.getTransform());
            this.varNameText.setText(this.forItem.getVariableName() == null ? "" : this.forItem.getVariableName());
        }

        @Override
        protected void delete() {
            this.forItem.getParent().removeItem(this.forItem);
            SoapInputDocumentPropertiesPanel.this.expansionStates.remove(this.forItem);
            SoapInputDocumentPropertiesPanel.this.markOrigin();
            SoapInputDocumentPropertiesPanel.this.buildDocumentDisplay();
            SoapInputDocumentPropertiesPanel.this.restoreOrigin();
        }
    }

    public class UISuggestionComposite
    extends Composite {
        private List<Suggestion> suggestions;
        boolean hasRequired;
        private Color borderColor;

        public UISuggestionComposite(Composite parent, int style) {
            super(parent, style);
            this.suggestions = new ArrayList<Suggestion>();
            this.hasRequired = false;
            this.borderColor = null;
            this.borderColor = new Color((Device)this.getDisplay(), 231, 233, 238);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC g = e.gc;
                    Color oldForground = g.getForeground();
                    g.setForeground(UISuggestionComposite.this.borderColor);
                    g.drawLine(0, 0, UISuggestionComposite.this.getSize().x - 10, 0);
                    g.drawLine(0, 0, 0, UISuggestionComposite.this.getSize().y - 10);
                    g.setForeground(oldForground);
                }
            });
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginLeft = 15;
            layout.marginBottom = 6;
            this.setLayout((Layout)layout);
            this.setLayoutData(new GridData(768));
        }

        public void addSuggestion(Suggestion suggestion) {
            this.suggestions.add(suggestion);
            if (this.hasRequired) {
                suggestion.setActive(false);
            }
            this.hasRequired |= suggestion.isRequired();
            suggestion.createControls(this);
            SoapInputDocumentPropertiesPanel.this.rootComp.layout(true, true);
        }

        public void dispose() {
            this.borderColor.dispose();
            super.dispose();
        }
    }

    public class UITextContent
    extends UIContentComposite
    implements BrandedUIItem {
        private TextDocumentItem textItem;
        private ValueStack valueStack;
        private Text contentArea;

        public UITextContent(UIContentComposite scoping, Composite parent, boolean composing) {
            super(scoping, parent, 1, composing);
            this.textItem = null;
            this.valueStack = null;
            this.contentArea = null;
            this.setTitle("Text Content");
            Composite bodyComp = UIHelper.createWrapperComposite((Composite)this, (int)0);
            bodyComp.setBackground(null);
            bodyComp.setBackgroundMode(1);
            bodyComp.setLayoutData((Object)new GridData(768));
            this.valueStack = new ValueStack("", "", this.getVariableScope());
            this.valueStack.createControls(bodyComp);
            this.contentArea = new Text(this.valueStack.getValueComposite(), 2304);
            this.valueStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return UITextContent.this.contentArea.getText();
                }

                public void setValue(String value) {
                    UITextContent.this.contentArea.setText(value == null ? "" : value);
                }
            });
            this.contentArea.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Point size = UITextContent.this.contentArea.computeSize(((UITextContent)UITextContent.this).contentArea.getSize().x, -1, true);
                    GridData gd = (GridData)UITextContent.this.contentArea.getLayoutData();
                    gd.minimumHeight = Math.max(18, size.y);
                    SoapInputDocumentPropertiesPanel.this.rootComp.setSize(SoapInputDocumentPropertiesPanel.this.rootComp.computeSize(((SoapInputDocumentPropertiesPanel)((UITextContent)UITextContent.this).SoapInputDocumentPropertiesPanel.this).scrollComp.getClientArea().width - 1, -1));
                    SoapInputDocumentPropertiesPanel.this.scrollComp.layout(true, true);
                }
            });
            this.contentArea.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    Point origin = SoapInputDocumentPropertiesPanel.this.scrollComp.getOrigin();
                    origin.y -= event.count;
                    event.doit = false;
                    SoapInputDocumentPropertiesPanel.this.scrollComp.setOrigin(origin);
                }
            });
            GridData gd = new GridData(768);
            gd.minimumHeight = 18;
            gd.widthHint = 300;
            this.contentArea.setLayoutData((Object)gd);
            SoapInputDocumentPropertiesPanel.this.valueStacks.add(this);
        }

        public void setContent(TextDocumentItem textItem) {
            this.textItem = textItem;
        }

        @Override
        public BrandedBinding getBinding() {
            return this.textItem;
        }

        @Override
        public ValueStack getValueStack() {
            return this.valueStack;
        }
    }
}

