/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWebserviceDescriptor;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.wsdl.BindingOperation;
import org.eclipse.vtp.desktop.model.core.wsdl.Port;
import org.eclipse.vtp.desktop.model.core.wsdl.Service;
import org.eclipse.vtp.desktop.model.core.wsdl.WSDL;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBinding;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBindingOperation;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceServiceBinding;
import org.eclipse.vtp.modules.webservice.ui.properties.IOperationListener;

public class SoapServiceSelectionPropertiesPanel
extends DesignElementPropertiesPanel {
    private static final String NO_DESCRIPTORS = "No descriptors available";
    private static final String NO_SERVICES = "No services available";
    private static final String NO_PORTS = "No ports available";
    private static final String NO_OPERATIONS = "No operations available";
    private WebserviceBindingManager manager = null;
    private WebserviceServiceBinding serviceBinding = null;
    private IWebserviceDescriptor currentDescriptor = null;
    private List<IWebserviceDescriptor> descriptors = null;
    private Service currentService = null;
    private List<Service> services = new ArrayList<Service>();
    private Port currentPort = null;
    private List<Port> ports = new ArrayList<Port>();
    private SoapBindingOperation currentBindingOperation = null;
    private List<BindingOperation> bindingOperations = new ArrayList<BindingOperation>();
    private Text nameField = null;
    private Text urlField = null;
    private ComboViewer descriptorCombo = null;
    private ComboViewer serviceCombo = null;
    private ComboViewer portCombo = null;
    private ComboViewer operationCombo = null;
    private boolean updating = false;
    private List<IOperationListener> listeners = new LinkedList<IOperationListener>();
    private String currentKey = null;

    public SoapServiceSelectionPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        this.descriptors = element.getDesign().getDocument().getProject().getWebserviceSet().getWebserviceDescriptors(true);
        this.manager = (WebserviceBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.webservicecall");
        this.serviceBinding = this.manager.getServiceBinding();
        this.currentKey = String.valueOf(this.serviceBinding.getDescriptor()) + ":" + this.serviceBinding.getService() + ":" + this.serviceBinding.getPort() + ":" + this.serviceBinding.getOperation();
        if (this.descriptors.size() > 0) {
            this.updateSelections();
        }
    }

    public void createControls(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setBackground(parent.getBackground());
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = toolkit.createSection(mainComp, 256);
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gd);
        contentSection.setText("General");
        Label nameLabel = new Label(mainComp, 0);
        nameLabel.setBackground(mainComp.getBackground());
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(mainComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        Label urlLabel = new Label(mainComp, 0);
        urlLabel.setBackground(mainComp.getBackground());
        urlLabel.setText("URL");
        urlLabel.setLayoutData((Object)new GridData());
        this.urlField = new Text(mainComp, 2052);
        this.urlField.setText(this.serviceBinding.getURL());
        this.urlField.setLayoutData((Object)new GridData(768));
        Section serviceSection = toolkit.createSection(mainComp, 256);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        serviceSection.setLayoutData((Object)gd);
        serviceSection.setText("Service Information");
        Label descriptorLabel = new Label(mainComp, 0);
        descriptorLabel.setBackground(mainComp.getBackground());
        descriptorLabel.setText("Descriptor");
        descriptorLabel.setLayoutData((Object)new GridData());
        this.descriptorCombo = new ComboViewer(new Combo(mainComp, 12));
        DescriptorContentLabelProvider dclp = new DescriptorContentLabelProvider();
        this.descriptorCombo.setContentProvider((IContentProvider)dclp);
        this.descriptorCombo.setLabelProvider((IBaseLabelProvider)dclp);
        this.descriptorCombo.setInput((Object)this);
        this.descriptorCombo.getCombo().setLayoutData((Object)new GridData(768));
        Label serviceLabel = new Label(mainComp, 0);
        serviceLabel.setBackground(mainComp.getBackground());
        serviceLabel.setText("Service");
        serviceLabel.setLayoutData((Object)new GridData());
        this.serviceCombo = new ComboViewer(new Combo(mainComp, 12));
        ServiceContentLabelProvider sclp = new ServiceContentLabelProvider();
        this.serviceCombo.setContentProvider((IContentProvider)sclp);
        this.serviceCombo.setLabelProvider((IBaseLabelProvider)sclp);
        this.serviceCombo.setInput((Object)this);
        this.serviceCombo.getCombo().setLayoutData((Object)new GridData(768));
        Label portLabel = new Label(mainComp, 0);
        portLabel.setBackground(mainComp.getBackground());
        portLabel.setText("Port");
        portLabel.setLayoutData((Object)new GridData());
        this.portCombo = new ComboViewer(new Combo(mainComp, 12));
        PortContentLabelProvider pclp = new PortContentLabelProvider();
        this.portCombo.setContentProvider((IContentProvider)pclp);
        this.portCombo.setLabelProvider((IBaseLabelProvider)pclp);
        this.portCombo.setInput((Object)this);
        this.portCombo.getCombo().setLayoutData((Object)new GridData(768));
        Label operationLabel = new Label(mainComp, 0);
        operationLabel.setBackground(mainComp.getBackground());
        operationLabel.setText("Operation");
        operationLabel.setLayoutData((Object)new GridData());
        this.operationCombo = new ComboViewer(new Combo(mainComp, 12));
        OperationContentLabelProvider oclp = new OperationContentLabelProvider();
        this.operationCombo.setContentProvider((IContentProvider)oclp);
        this.operationCombo.setLabelProvider((IBaseLabelProvider)oclp);
        this.operationCombo.setInput((Object)this);
        this.operationCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.descriptorCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("descriptor changed");
                if (!SoapServiceSelectionPropertiesPanel.this.updating && SoapServiceSelectionPropertiesPanel.this.currentDescriptor != null) {
                    SoapServiceSelectionPropertiesPanel.this.updating = true;
                    IWebserviceDescriptor descriptor = (IWebserviceDescriptor)((IStructuredSelection)SoapServiceSelectionPropertiesPanel.this.descriptorCombo.getSelection()).getFirstElement();
                    if (descriptor != SoapServiceSelectionPropertiesPanel.this.currentDescriptor) {
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setDescriptor(descriptor.getName());
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setService(null);
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setPort(null);
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setOperation(null);
                        SoapServiceSelectionPropertiesPanel.this.updateSelections();
                    }
                    SoapServiceSelectionPropertiesPanel.this.updating = false;
                }
            }
        });
        this.serviceCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("service changed");
                if (!SoapServiceSelectionPropertiesPanel.this.updating && SoapServiceSelectionPropertiesPanel.this.currentService != null) {
                    SoapServiceSelectionPropertiesPanel.this.updating = true;
                    Service service = (Service)((IStructuredSelection)SoapServiceSelectionPropertiesPanel.this.serviceCombo.getSelection()).getFirstElement();
                    if (service != SoapServiceSelectionPropertiesPanel.this.currentService) {
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setService(service.getName());
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setPort(null);
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setOperation(null);
                        SoapServiceSelectionPropertiesPanel.this.updateSelections();
                    }
                    SoapServiceSelectionPropertiesPanel.this.updating = false;
                }
            }
        });
        this.portCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("port changed");
                if (!SoapServiceSelectionPropertiesPanel.this.updating && SoapServiceSelectionPropertiesPanel.this.currentPort != null) {
                    SoapServiceSelectionPropertiesPanel.this.updating = true;
                    Port port = (Port)((IStructuredSelection)SoapServiceSelectionPropertiesPanel.this.portCombo.getSelection()).getFirstElement();
                    if (port != SoapServiceSelectionPropertiesPanel.this.currentPort) {
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setPort(port.getName());
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setOperation(null);
                        SoapServiceSelectionPropertiesPanel.this.updateSelections();
                    }
                    SoapServiceSelectionPropertiesPanel.this.updating = false;
                }
            }
        });
        this.operationCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("operation changed");
                if (!SoapServiceSelectionPropertiesPanel.this.updating && SoapServiceSelectionPropertiesPanel.this.currentBindingOperation != null) {
                    SoapServiceSelectionPropertiesPanel.this.updating = true;
                    SoapBindingOperation operation = (SoapBindingOperation)((IStructuredSelection)SoapServiceSelectionPropertiesPanel.this.operationCombo.getSelection()).getFirstElement();
                    if (operation != SoapServiceSelectionPropertiesPanel.this.currentBindingOperation) {
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setOperation(operation.getOperation().getName());
                        SoapServiceSelectionPropertiesPanel.this.serviceBinding.setSoapAction(operation.getSoapAction());
                        SoapServiceSelectionPropertiesPanel.this.updateSelections();
                    }
                    SoapServiceSelectionPropertiesPanel.this.updating = false;
                }
            }
        });
        this.updateSelections();
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        this.serviceBinding.setURL(this.urlField.getText());
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    private List<Service> getSoapServices(List<Service> genericServices) {
        ArrayList<Service> ret = new ArrayList<Service>();
        for (Service service : genericServices) {
            if (!this.hasSoapBinding(service)) continue;
            ret.add(service);
        }
        return ret;
    }

    private boolean hasSoapBinding(Service service) {
        List searchPorts = service.getPorts();
        for (Port port : searchPorts) {
            if (!(port.getBinding() instanceof SoapBinding)) continue;
            return true;
        }
        return false;
    }

    private List<Port> getSoapPorts(List<Port> genericPorts) {
        ArrayList<Port> ret = new ArrayList<Port>();
        for (Port port : genericPorts) {
            if (!(port.getBinding() instanceof SoapBinding)) continue;
            ret.add(port);
        }
        return ret;
    }

    private void updateSelections() {
        this.currentDescriptor = null;
        this.currentService = null;
        this.currentPort = null;
        this.currentBindingOperation = null;
        if (this.serviceBinding.getDescriptor() != null) {
            for (IWebserviceDescriptor descriptor : this.descriptors) {
                if (!descriptor.getName().equals(this.serviceBinding.getDescriptor())) continue;
                this.currentDescriptor = descriptor;
                break;
            }
        }
        if (this.currentDescriptor == null && this.descriptors.size() > 0) {
            this.currentDescriptor = this.descriptors.get(0);
            this.serviceBinding.setDescriptor(this.currentDescriptor.getName());
        }
        if (this.currentDescriptor != null) {
            WSDL wsdl = null;
            try {
                wsdl = this.currentDescriptor.getWSDL();
            }
            catch (Exception we) {
                return;
            }
            this.services = this.getSoapServices(wsdl.getServices());
            if (this.serviceCombo != null) {
                this.serviceCombo.refresh();
            }
            if (this.serviceBinding.getService() != null) {
                for (Service service : this.services) {
                    if (!service.getName().equals(this.serviceBinding.getService())) continue;
                    this.currentService = service;
                    break;
                }
            }
            if (this.currentService == null && this.services.size() > 0) {
                this.currentService = this.services.get(0);
                this.serviceBinding.setService(this.currentService.getName());
            }
            if (this.currentService != null) {
                this.ports = this.getSoapPorts(this.currentService.getPorts());
                if (this.portCombo != null) {
                    this.portCombo.refresh();
                }
                if (this.serviceBinding.getPort() != null) {
                    for (Port port : this.ports) {
                        if (!port.getName().equals(this.serviceBinding.getPort())) continue;
                        this.currentPort = port;
                        break;
                    }
                }
                if (this.currentPort == null && this.ports.size() > 0) {
                    this.currentPort = this.ports.get(0);
                    this.serviceBinding.setPort(this.currentPort.getName());
                }
                if (this.currentPort != null) {
                    this.bindingOperations = this.currentPort.getBinding().getOperations();
                    if (this.operationCombo != null) {
                        this.operationCombo.refresh();
                    }
                    if (this.serviceBinding.getOperation() != null) {
                        for (BindingOperation bindingOperation : this.bindingOperations) {
                            if (!bindingOperation.getOperation().getName().equals(this.serviceBinding.getOperation())) continue;
                            this.currentBindingOperation = (SoapBindingOperation)bindingOperation;
                            break;
                        }
                    }
                    if (this.currentBindingOperation == null && this.bindingOperations.size() > 0) {
                        this.currentBindingOperation = (SoapBindingOperation)this.bindingOperations.get(0);
                        this.serviceBinding.setOperation(this.currentBindingOperation.getOperation().getName());
                        this.serviceBinding.setSoapAction(this.currentBindingOperation.getSoapAction());
                    }
                }
            }
        }
        String oldKey = this.currentKey;
        this.currentKey = String.valueOf(this.serviceBinding.getDescriptor()) + ":" + this.serviceBinding.getService() + ":" + this.serviceBinding.getPort() + ":" + this.serviceBinding.getOperation();
        if (!oldKey.equals(this.currentKey)) {
            this.manager.getInputDocumentStructure().clearStructure();
        }
        for (IOperationListener l : this.listeners) {
            l.operationChanged(this.currentBindingOperation);
        }
        if (this.descriptorCombo != null) {
            if (this.currentDescriptor != null) {
                this.descriptorCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentDescriptor));
            } else if (this.descriptors.size() < 1) {
                this.descriptorCombo.setSelection((ISelection)new StructuredSelection((Object)NO_DESCRIPTORS));
            }
            if (this.currentService != null) {
                this.serviceCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentService));
            } else if (this.services.size() < 1) {
                this.serviceCombo.setSelection((ISelection)new StructuredSelection((Object)NO_SERVICES));
            }
            if (this.currentPort != null) {
                this.portCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentPort));
            } else if (this.ports.size() < 1) {
                this.portCombo.setSelection((ISelection)new StructuredSelection((Object)NO_PORTS));
            }
            if (this.currentBindingOperation != null) {
                this.operationCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentBindingOperation));
            } else if (this.ports.size() < 1) {
                this.operationCombo.setSelection((ISelection)new StructuredSelection((Object)NO_OPERATIONS));
            }
        }
    }

    public SoapBindingOperation getBindingOperation() {
        return this.currentBindingOperation;
    }

    public void addOperationListener(IOperationListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
        l.operationChanged(this.currentBindingOperation);
    }

    public void removeOperationListener(IOperationListener l) {
        this.listeners.remove(l);
    }

    public class DescriptorContentLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider,
    IStructuredContentProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((IWebserviceDescriptor)element).getName();
        }

        public Object[] getElements(Object inputElement) {
            if (SoapServiceSelectionPropertiesPanel.this.descriptors.size() > 0) {
                return SoapServiceSelectionPropertiesPanel.this.descriptors.toArray();
            }
            return new Object[]{SoapServiceSelectionPropertiesPanel.NO_DESCRIPTORS};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class OperationContentLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider,
    IStructuredContentProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((SoapBindingOperation)element).getOperation().getName();
        }

        public Object[] getElements(Object inputElement) {
            if (SoapServiceSelectionPropertiesPanel.this.bindingOperations.size() > 0) {
                return SoapServiceSelectionPropertiesPanel.this.bindingOperations.toArray();
            }
            return new Object[]{SoapServiceSelectionPropertiesPanel.NO_OPERATIONS};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class PortContentLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider,
    IStructuredContentProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((Port)element).getName();
        }

        public Object[] getElements(Object inputElement) {
            if (SoapServiceSelectionPropertiesPanel.this.ports.size() > 0) {
                return SoapServiceSelectionPropertiesPanel.this.ports.toArray();
            }
            return new Object[]{SoapServiceSelectionPropertiesPanel.NO_PORTS};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ServiceContentLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider,
    IStructuredContentProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((Service)element).getName();
        }

        public Object[] getElements(Object inputElement) {
            if (SoapServiceSelectionPropertiesPanel.this.services.size() > 0) {
                return SoapServiceSelectionPropertiesPanel.this.services.toArray();
            }
            return new Object[]{SoapServiceSelectionPropertiesPanel.NO_SERVICES};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

