/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.widgets;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.modules.webservice.ui.widgets.ObjectDefinitionFilter;

public class VariableBrowserDialog
extends Dialog {
    private Text searchText = null;
    private TreeViewer variableViewer = null;
    private ObjectDefinitionFilter openFilter;
    private ObjectDefinitionFilter filter = this.openFilter = new ObjectDefinitionFilter(){

        @Override
        public boolean isApplicable(ObjectDefinition definition) {
            return true;
        }
    };
    private List<Variable> scope = null;
    private ObjectDefinition selection = null;

    static {
        ColorRegistry cr = JFaceResources.getColorRegistry();
        cr.put("VTP_BLACK", new RGB(0, 0, 0));
        cr.put("VTP_WHITE", new RGB(255, 255, 255));
        cr.put("VTP_GRAYED", new RGB(140, 140, 140));
    }

    public VariableBrowserDialog(Shell parentShell, List<Variable> scope) {
        super(parentShell);
        this.scope = scope;
    }

    public void setFilter(ObjectDefinitionFilter filter) {
        this.filter = filter == null ? this.openFilter : filter;
        if (this.variableViewer != null) {
            this.variableViewer.refresh();
        }
    }

    public ObjectDefinition getSelectedDefinition() {
        return this.selection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        GridData dialogData = (GridData)dialogComp.getLayoutData();
        dialogData.widthHint = 400;
        dialogData.heightHint = 300;
        this.searchText = new Text(dialogComp, 132);
        this.searchText.setLayoutData((Object)new GridData(768));
        Composite layoutComp = new Composite(dialogComp, 0);
        layoutComp.setLayoutData((Object)new GridData(1808));
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        layoutComp.setLayout((Layout)columnLayout);
        Tree variableTree = new Tree(layoutComp, 68100);
        variableTree.setHeaderVisible(true);
        variableTree.setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(variableTree, 0);
        nameColumn.setText("Name");
        columnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(65, 200));
        TreeColumn typeColumn = new TreeColumn(variableTree, 0);
        typeColumn.setText("Type");
        columnLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(35, 75));
        this.variableViewer = new TreeViewer(variableTree);
        this.variableViewer.setComparator(new ViewerComparator());
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (sel == null) {
                    VariableBrowserDialog.this.selection = null;
                } else if (VariableBrowserDialog.this.filter.isApplicable((ObjectDefinition)sel)) {
                    VariableBrowserDialog.this.selection = (ObjectDefinition)sel;
                } else {
                    VariableBrowserDialog.this.selection = null;
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableBrowserDialog.this.variableViewer.refresh();
            }
        });
        this.variableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String crit = VariableBrowserDialog.this.searchText.getText();
                if (crit.length() == 0) {
                    return true;
                }
                ObjectDefinition od = (ObjectDefinition)element;
                LinkedList<String> paths = new LinkedList<String>();
                paths.add(od.getPath());
                this.addFields(paths, od.getFields());
                for (String path : paths) {
                    if (!path.toLowerCase().contains(crit.toLowerCase())) continue;
                    return true;
                }
                return false;
            }

            private void addFields(List<String> paths, List<ObjectField> fields) {
                for (ObjectField field : fields) {
                    paths.add(field.getPath());
                    this.addFields(paths, field.getFields());
                }
            }
        });
        return dialogComp;
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return VariableBrowserDialog.this.scope.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof ObjectField) {
                return ((ObjectField)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return ((ObjectDefinition)element).getFields().size() > 0;
        }

        public Object[] getChildren(Object parentElement) {
            return ((ObjectDefinition)parentElement).getFields().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            ObjectDefinition od = (ObjectDefinition)element;
            if (index == 0) {
                return od.getName();
            }
            if (od.getType().isObject()) {
                return od.getType().getName();
            }
            if (od.getType().getPrimitiveType() == FieldType.Primitive.ARRAY) {
                return String.valueOf(od.getType().getBaseTypeName()) + "[]";
            }
            return od.getType().getName();
        }

        public Color getForeground(Object element, int index) {
            ColorRegistry cr = JFaceResources.getColorRegistry();
            ObjectDefinition od = (ObjectDefinition)element;
            if (VariableBrowserDialog.this.filter.isApplicable(od)) {
                return cr.get("VTP_BLACK");
            }
            return cr.get("VTP_GRAYED");
        }

        public Color getBackground(Object element, int index) {
            return null;
        }
    }
}

