/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class ProductLevel {
    public String databaseProductName_;
    public int versionLevel_;
    public int releaseLevel_;
    public int modificationLevel_;
    public String databaseProductVersion_;

    public ProductLevel(String productID, String databaseProductName, String srvrlslv) {
        this.versionLevel_ = Integer.parseInt(productID.substring(3, 5));
        this.releaseLevel_ = Integer.parseInt(productID.substring(5, 7));
        this.modificationLevel_ = Integer.parseInt(productID.substring(7, 8));
        this.databaseProductName_ = databaseProductName == null ? "Derby" : databaseProductName;
        int dbVersionOffset = 0;
        if (srvrlslv != null) {
            dbVersionOffset = srvrlslv.indexOf(47) + 1;
            this.databaseProductVersion_ = srvrlslv.substring(dbVersionOffset);
        }
        if (this.databaseProductVersion_ == null) {
            this.databaseProductVersion_ = productID;
        }
    }

    public boolean greaterThanOrEqualTo(int versionLevel, int releaseLevel, int modificationLevel) {
        if (this.versionLevel_ > versionLevel) {
            return true;
        }
        if (this.versionLevel_ == versionLevel) {
            if (this.releaseLevel_ > releaseLevel) {
                return true;
            }
            if (this.releaseLevel_ == releaseLevel && this.modificationLevel_ >= modificationLevel) {
                return true;
            }
        }
        return false;
    }

    public boolean lessThan(int versionLevel, int releaseLevel, int modificationLevel) {
        if (this.versionLevel_ < versionLevel) {
            return true;
        }
        if (this.versionLevel_ == versionLevel) {
            if (this.releaseLevel_ < releaseLevel) {
                return true;
            }
            if (this.releaseLevel_ == releaseLevel && this.modificationLevel_ < modificationLevel) {
                return true;
            }
        }
        return false;
    }
}

