/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ApplicationObjectInputStream;
import org.apache.derby.iapi.services.io.ErrorInfo;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.Resetable;

public final class FormatIdInputStream
extends DataInputStream
implements ErrorObjectInput,
Resetable {
    protected ClassFactory cf;
    private ErrorInfo errorInfo;
    private Exception myNestedException;

    public FormatIdInputStream(InputStream in) {
        super(in);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        this.setErrorInfo(null);
        int fmtId = FormatIdUtil.readFormatIdInteger(this);
        if (fmtId == 0) {
            return null;
        }
        if (fmtId == 1) {
            return this.readUTF();
        }
        try {
            if (fmtId == 2) {
                ObjectInputStream ois = this.getObjectStream();
                try {
                    Object result = ois.readObject();
                    return result;
                }
                catch (IOException ioe) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw cnfe;
                }
                catch (LinkageError le) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw le;
                }
                catch (ClassCastException cce) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw cce;
                }
            }
            try {
                boolean isNull;
                Formatable f = (Formatable)Monitor.newInstanceFromIdentifier(fmtId);
                if (f instanceof Storable && (isNull = this.readBoolean())) {
                    Storable s = (Storable)f;
                    s.restoreToNull();
                    return s;
                }
                f.readExternal(this);
                return f;
            }
            catch (StandardException se) {
                throw new ClassNotFoundException(se.toString());
            }
        }
        catch (ClassCastException cce) {
            throw new StreamCorruptedException(cce.toString());
        }
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getErrorInfo() {
        if (this.errorInfo == null) {
            return "";
        }
        return this.errorInfo.getErrorInfo();
    }

    public Exception getNestedException() {
        if (this.myNestedException != null) {
            return null;
        }
        if (this.errorInfo == null) {
            return null;
        }
        return this.errorInfo.getNestedException();
    }

    private void setErrorInfo(ErrorInfo ei) {
        this.errorInfo = ei;
    }

    ClassFactory getClassFactory() {
        ClassFactoryContext cfc;
        if (this.cf == null && (cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext")) != null) {
            this.cf = cfc.getClassFactory();
        }
        return this.cf;
    }

    private ObjectInputStream getObjectStream() throws IOException {
        return this.getClassFactory() == null ? new ObjectInputStream(this) : new ApplicationObjectInputStream(this, this.cf);
    }

    public void resetStream() throws IOException, StandardException {
        SanityManager.ASSERT(this.in instanceof Resetable);
        ((Resetable)((Object)this.in)).resetStream();
    }

    public void initStream() throws StandardException {
        SanityManager.ASSERT(this.in instanceof Resetable);
        ((Resetable)((Object)this.in)).initStream();
    }

    public void closeStream() {
        SanityManager.ASSERT(this.in instanceof Resetable);
        ((Resetable)((Object)this.in)).closeStream();
    }
}

