/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID routineUUID) {
        this.routineUUID = routineUUID;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant, Activation activation) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ExecPreparedStatement ps = activation.getPreparedStatement();
        RoutinePermsDescriptor perms = dd.getRoutinePermissions(this.routineUUID, authorizationId);
        if (perms == null || !perms.getHasExecutePermission()) {
            perms = dd.getRoutinePermissions(this.routineUUID, "PUBLIC");
        }
        if (perms != null && perms.getHasExecutePermission()) {
            return;
        }
        boolean resolved = false;
        String role = lcc.getCurrentRoleId(activation);
        if (role != null) {
            String dbo = dd.getAuthorizationDatabaseOwner();
            RoleGrantDescriptor rd = dd.getRoleGrantDescriptor(role, authorizationId, dbo);
            if (rd == null) {
                rd = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
            }
            if (rd == null) {
                lcc.setCurrentRole(activation, null);
            } else {
                String r;
                RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
                while (!resolved && (r = rci.next()) != null) {
                    perms = dd.getRoutinePermissions(this.routineUUID, r);
                    if (perms == null || !perms.getHasExecutePermission()) continue;
                    resolved = true;
                }
            }
            if (resolved) {
                DependencyManager dm = dd.getDependencyManager();
                RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
                ContextManager cm = lcc.getContextManager();
                dm.addDependency(ps, rgd, cm);
                dm.addDependency(activation, rgd, cm);
            }
        }
        if (!resolved) {
            AliasDescriptor ad = dd.getAliasDescriptor(this.routineUUID);
            if (ad == null) {
                throw StandardException.newException("4250E", "routine");
            }
            SchemaDescriptor sd = dd.getSchemaDescriptor(ad.getSchemaUUID(), tc);
            if (sd == null) {
                throw StandardException.newException("4250E", "schema");
            }
            throw StandardException.newException(forGrant ? "42505" : "42504", authorizationId, (Object)ad.getDescriptorType(), (Object)sd.getSchemaName(), (Object)ad.getDescriptorName());
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return dd.getRoutinePermissions(this.routineUUID, authid);
    }

    public String toString() {
        return "StatementRoutinePermission: " + this.routineUUID;
    }
}

