/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

abstract class BinaryDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private static final byte[] ONE_2C = new byte[]{1};
    protected byte[] data2c;
    protected int sqlScale;

    BinaryDecimal() {
    }

    public final int typeToBigDecimal() {
        return 3;
    }

    public final int typePrecedence() {
        return 70;
    }

    public final String getTypeName() {
        return "DECIMAL";
    }

    public final int getTypeFormatId() {
        return 200;
    }

    public boolean isNull() {
        return this.data2c == null;
    }

    public void restoreToNull() {
        this.data2c = null;
    }

    protected boolean isNegative() {
        return !this.isNull() && (this.data2c[0] & 0x80) != 0;
    }

    public void setValue(long theValue) {
        byte[] rd = this.data2c;
        if (rd == null || rd.length < 8) {
            rd = new byte[]{(byte)(theValue >>> 56), (byte)(theValue >>> 48), (byte)(theValue >>> 40), (byte)(theValue >>> 32), (byte)(theValue >>> 24), (byte)(theValue >>> 16), (byte)(theValue >>> 8), (byte)theValue};
        }
        this.data2c = rd;
        this.sqlScale = 0;
        try {
            if (theValue != this.getLong()) {
                SanityManager.THROWASSERT("BinaryDecimal invalid long conversion before reduce in " + theValue + " out " + this.getLong());
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT(se);
        }
        this.data2c = BinaryDecimal.reduceBytes2c(rd, 0, 8);
        this.sqlScale = 0;
        try {
            if (theValue != this.getLong()) {
                SanityManager.THROWASSERT("BinaryDecimal invalid long conversion after reduce in " + theValue + " out " + this.getLong());
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT(se);
        }
    }

    public final void setValue(int theValue) {
        byte[] rd = this.data2c;
        if (rd == null || rd.length < 4) {
            rd = new byte[]{(byte)(theValue >>> 24), (byte)(theValue >>> 16), (byte)(theValue >>> 8), (byte)theValue};
        }
        this.data2c = BinaryDecimal.reduceBytes2c(rd, 0, 4);
        this.sqlScale = 0;
    }

    public void setValue(boolean theValue) {
        int intValue = theValue ? 1 : 0;
        this.setValue(intValue);
    }

    public final void setValue(double theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(theValue));
    }

    public final void setValue(float theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(theValue));
    }

    private void setCoreValue(double theValue) throws StandardException {
        this.setValue(Double.toString(theValue));
    }

    public void setValue(Number theValue) throws StandardException {
        if (theValue != null && !(theValue instanceof Long)) {
            SanityManager.THROWASSERT("BinaryDecimal.setValue(Number) passed a " + theValue.getClass());
        }
        if (theValue == null) {
            this.setToNull();
        } else {
            this.setValue(theValue.longValue());
        }
    }

    protected void setFrom(DataValueDescriptor dvd) throws StandardException {
        switch (dvd.typeToBigDecimal()) {
            case 1: 
            case 3: {
                this.setValue(dvd.getString());
                break;
            }
            case -5: {
                this.setValue(dvd.getLong());
                break;
            }
            default: {
                super.setFrom(dvd);
            }
        }
    }

    public final int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    public final byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -128L && lv <= 127L) {
                return (byte)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    public final short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -32768L && lv <= 32767L) {
                return (short)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    public final NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        return this.plusNN(addend1, addend2, result);
    }

    public final NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        return this.timesNN(left, right, result);
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        return this.divide(dividend, divisor, result, -1);
    }

    public final NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        return this.divideNN(dividend, divisor, result, scale);
    }

    public final NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        return this.minusNN(left, right, result);
    }

    public NumberDataValue minusNN(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        return this.plusNN(left, right.minus(result), result);
    }

    public abstract NumberDataValue timesNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue plusNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue divideNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3, int var4) throws StandardException;

    private static byte[] reduceBytes2c(byte[] rd, int offset, int dataLength) {
        int leading;
        for (leading = 0; leading < dataLength - 1 && rd[offset + leading] == 0 && (rd[offset + leading + 1] & 0x80) == 0; ++leading) {
        }
        if (leading == 0) {
            while (leading < dataLength - 1 && rd[offset + leading] == -1 && (rd[offset + leading + 1] & 0xFFFFFF80) != 0) {
                ++leading;
            }
        }
        if (leading != 0 || rd.length != dataLength) {
            byte[] reduced = new byte[dataLength - leading];
            System.arraycopy(rd, offset + leading, reduced, 0, reduced.length);
            return reduced;
        }
        return rd;
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        return this.sqlScale;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeByte(this.sqlScale);
        out.writeByte(this.data2c.length);
        out.write(this.data2c);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.sqlScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.data2c == null || size != this.data2c.length) {
            this.data2c = new byte[size];
        }
        in.readFully(this.data2c);
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.sqlScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.data2c == null || size != this.data2c.length) {
            this.data2c = new byte[size];
        }
        in.readFully(this.data2c);
    }

    public final int getLength() {
        return this.getDecimalValuePrecision();
    }

    public DataValueDescriptor getClone() {
        BinaryDecimal dvd = (BinaryDecimal)this.getNewNull();
        if (this.data2c != null) {
            dvd.data2c = new byte[this.data2c.length];
            System.arraycopy(this.data2c, 0, dvd.data2c, 0, this.data2c.length);
            dvd.sqlScale = this.sqlScale;
        }
        return dvd;
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        this.setValue(resultSet.getString(colNumber));
    }

    public int estimateMemoryUsage() {
        return 0;
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        try {
            return (int)this.getLong();
        }
        catch (StandardException se) {
            return 0;
        }
    }
}

