/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSTABLEPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSTABLEPERMS";
    private static final int TABLEPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int TABLEID_COL_NUM = 4;
    private static final int SELECTPRIV_COL_NUM = 5;
    private static final int DELETEPRIV_COL_NUM = 6;
    private static final int INSERTPRIV_COL_NUM = 7;
    private static final int UPDATEPRIV_COL_NUM = 8;
    private static final int REFERENCESPRIV_COL_NUM = 9;
    private static final int TRIGGERPRIV_COL_NUM = 10;
    private static final int COLUMN_COUNT = 10;
    public static final int GRANTEE_TABLE_GRANTOR_INDEX_NUM = 0;
    public static final int TABLEPERMSID_INDEX_NUM = 1;
    public static final int TABLEID_INDEX_NUM = 2;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_TABLE_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"b8450018-0103-0e39-b8e7-00000010f010", "004b0019-0103-0e39-b8e7-00000010f010", "c851401a-0103-0e39-b8e7-00000010f010", "80220011-010c-426e-c599-0000000f1120", "f81e0010-010c-bc85-060d-000000109ab8"};

    SYSTABLEPERMSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(10, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        DataValueDescriptor grantee = null;
        DataValueDescriptor grantor = null;
        String tablePermID = null;
        String tableID = null;
        String selectPriv = null;
        String deletePriv = null;
        String insertPriv = null;
        String updatePriv = null;
        String referencesPriv = null;
        String triggerPriv = null;
        if (td == null) {
            grantee = this.getNullAuthorizationID();
            grantor = this.getNullAuthorizationID();
        } else {
            TablePermsDescriptor tpd = (TablePermsDescriptor)td;
            UUID oid = tpd.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                tpd.setUUID(oid);
            }
            tablePermID = oid.toString();
            grantee = this.getAuthorizationID(tpd.getGrantee());
            grantor = this.getAuthorizationID(tpd.getGrantor());
            tableID = tpd.getTableUUID().toString();
            selectPriv = tpd.getSelectPriv();
            deletePriv = tpd.getDeletePriv();
            insertPriv = tpd.getInsertPriv();
            updatePriv = tpd.getUpdatePriv();
            referencesPriv = tpd.getReferencesPriv();
            triggerPriv = tpd.getTriggerPriv();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(10);
        row.setColumn(1, new SQLChar(tablePermID));
        row.setColumn(2, grantee);
        row.setColumn(3, grantor);
        row.setColumn(4, new SQLChar(tableID));
        row.setColumn(5, new SQLChar(selectPriv));
        row.setColumn(6, new SQLChar(deletePriv));
        row.setColumn(7, new SQLChar(insertPriv));
        row.setColumn(8, new SQLChar(updatePriv));
        row.setColumn(9, new SQLChar(referencesPriv));
        row.setColumn(10, new SQLChar(triggerPriv));
        return row;
    }

    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTuple, DataDictionary dataDictionary) throws StandardException {
        SanityManager.ASSERT(row.nColumns() == 10, "Wrong size row passed to SYSTABLEPERMSRowFactory.buildDescriptor");
        String tablePermsUUIDString = row.getColumn(1).getString();
        UUID tablePermsUUID = this.getUUIDFactory().recreateUUID(tablePermsUUIDString);
        String tableUUIDString = row.getColumn(4).getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        String selectPriv = row.getColumn(5).getString();
        String deletePriv = row.getColumn(6).getString();
        String insertPriv = row.getColumn(7).getString();
        String updatePriv = row.getColumn(8).getString();
        String referencesPriv = row.getColumn(9).getString();
        String triggerPriv = row.getColumn(10).getString();
        SanityManager.ASSERT("y".equals(selectPriv) || "Y".equals(selectPriv) || "N".equals(selectPriv), "Invalid SYSTABLEPERMS.selectPriv column value: " + selectPriv);
        SanityManager.ASSERT("y".equals(deletePriv) || "Y".equals(deletePriv) || "N".equals(deletePriv), "Invalid SYSTABLEPERMS.deletePriv column value: " + deletePriv);
        SanityManager.ASSERT("y".equals(insertPriv) || "Y".equals(insertPriv) || "N".equals(insertPriv), "Invalid SYSTABLEPERMS.insertPriv column value: " + insertPriv);
        SanityManager.ASSERT("y".equals(updatePriv) || "Y".equals(updatePriv) || "N".equals(updatePriv), "Invalid SYSTABLEPERMS.updatePriv column value: " + updatePriv);
        SanityManager.ASSERT("y".equals(referencesPriv) || "Y".equals(referencesPriv) || "N".equals(referencesPriv), "Invalid SYSTABLEPERMS.referencesPriv column value: " + referencesPriv);
        SanityManager.ASSERT("y".equals(triggerPriv) || "Y".equals(triggerPriv) || "N".equals(triggerPriv), "Invalid SYSTABLEPERMS.triggerPriv column value: " + triggerPriv);
        TablePermsDescriptor tabPermsDesc = new TablePermsDescriptor(dataDictionary, this.getAuthorizationID(row, 2), this.getAuthorizationID(row, 3), tableUUID, selectPriv, deletePriv, insertPriv, updatePriv, referencesPriv, triggerPriv);
        tabPermsDesc.setUUID(tablePermsUUID);
        return tabPermsDesc;
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIndicatorColumn("SELECTPRIV"), SystemColumnImpl.getIndicatorColumn("DELETEPRIV"), SystemColumnImpl.getIndicatorColumn("INSERTPRIV"), SystemColumnImpl.getIndicatorColumn("UPDATEPRIV"), SystemColumnImpl.getIndicatorColumn("REFERENCESPRIV"), SystemColumnImpl.getIndicatorColumn("TRIGGERPRIV")};
    }

    public ExecIndexRow buildIndexKeyRow(int indexNumber, PermissionsDescriptor perm) throws StandardException {
        ExecIndexRow row = null;
        switch (indexNumber) {
            case 0: {
                row = this.getExecutionFactory().getIndexableRow(2);
                row.setColumn(1, this.getAuthorizationID(perm.getGrantee()));
                String tableUUIDStr = ((TablePermsDescriptor)perm).getTableUUID().toString();
                row.setColumn(2, new SQLChar(tableUUIDStr));
                break;
            }
            case 1: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String tablePermsUUIDStr = perm.getObjectID().toString();
                row.setColumn(1, new SQLChar(tablePermsUUIDStr));
                break;
            }
            case 2: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String tableUUIDStr = ((TablePermsDescriptor)perm).getTableUUID().toString();
                row.setColumn(1, new SQLChar(tableUUIDStr));
            }
        }
        return row;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public int orPermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        TablePermsDescriptor tablePerms = (TablePermsDescriptor)perm;
        int changeCount = 0;
        changeCount += this.orOnePermission(row, colsChanged, 5, tablePerms.getSelectPriv());
        changeCount += this.orOnePermission(row, colsChanged, 6, tablePerms.getDeletePriv());
        changeCount += this.orOnePermission(row, colsChanged, 7, tablePerms.getInsertPriv());
        changeCount += this.orOnePermission(row, colsChanged, 8, tablePerms.getUpdatePriv());
        changeCount += this.orOnePermission(row, colsChanged, 9, tablePerms.getReferencesPriv());
        return changeCount += this.orOnePermission(row, colsChanged, 10, tablePerms.getTriggerPriv());
    }

    private int orOnePermission(ExecRow row, boolean[] colsChanged, int column, String permission) throws StandardException {
        if (permission.charAt(0) == 'N') {
            return 0;
        }
        SanityManager.ASSERT(permission.charAt(0) == 'Y' || permission.charAt(0) == 'y', "Invalid permission passed to SYSTABLEPERMSRowFactory.orOnePermission");
        DataValueDescriptor existingPermDVD = row.getColumn(column);
        char existingPerm = existingPermDVD.getString().charAt(0);
        if (existingPerm == 'Y' || existingPerm == permission.charAt(0)) {
            return 0;
        }
        existingPermDVD.setValue(permission);
        colsChanged[column - 1] = true;
        return 1;
    }

    public int removePermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        TablePermsDescriptor tablePerms = (TablePermsDescriptor)perm;
        int changeCount = 0;
        boolean permissionsLeft = this.removeOnePermission(row, colsChanged, 5, tablePerms.getSelectPriv()) | this.removeOnePermission(row, colsChanged, 6, tablePerms.getDeletePriv()) | this.removeOnePermission(row, colsChanged, 7, tablePerms.getInsertPriv()) | this.removeOnePermission(row, colsChanged, 8, tablePerms.getUpdatePriv()) | this.removeOnePermission(row, colsChanged, 9, tablePerms.getReferencesPriv()) | this.removeOnePermission(row, colsChanged, 10, tablePerms.getTriggerPriv());
        if (!permissionsLeft) {
            return -1;
        }
        for (int i = 0; i < colsChanged.length; ++i) {
            if (!colsChanged[i]) continue;
            ++changeCount;
        }
        return changeCount;
    }

    private boolean removeOnePermission(ExecRow row, boolean[] colsChanged, int column, String permission) throws StandardException {
        DataValueDescriptor existingPermDVD = row.getColumn(column);
        char existingPerm = existingPermDVD.getString().charAt(0);
        if (permission.charAt(0) == 'N') {
            return existingPerm != 'N';
        }
        SanityManager.ASSERT(permission.charAt(0) == 'Y' || permission.charAt(0) == 'y', "Invalid permission passed to SYSTABLEPERMSRowFactory.removeOnePermission");
        if (existingPerm != 'N') {
            existingPermDVD.setValue("N");
            colsChanged[column - 1] = true;
        }
        return false;
    }

    public void setUUIDOfThePassedDescriptor(ExecRow row, PermissionsDescriptor perm) throws StandardException {
        DataValueDescriptor existingPermDVD = row.getColumn(1);
        perm.setUUID(this.getUUIDFactory().recreateUUID(existingPermDVD.getString()));
    }
}

