/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.HashJoinStrategy;
import org.apache.derby.impl.sql.compile.NestedLoopJoinStrategy;
import org.apache.derby.impl.sql.compile.OptimizerImpl;

public class OptimizerFactoryImpl
implements ModuleControl,
OptimizerFactory {
    protected String optimizerId = null;
    protected boolean ruleBasedOptimization = false;
    protected boolean noTimeout = false;
    protected boolean useStatistics = true;
    protected int maxMemoryPerTable = 0x100000;
    protected JoinStrategy[] joinStrategySet;

    public void boot(boolean create, Properties startParams) throws StandardException {
        String us;
        int intValue;
        this.ruleBasedOptimization = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.optimizer.ruleBasedOptimization"));
        this.noTimeout = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.optimizer.noTimeout"));
        String maxMemValue = PropertyUtil.getSystemProperty("derby.language.maxMemoryPerTable");
        if (maxMemValue != null && (intValue = Integer.parseInt(maxMemValue)) >= 0) {
            this.maxMemoryPerTable = intValue * 1024;
        }
        if ((us = PropertyUtil.getSystemProperty("derby.language.useStatistics")) != null) {
            this.useStatistics = Boolean.valueOf(us);
        }
    }

    public void stop() {
    }

    public Optimizer getOptimizer(OptimizableList optimizableList, OptimizablePredicateList predList, DataDictionary dDictionary, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, LanguageConnectionContext lcc) throws StandardException {
        if (this.joinStrategySet == null) {
            JoinStrategy[] jss = new JoinStrategy[]{new NestedLoopJoinStrategy(), new HashJoinStrategy()};
            this.joinStrategySet = jss;
        }
        return this.getOptimizerImpl(optimizableList, predList, dDictionary, requiredRowOrdering, numTablesInQuery, lcc);
    }

    public CostEstimate getCostEstimate() throws StandardException {
        return new CostEstimateImpl();
    }

    public boolean supportsOptimizerTrace() {
        return false;
    }

    protected Optimizer getOptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList predList, DataDictionary dDictionary, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, LanguageConnectionContext lcc) throws StandardException {
        return new OptimizerImpl(optimizableList, predList, dDictionary, this.ruleBasedOptimization, this.noTimeout, this.useStatistics, this.maxMemoryPerTable, this.joinStrategySet, lcc.getLockEscalationThreshold(), requiredRowOrdering, numTablesInQuery);
    }

    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }
}

