/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.PrivilegeNode;

public class RevokeNode
extends DDLStatementNode {
    private PrivilegeNode privileges;
    private List grantees;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.grantees.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(it.next().toString());
        }
        return super.toString() + this.privileges.toString() + "TO: \n" + sb.toString() + "\n";
    }

    public String statementToString() {
        return "REVOKE";
    }

    public void init(Object privileges, Object grantees) {
        this.privileges = (PrivilegeNode)privileges;
        this.grantees = (List)grantees;
    }

    public void bindStatement() throws StandardException {
        this.privileges = (PrivilegeNode)this.privileges.bind(new HashMap(), this.grantees, false);
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRevokeConstantAction(this.privileges.makePrivilegeInfo(), this.grantees);
    }
}

