/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class SetOpResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private final NoPutResultSet leftSource;
    private final NoPutResultSet rightSource;
    private final Activation activation;
    private final int opType;
    private final boolean all;
    private final int resultSetNumber;
    private DataValueDescriptor[] prevCols;
    private int rightDuplicateCount;
    private ExecRow leftInputRow;
    private ExecRow rightInputRow;
    private final int[] intermediateOrderByColumns;
    private final int[] intermediateOrderByDirection;
    private final boolean[] intermediateOrderByNullsLow;
    private int rowsSeenLeft;
    private int rowsSeenRight;
    private int rowsReturned;

    SetOpResultSet(NoPutResultSet leftSource, NoPutResultSet rightSource, Activation activation, int resultSetNumber, long optimizerEstimatedRowCount, double optimizerEstimatedCost, int opType, boolean all, int intermediateOrderByColumnsSavedObject, int intermediateOrderByDirectionSavedObject, int intermediateOrderByNullsLowSavedObject) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.leftSource = leftSource;
        this.rightSource = rightSource;
        this.activation = activation;
        this.resultSetNumber = resultSetNumber;
        this.opType = opType;
        this.all = all;
        ExecPreparedStatement eps = activation.getPreparedStatement();
        this.intermediateOrderByColumns = (int[])eps.getSavedObject(intermediateOrderByColumnsSavedObject);
        this.intermediateOrderByDirection = (int[])eps.getSavedObject(intermediateOrderByDirectionSavedObject);
        this.intermediateOrderByNullsLow = (boolean[])eps.getSavedObject(intermediateOrderByNullsLowSavedObject);
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "SetOpResultSet already open");
        this.isOpen = true;
        this.leftSource.openCore();
        this.rightSource.openCore();
        this.rightInputRow = this.rightSource.getNextRowCore();
        if (this.rightInputRow != null) {
            ++this.rowsSeenRight;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((this.leftInputRow = this.leftSource.getNextRowCore()) != null) {
                ++this.rowsSeenLeft;
                DataValueDescriptor[] leftColumns = this.leftInputRow.getRowArray();
                if (!this.all) {
                    if (this.isDuplicate(leftColumns)) continue;
                    this.prevCols = this.leftInputRow.getRowArrayClone();
                }
                int compare = 0;
                while (this.rightInputRow != null && (compare = this.compare(leftColumns, this.rightInputRow.getRowArray())) > 0) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow == null) continue;
                    ++this.rowsSeenRight;
                }
                if (this.rightInputRow == null || compare < 0) {
                    if (this.opType != 2) continue;
                    break;
                }
                SanityManager.ASSERT(this.rightInputRow != null && compare == 0, "Intersect/Except execution has gotten confused.");
                if (this.all) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow != null) {
                        ++this.rowsSeenRight;
                    }
                }
                if (this.opType != 1) continue;
                break;
            }
        }
        this.setCurrentRow(this.leftInputRow);
        if (this.currentRow != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return this.currentRow;
    }

    private void advanceRightPastDuplicates(DataValueDescriptor[] leftColumns) throws StandardException {
        while ((this.rightInputRow = this.rightSource.getNextRowCore()) != null) {
            ++this.rowsSeenRight;
            if (this.compare(leftColumns, this.rightInputRow.getRowArray()) != 0) continue;
        }
    }

    private int compare(DataValueDescriptor[] leftCols, DataValueDescriptor[] rightCols) throws StandardException {
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int colIdx = this.intermediateOrderByColumns[i];
            if (leftCols[colIdx].compare(1, rightCols[colIdx], true, this.intermediateOrderByNullsLow[i], false)) {
                return -1 * this.intermediateOrderByDirection[i];
            }
            if (leftCols[colIdx].compare(2, rightCols[colIdx], true, this.intermediateOrderByNullsLow[i], false)) continue;
            return this.intermediateOrderByDirection[i];
        }
        return 0;
    }

    private boolean isDuplicate(DataValueDescriptor[] curColumns) throws StandardException {
        if (this.prevCols == null) {
            return false;
        }
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int colIdx = this.intermediateOrderByColumns[i];
            if (curColumns[colIdx].compare(2, this.prevCols[colIdx], true, false)) continue;
            return false;
        }
        return true;
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.prevCols = null;
            this.leftSource.close();
            this.rightSource.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of SetOpResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.leftSource.finish();
        this.rightSource.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.leftSource.getTimeSpent(1) - this.rightSource.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.leftSource)).getRowLocation();
    }

    public int getOpType() {
        return this.opType;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public NoPutResultSet getLeftSourceInput() {
        return this.leftSource;
    }

    public NoPutResultSet getRightSourceInput() {
        return this.rightSource;
    }

    public int getRowsSeenLeft() {
        return this.rowsSeenLeft;
    }

    public int getRowsSeenRight() {
        return this.rowsSeenRight;
    }

    public int getRowsReturned() {
        return this.rowsReturned;
    }
}

