/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.io.StorageFile;

final class RemoveFile
implements Serviceable,
PrivilegedExceptionAction {
    private final StorageFile fileToGo;

    RemoveFile(StorageFile fileToGo) {
        this.fileToGo = fileToGo;
    }

    public int performWork(ContextManager context) throws StandardException {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
        return 1;
    }

    public boolean serviceASAP() {
        return false;
    }

    public boolean serviceImmediately() {
        return true;
    }

    public Object run() throws StandardException {
        if (this.fileToGo.exists() && !this.fileToGo.delete()) {
            throw StandardException.newException("XSDF4.S", this.fileToGo);
        }
        return null;
    }
}

