/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.tools.JDBCDisplayUtil;

public final class util
implements PrivilegedAction {
    private static boolean IS_AT_LEAST_JDBC2;
    private static final Class[] DS_GET_CONN_TYPES;
    private static final Class[] STRING_P;
    private static final Class[] INT_P;
    private String key;
    private static final String[][] protocolDrivers;

    private util() {
        boolean isAtLeastJDBC2;
        try {
            Class.forName("java.sql.Driver");
            isAtLeastJDBC2 = true;
        }
        catch (Throwable t) {
            isAtLeastJDBC2 = false;
        }
        IS_AT_LEAST_JDBC2 = isAtLeastJDBC2;
    }

    public static String getArg(String param, String[] args) {
        int pLocn;
        if (args == null) {
            return null;
        }
        for (pLocn = 0; pLocn < args.length && !param.equals(args[pLocn]); ++pLocn) {
        }
        if (pLocn >= args.length - 1) {
            return null;
        }
        return args[pLocn + 1];
    }

    public static boolean getPropertyArg(String[] args) throws IOException {
        InputStream in1;
        String n = util.getArg("-p", args);
        if (n != null) {
            in1 = new FileInputStream(n);
            in1 = new BufferedInputStream(in1);
        } else {
            n = util.getArg("-pr", args);
            if (n != null) {
                in1 = util.getResourceAsStream(n);
                if (in1 == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return false;
            }
        }
        Properties p = System.getProperties();
        util.loadWithTrimmedValues(in1, p);
        return true;
    }

    static String qualifyResourceName(String resourceName, boolean absolute) {
        if ((resourceName = resourceName.trim()).startsWith("/")) {
            return resourceName;
        }
        String pName = util.getSystemProperty("ij.defaultResourcePackage").trim();
        if (pName == null) {
            return null;
        }
        resourceName = pName.endsWith("/") ? pName + resourceName : pName + "/" + resourceName;
        if (absolute && !resourceName.startsWith("/")) {
            return null;
        }
        return resourceName;
    }

    public static InputStream getResourceAsStream(String resourceName) {
        final Class c = util.class;
        final String resource = util.qualifyResourceName(resourceName, true);
        if (resource == null) {
            return null;
        }
        InputStream is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream locis = c.getResourceAsStream(resource);
                return locis;
            }
        });
        if (is != null) {
            is = new BufferedInputStream(is, 2048);
        }
        return is;
    }

    public static String getFileArg(String[] args) throws IOException {
        boolean foundP = false;
        if (args == null) {
            return null;
        }
        String fileName = util.getArg("-f", args);
        if (fileName != null) {
            return fileName;
        }
        for (int ix = 0; ix < args.length; ++ix) {
            if (args[ix].equals("-f") || args[ix].equals("-fr") || args[ix].equals("-p") || args[ix].equals("-pr")) {
                ++ix;
                continue;
            }
            return args[ix];
        }
        return null;
    }

    public static String getInputResourceNameArg(String[] args) {
        return util.getArg("-fr", args);
    }

    public static boolean invalidArgs(String[] args) {
        boolean countSupported = false;
        boolean haveInput = false;
        for (int ix = 0; ix < args.length; ++ix) {
            if (!haveInput && (args[ix].equals("-f") || args[ix].equals("-fr"))) {
                haveInput = true;
                if (++ix < args.length) continue;
                return true;
            }
            if (args[ix].equals("-p") || args[ix].equals("-pr")) {
                if (++ix < args.length) continue;
                return true;
            }
            if (args[ix].equals("--help")) {
                return true;
            }
            if (!haveInput) {
                haveInput = true;
                continue;
            }
            return true;
        }
        return false;
    }

    static void Usage(LocalizedOutput out) {
        out.println(LocalizedResource.getMessage("IJ_UsageJavaComCloudToolsIjPPropeInput"));
        out.flush();
    }

    public static void setupDataSource(Object ds, String dbName, boolean firstTime) throws Exception {
        Method[] methods = ds.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            String name = m.getName();
            if (!name.startsWith("set") || name.length() <= "set".length() || name.equals("setCreateDatabase") && !firstTime) continue;
            String property = name.substring("set".length());
            property = "ij.dataSource." + property.substring(0, 1).toLowerCase(Locale.ENGLISH) + property.substring(1);
            String value = util.getSystemProperty(property);
            if (name.equals("setDatabaseName") && !firstTime) {
                value = dbName;
            }
            if (value == null) continue;
            try {
                m.invoke(ds, value);
                continue;
            }
            catch (Throwable ignore) {
                m.invoke(ds, Integer.valueOf(value));
            }
        }
    }

    public static Connection getDataSourceConnection(String dsName, String user, String password, String dbName, boolean firstTime) throws SQLException {
        Object ds = null;
        try {
            String[] stringArray;
            Method m;
            Class<?> dc = Class.forName(dsName);
            ds = dc.newInstance();
            util.setupDataSource(ds, dbName, firstTime);
            Method method = m = user == null ? dc.getMethod("getConnection", null) : dc.getMethod("getConnection", DS_GET_CONN_TYPES);
            if (user == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = user;
                stringArray = stringArray2;
                stringArray2[1] = password;
            }
            return (Connection)m.invoke(ds, stringArray);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof SQLException) {
                throw (SQLException)ite.getTargetException();
            }
            ite.printStackTrace(System.out);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public static Connection startJBMS(String defaultDriver, String defaultURL, Properties connInfo) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String jdbcProtocol;
        Connection con = null;
        String driverName = util.getSystemProperty("driver");
        if (driverName == null) {
            driverName = util.getSystemProperty("ij.driver");
        }
        if (driverName == null || driverName.length() == 0) {
            driverName = defaultDriver;
        }
        if (driverName != null && IS_AT_LEAST_JDBC2) {
            util.loadDriver(driverName);
        }
        if ((jdbcProtocol = util.getSystemProperty("ij.protocol")) != null && IS_AT_LEAST_JDBC2) {
            util.loadDriverIfKnown(jdbcProtocol);
        }
        String user = util.getSystemProperty("ij.user");
        String password = util.getSystemProperty("ij.password");
        String databaseURL = util.getSystemProperty("database");
        if (databaseURL == null) {
            databaseURL = util.getSystemProperty("ij.database");
        }
        if (databaseURL == null || databaseURL.length() == 0) {
            databaseURL = defaultURL;
        }
        if (databaseURL != null && IS_AT_LEAST_JDBC2) {
            if (databaseURL.startsWith("jdbc:")) {
                util.loadDriverIfKnown(databaseURL);
            }
            if (!databaseURL.startsWith("jdbc:") && jdbcProtocol != null) {
                databaseURL = jdbcProtocol + databaseURL;
            }
            connInfo = util.updateConnInfo(user, password, connInfo);
            String driver = util.getSystemProperty("driver");
            if (driver == null) {
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
            }
            util.loadDriver(driver);
            con = DriverManager.getConnection(databaseURL, connInfo);
            return con;
        }
        String dsName = util.getSystemProperty("ij.dataSource");
        if (dsName == null) {
            return null;
        }
        con = util.getDataSourceConnection(dsName, user, password, null, true);
        return con;
    }

    public static Properties updateConnInfo(String user, String password, Properties connInfo) {
        String ijGetMessages = util.getSystemProperty("ij.retrieveMessagesFromServerOnGetMessage");
        boolean retrieveMessages = false;
        if (util.isJCCFramework()) {
            retrieveMessages = true;
        }
        if (ijGetMessages != null) {
            retrieveMessages = !ijGetMessages.equals("false");
        }
        if (connInfo == null) {
            connInfo = new Properties();
        }
        if (retrieveMessages) {
            connInfo.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (user != null) {
            connInfo.put("user", user);
        }
        if (password != null) {
            connInfo.put("password", password);
        }
        return connInfo;
    }

    public static Connection startJBMS() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(null, null);
    }

    public static Connection startJBMS(String defaultDriver, String defaultURL) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(defaultDriver, defaultURL, null);
    }

    public static void DisplayVector(LocalizedOutput out, Vector v) {
        int l = v.size();
        for (int i = 0; i < l; ++i) {
            out.println(v.elementAt(i));
        }
    }

    public static void DisplayMulti(LocalizedOutput out, PreparedStatement ps, ResultSet rs, Connection conn) throws SQLException, ijException {
        boolean autoCommited = false;
        boolean exec = false;
        boolean anotherUsingRow = false;
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        anotherUsingRow = rs.next();
        while (!autoCommited && anotherUsingRow) {
            if (!exec) {
                exec = true;
                if (conn.getAutoCommit()) {
                    out.println(LocalizedResource.getMessage("IJ_IjWarniAutocMayCloseUsingResulSet"));
                    autoCommited = true;
                }
            }
            for (int c = 1; c <= numCols; ++c) {
                int sqlType = rsmd.getColumnType(c);
                if (sqlType == 3) {
                    if (IS_AT_LEAST_JDBC2) {
                        ps.setObject(c, rs.getObject(c), sqlType, rsmd.getScale(c));
                        continue;
                    }
                    try {
                        ps.setString(c, rs.getString(c));
                        continue;
                    }
                    catch (SQLException e) {
                        if ("22018".equals(e.getSQLState())) {
                            ps.setLong(c, rs.getLong(c));
                            continue;
                        }
                        throw e;
                    }
                }
                ps.setObject(c, rs.getObject(c), sqlType);
            }
            anotherUsingRow = rs.next();
            if (!anotherUsingRow || conn.getAutoCommit()) {
                rs.close();
            }
            ps.execute();
            JDBCDisplayUtil.DisplayResults(out, (Statement)ps, conn);
            ps.clearParameters();
        }
        if (!exec) {
            rs.close();
            throw ijException.noUsingResults();
        }
    }

    static final String getSystemProperty(String propertyName) {
        try {
            if (propertyName.startsWith("ij.") || propertyName.startsWith("derby.")) {
                util u = new util();
                u.key = propertyName;
                return (String)AccessController.doPrivileged(u);
            }
            return System.getProperty(propertyName);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public final Object run() {
        return System.getProperty(this.key);
    }

    private static void loadWithTrimmedValues(InputStream iStr, Properties prop) throws IOException {
        Properties p = new Properties();
        p.load(iStr);
        Enumeration<?> propKeys = p.propertyNames();
        while (propKeys.hasMoreElements()) {
            String tmpKey = (String)propKeys.nextElement();
            String tmpValue = p.getProperty(tmpKey);
            tmpValue = tmpValue.trim();
            prop.put(tmpKey, tmpValue);
        }
    }

    public static void loadDriverIfKnown(String jdbcProtocol) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (int i = 0; i < protocolDrivers.length; ++i) {
            if (!jdbcProtocol.startsWith(protocolDrivers[i][0])) continue;
            util.loadDriver(protocolDrivers[i][1]);
            break;
        }
    }

    public static void loadDriver(String driverClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(driverClass).newInstance();
    }

    private static boolean isJCCFramework() {
        String framework = util.getSystemProperty("framework");
        return framework != null && (framework.toUpperCase(Locale.ENGLISH).equals("DERBYNET") || framework.toUpperCase(Locale.ENGLISH).indexOf("JCC") != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectedSchema(Connection theConnection) throws SQLException {
        String schema = null;
        if (theConnection == null) {
            return null;
        }
        Statement st = theConnection.createStatement();
        try {
            if (!st.execute("VALUES CURRENT SCHEMA")) {
                String string = null;
                return string;
            }
            ResultSet rs = st.getResultSet();
            if (rs == null || !rs.next()) {
                String string = null;
                return string;
            }
            schema = rs.getString(1);
        }
        catch (SQLException sQLException) {
        }
        finally {
            st.close();
        }
        return schema;
    }

    static {
        DS_GET_CONN_TYPES = new Class[]{"".getClass(), "".getClass()};
        STRING_P = new Class[]{"".getClass()};
        INT_P = new Class[]{Integer.TYPE};
        protocolDrivers = new String[][]{{"jdbc:derby:net:", "com.ibm.db2.jcc.DB2Driver"}, {"jdbc:derby://", "org.apache.derby.jdbc.ClientDriver"}, {"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver"}};
    }
}

