/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.sanity;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AssertFailure
extends RuntimeException {
    private String threadDump = this.dumpThreads();

    public AssertFailure(String message, Throwable nestedError) {
        super(message, nestedError);
    }

    public AssertFailure(String message) {
        super(message);
    }

    public AssertFailure() {
    }

    public String getThreadDump() {
        return this.threadDump;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.threadDump);
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.threadDump);
    }

    private String dumpThreads() {
        StringWriter out = new StringWriter();
        PrintWriter p = new PrintWriter((Writer)out, true);
        try {
            Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Class<?> c = Class.forName("org.apache.derby.shared.common.sanity.ThreadDump");
            final Method m = c.getMethod("getStackDumpString", new Class[0]);
            String dump = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    return m.invoke(null, null);
                }
            });
            p.print("---------------\nStack traces for all live threads:");
            p.println("\n" + dump);
            p.println("---------------");
        }
        catch (NoSuchMethodException e) {
            p.println("(Skipping thread dump because it is not supported on JVM 1.4)");
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException && e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof AccessControlException) {
                p.println("(Skipping thread dump because of insufficient permissions:\n" + e.getCause().getCause() + ")\n");
            }
            p.println("\nAssertFailure tried to do a thread dump, but there was an error:");
            e.getCause().printStackTrace(p);
        }
        return out.toString();
    }
}

