/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;

public class JDBCDisplayUtil {
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    public static boolean showSelectCount = false;
    private static final int MAX_RETRIES = 0;

    public static void ShowException(PrintWriter out, Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(out, (SQLException)e);
        } else {
            e.printStackTrace(out);
        }
    }

    public static void ShowSQLException(PrintWriter out, SQLException e) {
        String errorCode = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? LocalizedResource.getMessage("UT_Error0", LocalizedResource.getNumber(e.getErrorCode())) : "";
        while (e != null) {
            String p1 = JDBCDisplayUtil.mapNull(e.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst"));
            String p2 = JDBCDisplayUtil.mapNull(e.getMessage(), LocalizedResource.getMessage("UT_NoMessa"));
            out.println(LocalizedResource.getMessage("UT_Error012", p1, p2, errorCode));
            JDBCDisplayUtil.doTrace(out, (Exception)e);
            e = e.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter out, Connection theConnection) {
        try {
            Object warning = null;
            if (theConnection != null) {
                JDBCDisplayUtil.ShowWarnings(out, theConnection.getWarnings());
            }
            if (theConnection != null) {
                theConnection.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintWriter out, SQLWarning warning) {
        while (warning != null) {
            String p1 = JDBCDisplayUtil.mapNull(warning.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst_7"));
            String p2 = JDBCDisplayUtil.mapNull(warning.getMessage(), LocalizedResource.getMessage("UT_NoMessa_8"));
            out.println(LocalizedResource.getMessage("UT_Warni01", p1, p2));
            warning = warning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintWriter out, ResultSet rs) {
        try {
            Object warning = null;
            if (rs != null) {
                JDBCDisplayUtil.ShowWarnings(out, rs.getWarnings());
            }
            if (rs != null) {
                rs.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintWriter out, Statement s) {
        try {
            Object warning = null;
            if (s != null) {
                JDBCDisplayUtil.ShowWarnings(out, s.getWarnings());
            }
            if (s != null) {
                s.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void DisplayResults(PrintWriter out, Statement stmt, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, stmt, conn, 0, null, null);
    }

    private static void indent_DisplayResults(PrintWriter out, Statement stmt, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        JDBCDisplayUtil.checkNotNull(stmt, "Statement");
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, indentLevel, displayColumns, displayColumnWidths);
            rs.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(out, stmt.getUpdateCount(), indentLevel);
        }
        JDBCDisplayUtil.ShowWarnings(out, stmt);
    }

    static void DisplayUpdateCount(PrintWriter out, int count, int indentLevel) {
        if (count == 1) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_1RowInserUpdatDelet"));
        } else if (count >= 0) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_0RowsInserUpdatDelet", LocalizedResource.getNumber(count)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_StateExecu"));
        }
    }

    private static int[] getColumnDisplayWidths(ResultSetMetaData rsmd, int[] dispColumns, boolean localizedOutput) throws SQLException {
        int count = dispColumns == null ? rsmd.getColumnCount() : dispColumns.length;
        int[] widths = new int[count];
        for (int i = 0; i < count; ++i) {
            int colnum = dispColumns == null ? i + 1 : dispColumns[i];
            int dispsize = localizedOutput ? LocalizedResource.getInstance().getColumnDisplaySize(rsmd, colnum) : rsmd.getColumnDisplaySize(colnum);
            widths[i] = Math.min(maxWidth, Math.max(rsmd.isNullable(colnum) == 0 ? 0 : 4, dispsize));
        }
        return widths;
    }

    public static void DisplayMultipleResults(PrintWriter out, List resultSets, Connection conn, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, resultSets, conn, 0, displayColumns, displayColumnWidths);
    }

    public static void DisplayResults(PrintWriter out, ResultSet rs, Connection conn, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, 0, displayColumns, displayColumnWidths);
    }

    private static void indent_DisplayResults(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
        resultSets.add(rs);
        JDBCDisplayUtil.indent_DisplayResults(out, resultSets, conn, 0, displayColumns, displayColumnWidths);
    }

    private static void indent_DisplayResults(PrintWriter out, List resultSets, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        ResultSetMetaData rsmd = null;
        if (resultSets != null && resultSets.size() > 0) {
            rsmd = ((ResultSet)resultSets.get(0)).getMetaData();
        }
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int numberOfRowsSelected = 0;
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        if (displayColumnWidths == null) {
            displayColumnWidths = JDBCDisplayUtil.getColumnDisplayWidths(rsmd, displayColumns, true);
        }
        int len = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        int retry = 0;
        ResultSet rs = null;
        boolean doNext = true;
        for (int i = 0; i < resultSets.size(); ++i) {
            rs = (ResultSet)resultSets.get(i);
            doNext = true;
            while (doNext) {
                try {
                    doNext = rs.next();
                    if (!doNext) continue;
                    JDBCDisplayUtil.DisplayRow(out, rs, rsmd, len, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
                    JDBCDisplayUtil.ShowWarnings(out, rs);
                    ++numberOfRowsSelected;
                }
                catch (SQLException e) {
                    if (++retry > 0) {
                        throw e;
                    }
                    JDBCDisplayUtil.ShowSQLException(out, e);
                }
            }
        }
        if (showSelectCount) {
            if (numberOfRowsSelected == 1) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_1RowSelec"));
            } else if (numberOfRowsSelected >= 0) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_0RowsSelec", LocalizedResource.getNumber(numberOfRowsSelected)));
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    private static void DisplayNestedResults(PrintWriter out, Vector nr, Connection conn, int indentLevel) throws SQLException {
        if (nr == null) {
            return;
        }
        String b = LocalizedResource.getMessage("UT_JDBCDisplayUtil_16");
        String oldString = "0";
        for (int i = 0; i < nr.size(); ++i) {
            LocalizedResource.OutputWriter().println();
            String t = Integer.toString(i);
            if (t.length() > oldString.length()) {
                oldString = t;
                b = b + LocalizedResource.getMessage("UT_JDBCDisplayUtil_17");
            }
            LocalizedResource.OutputWriter().println(b);
            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("UT_Resul0", LocalizedResource.getNumber(i)));
            LocalizedResource.OutputWriter().println(b);
            JDBCDisplayUtil.indent_DisplayResults(out, (ResultSet)nr.elementAt(i), conn, indentLevel, null, null);
        }
    }

    public static void DisplayNextRow(PrintWriter out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, true));
    }

    private static void indent_DisplayNextRow(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(rs, "ResultSet");
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        if (rs.next()) {
            int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
            JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, null, null);
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static void DisplayCurrentRow(PrintWriter out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, true));
    }

    private static void indent_DisplayCurrentRow(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        if (rs == null) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_NoCurreRow_19"));
            return;
        }
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static int DisplayBanner(PrintWriter out, ResultSetMetaData rsmd) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(rsmd, null, true));
    }

    private static int indent_DisplayBanner(PrintWriter out, ResultSetMetaData rsmd, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        int i;
        StringBuffer buf = new StringBuffer();
        int numCols = displayColumnWidths.length;
        int rowLen = numCols - 1;
        for (i = 1; i <= numCols; ++i) {
            rowLen += displayColumnWidths[i - 1];
        }
        buf.ensureCapacity(rowLen);
        for (i = 1; i <= numCols; ++i) {
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            String s = rsmd.getColumnLabel(colnum);
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                int k;
                buf.append(s);
                for (k = w - s.length(); k >= 64; k -= 64) {
                    buf.append("                                                                ");
                }
                while (k >= 16) {
                    buf.append("                ");
                    k -= 16;
                }
                while (k >= 4) {
                    buf.append("    ");
                    k -= 4;
                }
                while (k > 0) {
                    buf.append(' ');
                    --k;
                }
                continue;
            }
            if (s.length() > w) {
                if (w > 1) {
                    buf.append(s.substring(0, w - 1));
                }
                if (w <= 0) continue;
                buf.append('&');
                continue;
            }
            buf.append(s);
        }
        buf.setLength(Math.min(rowLen, 1024));
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        for (i = 0; i < Math.min(rowLen, 1024); ++i) {
            buf.setCharAt(i, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        buf = null;
        return rowLen;
    }

    private static void DisplayRow(PrintWriter out, ResultSet rs, ResultSetMetaData rsmd, int rowLen, Vector nestedResults, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.ensureCapacity(rowLen);
        int numCols = displayColumnWidths.length;
        for (int i = 1; i <= numCols; ++i) {
            String s;
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            switch (rsmd.getColumnType(colnum)) {
                default: {
                    s = LocalizedResource.getInstance().getLocalizedString(rs, rsmd, colnum);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object o = rs.getObject(colnum);
                    if (o == null) {
                        s = "NULL";
                        break;
                    }
                    if (o instanceof ResultSet && nestedResults != null) {
                        s = LocalizedResource.getMessage("UT_Resul0_20", LocalizedResource.getNumber(nestedResults.size()));
                        nestedResults.addElement(o);
                        break;
                    }
                    try {
                        s = rs.getString(colnum);
                        break;
                    }
                    catch (SQLException se) {
                        s = o.toString();
                    }
                }
            }
            if (s == null) {
                s = "NULL";
            }
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                StringBuffer fullS = new StringBuffer(s);
                fullS.ensureCapacity(w);
                for (int k = s.length(); k < w; ++k) {
                    fullS.append(' ');
                }
                s = fullS.toString();
            } else if (s.length() > w) {
                s = s.substring(0, w - 1) + "&";
            }
            buf.append(s);
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
    }

    public static void checkNotNull(Object o, String what) {
        if (o == null) {
            throw ijException.objectWasNull(what);
        }
    }

    public static String mapNull(String s, String nullValue) {
        if (s == null) {
            return nullValue;
        }
        return s;
    }

    public static void doTrace(PrintWriter out, Exception e) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            e.printStackTrace(out);
            out.flush();
        }
    }

    public static void setMaxDisplayWidth(int maxDisplayWidth) {
        maxWidth = maxDisplayWidth;
    }

    private static void indentedPrintLine(PrintWriter out, int indentLevel, String text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indentedPrintLine(PrintWriter out, int indentLevel, StringBuffer text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indent(PrintWriter out, int indentLevel) {
        for (int ictr = 0; ictr < indentLevel; ++ictr) {
            out.print("  ");
        }
    }

    public static void ShowException(PrintStream out, Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(out, (SQLException)e);
        } else {
            e.printStackTrace(out);
        }
    }

    public static void ShowSQLException(PrintStream out, SQLException e) {
        String errorCode = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? " (errorCode = " + e.getErrorCode() + ")" : "";
        while (e != null) {
            out.println("ERROR " + JDBCDisplayUtil.mapNull(e.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(e.getMessage(), "(no message)") + errorCode);
            JDBCDisplayUtil.doTrace(out, (Exception)e);
            e = e.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream out, Connection theConnection) {
        try {
            Object warning = null;
            if (theConnection != null) {
                JDBCDisplayUtil.ShowWarnings(out, theConnection.getWarnings());
            }
            if (theConnection != null) {
                theConnection.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintStream out, SQLWarning warning) {
        while (warning != null) {
            out.println("WARNING " + JDBCDisplayUtil.mapNull(warning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(warning.getMessage(), "(no message)"));
            warning = warning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream out, ResultSet rs) {
        try {
            Object warning = null;
            if (rs != null) {
                JDBCDisplayUtil.ShowWarnings(out, rs.getWarnings());
            }
            if (rs != null) {
                rs.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintStream out, Statement s) {
        try {
            Object warning = null;
            if (s != null) {
                JDBCDisplayUtil.ShowWarnings(out, s.getWarnings());
            }
            if (s != null) {
                s.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void DisplayResults(PrintStream out, Statement stmt, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, stmt, conn, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream out, Statement stmt, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        JDBCDisplayUtil.checkNotNull(stmt, "Statement");
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, indentLevel, displayColumns, displayColumnWidths);
            rs.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(out, stmt.getUpdateCount(), indentLevel);
        }
        JDBCDisplayUtil.ShowWarnings(out, stmt);
    }

    static void DisplayUpdateCount(PrintStream out, int count, int indentLevel) {
        if (count == 1) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "1 row inserted/updated/deleted");
        } else if (count >= 0) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, count + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int numberOfRowsSelected = 0;
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        if (displayColumnWidths == null) {
            displayColumnWidths = JDBCDisplayUtil.getColumnDisplayWidths(rsmd, displayColumns, false);
        }
        int len = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        boolean doNext = true;
        int retry = 0;
        while (doNext) {
            try {
                doNext = rs.next();
                if (!doNext) continue;
                JDBCDisplayUtil.DisplayRow(out, rs, rsmd, len, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
                JDBCDisplayUtil.ShowWarnings(out, rs);
                ++numberOfRowsSelected;
            }
            catch (SQLException e) {
                if (++retry > 0) {
                    throw e;
                }
                JDBCDisplayUtil.ShowSQLException(out, e);
            }
        }
        if (showSelectCount) {
            if (numberOfRowsSelected == 1) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "1 row selected");
            } else if (numberOfRowsSelected >= 0) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, numberOfRowsSelected + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    private static void DisplayNestedResults(PrintStream out, Vector nr, Connection conn, int indentLevel) throws SQLException {
        if (nr == null) {
            return;
        }
        String s = "+ ResultSet #";
        String b = "++++++++++++++++";
        String oldString = "0";
        for (int i = 0; i < nr.size(); ++i) {
            System.out.println();
            String t = Integer.toString(i);
            if (t.length() > oldString.length()) {
                oldString = t;
                b = b + "+";
            }
            System.out.println(b);
            System.out.println(s + i + " +");
            System.out.println(b);
            JDBCDisplayUtil.indent_DisplayResults(out, (ResultSet)nr.elementAt(i), conn, indentLevel, null, null);
        }
    }

    public static void DisplayNextRow(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, false));
    }

    private static void indent_DisplayNextRow(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(rs, "ResultSet");
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        if (rs.next()) {
            int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, null, null);
            JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static void DisplayCurrentRow(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, false));
    }

    private static void indent_DisplayCurrentRow(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        if (rs == null) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage("UT_NoCurreRow_19"));
            return;
        }
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static int DisplayBanner(PrintStream out, ResultSetMetaData rsmd) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(rsmd, null, false));
    }

    private static int indent_DisplayBanner(PrintStream out, ResultSetMetaData rsmd, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        int i;
        StringBuffer buf = new StringBuffer();
        int numCols = displayColumnWidths.length;
        int rowLen = numCols - 1;
        for (i = 1; i <= numCols; ++i) {
            rowLen += displayColumnWidths[i - 1];
        }
        buf.ensureCapacity(rowLen);
        for (i = 1; i <= numCols; ++i) {
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            String s = rsmd.getColumnLabel(colnum);
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                int k;
                StringBuffer blanks = new StringBuffer(s);
                blanks.ensureCapacity(w);
                for (k = blanks.length() + 64; k <= w; k += 64) {
                    blanks.append("                                                                ");
                }
                for (k = blanks.length() + 16; k <= w; k += 16) {
                    blanks.append("                ");
                }
                for (k = blanks.length() + 4; k <= w; k += 4) {
                    blanks.append("    ");
                }
                for (k = blanks.length(); k < w; ++k) {
                    blanks.append(' ');
                }
                buf.append(blanks);
                continue;
            }
            if (s.length() > w) {
                if (w > 1) {
                    buf.append(s.substring(0, w - 1));
                }
                if (w <= 0) continue;
                buf.append('&');
                continue;
            }
            buf.append(s);
        }
        buf.setLength(Math.min(rowLen, 1024));
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        for (i = 0; i < Math.min(rowLen, 1024); ++i) {
            buf.setCharAt(i, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        buf = null;
        return rowLen;
    }

    private static void DisplayRow(PrintStream out, ResultSet rs, ResultSetMetaData rsmd, int rowLen, Vector nestedResults, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.ensureCapacity(rowLen);
        int numCols = displayColumnWidths.length;
        for (int i = 1; i <= numCols; ++i) {
            String s;
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            switch (rsmd.getColumnType(colnum)) {
                default: {
                    s = rs.getString(colnum);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object o = rs.getObject(colnum);
                    if (o == null) {
                        s = "NULL";
                        break;
                    }
                    if (o instanceof ResultSet && nestedResults != null) {
                        s = "ResultSet #" + nestedResults.size();
                        nestedResults.addElement(o);
                        break;
                    }
                    try {
                        s = rs.getString(colnum);
                        break;
                    }
                    catch (SQLException se) {
                        s = o.toString();
                    }
                }
            }
            if (s == null) {
                s = "NULL";
            }
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                StringBuffer fullS = new StringBuffer(s);
                fullS.ensureCapacity(w);
                for (int k = s.length(); k < w; ++k) {
                    fullS.append(' ');
                }
                s = fullS.toString();
            } else if (s.length() > w) {
                s = s.substring(0, w - 1) + "&";
            }
            buf.append(s);
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
    }

    public static void doTrace(PrintStream out, Exception e) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            e.printStackTrace(out);
            out.flush();
        }
    }

    private static void indentedPrintLine(PrintStream out, int indentLevel, String text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indentedPrintLine(PrintStream out, int indentLevel, StringBuffer text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indent(PrintStream out, int indentLevel) {
        for (int ictr = 0; ictr < indentLevel; ++ictr) {
            out.print("  ");
        }
    }

    private static boolean getSystemBoolean(final String name) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Boolean.getBoolean(name) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static {
        LocalizedResource.getInstance();
    }
}

