/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.custom.LinkSelectionListener;
import org.eclipse.vtp.desktop.core.custom.LinkViewerSelectionListener;
import org.eclipse.vtp.desktop.core.custom.TextLink;

public class TextLinkViewer
extends Composite
implements PaintListener,
LinkSelectionListener {
    private List<TextLink> links = new ArrayList<TextLink>();
    private TextLink selectedLink;
    private List<LinkViewerSelectionListener> listeners = new ArrayList<LinkViewerSelectionListener>();

    public TextLinkViewer(Composite parent, int style) {
        super(parent, style);
        this.setBackground(parent.getBackground());
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 1;
        gl.marginHeight = 1;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.addPaintListener(this);
    }

    public void addLink(String link) {
        TextLink linkControl = new TextLink(link, this, 0);
        GridData linkControlData = new GridData(768);
        linkControl.setLayoutData(linkControlData);
        this.links.add(linkControl);
        if (this.links.size() == 1) {
            linkControl.setSelected(true);
            this.selectedLink = linkControl;
        }
        linkControl.addSelectionListener(this);
    }

    public void paintControl(PaintEvent e) {
        e.gc.setForeground(e.display.getSystemColor(16));
        if (this.links.size() > 0) {
            e.gc.drawLine(0, 0, this.getSize().x, 0);
        }
        int i = 0;
        while (i < this.links.size()) {
            Control c = (Control)this.links.get(i);
            e.gc.drawLine(0, c.getLocation().y + c.getSize().y, this.getSize().x, c.getLocation().y + c.getSize().y);
            ++i;
        }
    }

    @Override
    public void linkSelected(TextLink link) {
        if (link.isSelected() && link != this.selectedLink) {
            this.selectedLink.setSelected(false);
            this.selectedLink = link;
            this.fireSelectionChanged();
        }
    }

    public void addSelectionListener(LinkViewerSelectionListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removeSelectionListener(LinkViewerSelectionListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionChanged() {
        for (LinkViewerSelectionListener listener : this.listeners) {
            listener.selectionChanged(this.selectedLink.getLinkText());
        }
    }
}

