/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.custom;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ToggleButton
extends Canvas
implements PaintListener,
MouseListener,
MouseTrackListener {
    private boolean selected = false;
    private boolean toggleDownOnly = false;
    private boolean over = false;
    private String text = "";
    private List<ToggleButtonListener> listeners = new LinkedList<ToggleButtonListener>();

    public ToggleButton(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseTrackListener(this);
        this.setCursor(parent.getDisplay().getSystemCursor(21));
    }

    public void paintControl(PaintEvent arg0) {
        GC g = arg0.gc;
        Color background = g.getBackground();
        Color deactivatedColor = new Color(g.getDevice(), 200, 200, 200);
        Color hoverColor = new Color(g.getDevice(), 175, 175, 175);
        Color activatedColor = new Color(g.getDevice(), 137, 173, 233);
        Color foreground = g.getForeground();
        Color white = g.getDevice().getSystemColor(1);
        g.setForeground(white);
        if (this.selected) {
            g.setBackground(activatedColor);
        } else if (this.over) {
            g.setBackground(hoverColor);
        } else {
            g.setBackground(deactivatedColor);
        }
        g.setAntialias(1);
        g.fillOval(0, 0, 16, 16);
        g.setBackground(background);
        Point extent = g.stringExtent(this.text);
        int sx = (16 - extent.x) / 2;
        int sy = (16 - extent.y) / 2;
        g.drawString(this.text, sx, sy, true);
        g.setForeground(foreground);
        deactivatedColor.dispose();
        activatedColor.dispose();
        hoverColor.dispose();
    }

    public Point computeSize(int hint, int hint2) {
        return new Point(16, 16);
    }

    public void setText(String text) {
        this.text = text;
        if (this.text.length() > 1) {
            this.text = text.substring(0, 1);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.redraw();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setToggleDownOnly(boolean toggleDownOnly) {
        this.toggleDownOnly = toggleDownOnly;
        if (this.selected && toggleDownOnly) {
            this.setCursor(Display.getCurrent().getSystemCursor(0));
        } else {
            this.setCursor(Display.getCurrent().getSystemCursor(21));
        }
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
        if (this.selected && this.toggleDownOnly) {
            return;
        }
        this.selected = !this.selected;
        this.redraw();
        if (this.selected && this.toggleDownOnly) {
            this.setCursor(Display.getCurrent().getSystemCursor(0));
        }
        for (ToggleButtonListener listener : this.listeners) {
            listener.toggleButtonSelected(this);
        }
    }

    public void addSelectionListener(ToggleButtonListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ToggleButtonListener listener) {
        this.listeners.remove(listener);
    }

    public void mouseEnter(MouseEvent arg0) {
        this.over = true;
        this.redraw();
        if (this.toggleDownOnly && !this.selected || !this.toggleDownOnly) {
            this.setCursor(Display.getCurrent().getSystemCursor(21));
        }
    }

    public void mouseExit(MouseEvent arg0) {
        this.over = false;
        this.redraw();
    }

    public void mouseHover(MouseEvent arg0) {
    }

    public static interface ToggleButtonListener {
        public void toggleButtonSelected(ToggleButton var1);
    }
}

