/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.configuration;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanelProvider;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.osgi.framework.Bundle;

public class ComponentPropertiesPanelProviderRegistry {
    public static String PANEL_PROVIDER_EXTENSION_ID = "org.eclipse.vtp.desktop.editors.core.componentPropertiesPanelProvider";
    private static ComponentPropertiesPanelProviderRegistry instance = new ComponentPropertiesPanelProviderRegistry();
    private List<ComponentPropertiesPanelProvider> providers = new LinkedList<ComponentPropertiesPanelProvider>();

    public static ComponentPropertiesPanelProviderRegistry getInstance() {
        return instance;
    }

    public ComponentPropertiesPanelProviderRegistry() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PANEL_PROVIDER_EXTENSION_ID);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class providerClass = contributor.loadClass(className);
                if (!ComponentPropertiesPanelProvider.class.isAssignableFrom(providerClass)) {
                    throw new IllegalArgumentException("The provided class is not a ComponentPropertiesPanelProvider: " + providerClass);
                }
                ComponentPropertiesPanelProvider providerObject = (ComponentPropertiesPanelProvider)providerClass.newInstance();
                this.providers.add(providerObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean hasPropertiesPanels(IDesignComponent component) {
        for (ComponentPropertiesPanelProvider provider : this.providers) {
            if (!provider.isApplicableFor(component)) continue;
            return true;
        }
        return false;
    }

    public List<ComponentPropertiesPanel> getPropertiesPanels(IDesignComponent component) {
        ArrayList<ComponentPropertiesPanel> ret = new ArrayList<ComponentPropertiesPanel>();
        for (ComponentPropertiesPanelProvider provider : this.providers) {
            if (!provider.isApplicableFor(component)) continue;
            List<ComponentPropertiesPanel> ps = provider.getPropertiesPanels(component);
            for (ComponentPropertiesPanel cpp : ps) {
                boolean inserted = false;
                int i = 0;
                while (i < ret.size()) {
                    if (cpp.getRanking() < ((ComponentPropertiesPanel)((Object)ret.get(i))).getRanking()) {
                        ret.add(i, cpp);
                        inserted = true;
                        break;
                    }
                    ++i;
                }
                if (inserted) continue;
                ret.add(cpp);
            }
        }
        return ret;
    }
}

