/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.editors.core.configuration.ConfigurationContextSelectorListener;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContext;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContextRegistry;

public class ConfigurationContextSelector {
    private List<ConfigurationContextHolder> holders = new LinkedList<ConfigurationContextHolder>();
    private List<ConfigurationContextSelectorListener> listeners = new LinkedList<ConfigurationContextSelectorListener>();

    public ConfigurationContextSelector(IWorkflowProject workflowProject) {
        List contexts = ConfigurationContextRegistry.getInstance().getConfigurationContextsFor(workflowProject);
        for (ConfigurationContext context : contexts) {
            ConfigurationContextHolder holder = new ConfigurationContextHolder(context);
            this.holders.add(holder);
        }
    }

    public void setContextFilter(List<String> interestingContexts) {
        for (ConfigurationContextHolder holder : this.holders) {
            if (interestingContexts.contains(holder.context.getId())) {
                holder.activate();
                continue;
            }
            holder.deactivate();
        }
    }

    public Control createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        int columns = Math.min(this.holders.size() * 2, 6);
        comp.setLayout((Layout)new GridLayout(columns, false));
        for (ConfigurationContextHolder holder : this.holders) {
            holder.createControl(comp);
        }
        comp.layout(true, true);
        this.fireSelectionChanged(null);
        return comp;
    }

    public void addListener(ConfigurationContextSelectorListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
        HashMap<String, Object> contextValues = new HashMap<String, Object>();
        for (ConfigurationContextHolder h : this.holders) {
            contextValues.put(h.context.getId(), h.getSelection());
        }
        listener.contextSelectionChanged(contextValues);
    }

    public void removeListener(ConfigurationContextSelectorListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged(ConfigurationContextHolder holder) {
        HashMap<String, Object> contextValues = new HashMap<String, Object>();
        boolean updated = false;
        int cycle = 0;
        do {
            ++cycle;
            updated = false;
            for (ConfigurationContextHolder h : this.holders) {
                contextValues.put(h.context.getId(), h.getSelection());
            }
            for (ConfigurationContextHolder h : this.holders) {
                boolean contextUpdated = h.context.setConfigurationContext(contextValues);
                h.refreshContext();
                boolean bl = updated = updated || contextUpdated;
            }
        } while (updated && cycle < 1000);
        for (ConfigurationContextSelectorListener l : this.listeners) {
            l.contextSelectionChanged(contextValues);
        }
    }

    public class ConfigurationContextHolder
    extends BaseLabelProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        ConfigurationContext context = null;
        ComboViewer viewer = null;
        boolean active = true;

        ConfigurationContextHolder(ConfigurationContext context) {
            this.context = context;
        }

        void createControl(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(this.context.getName());
            label.setBackground(parent.getBackground());
            label.setLayoutData((Object)new GridData());
            Combo combo = new Combo(parent, 12);
            this.viewer = new ComboViewer(combo);
            this.viewer.getControl().setLayoutData((Object)new GridData(768));
            this.viewer.setContentProvider((IContentProvider)this);
            this.viewer.setLabelProvider((IBaseLabelProvider)this);
            this.viewer.setInput((Object)this);
            Object[] elements = this.getElements((Object)this);
            if (elements.length > 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection(elements[0]));
            }
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!event.getSelection().isEmpty()) {
                        ConfigurationContextSelector.this.fireSelectionChanged(ConfigurationContextHolder.this);
                    }
                }
            });
        }

        public void refreshContext() {
            Object[] elements;
            this.viewer.refresh();
            if (this.viewer.getSelection().isEmpty() && (elements = this.getElements((Object)this)).length > 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection(elements[0]));
            }
        }

        public Object getSelection() {
            return this.viewer == null ? null : ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        }

        public void activate() {
            this.active = true;
            if (this.viewer != null) {
                this.viewer.getControl().setEnabled(true);
            }
        }

        public void deactivate() {
            this.active = false;
            if (this.viewer != null) {
                this.viewer.getControl().setEnabled(false);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.context.getValues().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.context.getLabel(element);
        }
    }
}

