/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vtp.desktop.editors.core.Activator;
import org.eclipse.vtp.desktop.editors.core.controller.BasicController;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.controller.ModelNavigationListener;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UndoSystem;
import org.eclipse.vtp.desktop.editors.themes.core.CanvasFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ElementFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ThemeManager;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignDocumentListener;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignViewer;
import org.eclipse.vtp.desktop.model.core.internal.DesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.DesignWriter;
import org.eclipse.vtp.desktop.model.core.internal.IDesignFilter;
import org.eclipse.vtp.desktop.model.core.internal.PartialDesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.views.pallet.PalletFocusListener;
import org.eclipse.vtp.desktop.views.pallet.PalletFocusProvider;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationEditor
extends EditorPart
implements ControllerListener,
ModelNavigationListener,
PalletFocusProvider,
IDesignDocumentListener,
IDesignViewer,
UndoSystem {
    boolean dirty = false;
    List<CanvasRecord> designs = new ArrayList<CanvasRecord>();
    Map<String, Object> resourceMap = new HashMap<String, Object>();
    CanvasRecord currentCanvas = null;
    IWorkflowProject project = null;
    IDesignDocument designDocument = null;
    CTabFolder canvasTabs = null;
    private List<PalletFocusListener> palletListeners = new LinkedList<PalletFocusListener>();
    IOperationHistory operationHistory = null;
    private UndoActionHandler undoActionHandler;
    private RedoActionHandler redoActionHandler;
    private IPartListener partListener;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        this.operationHistory = workbench.getOperationSupport().getOperationHistory();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        FileEditorInput fileInput = (FileEditorInput)input;
        try {
            this.project = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(fileInput.getFile().getProject());
            this.setPartName(fileInput.getName());
            this.designDocument = (IDesignDocument)WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource((IResource)fileInput.getFile());
            this.designDocument.becomeWorkingCopy();
            this.designDocument.addDocumentListener((IDesignDocumentListener)this);
            RenderedModel mainDesign = new RenderedModel(this.designDocument.getMainDesign());
            CanvasRecord mainRecord = new CanvasRecord(mainDesign);
            mainDesign.setUndoSystem(this);
            mainDesign.setUndoContext(mainRecord.undoContext);
            this.currentCanvas = mainRecord;
            this.designs.add(mainRecord);
            for (IDesign dialogDesign : this.designDocument.getDialogDesigns()) {
                RenderedModel dialogModel = new RenderedModel(dialogDesign);
                CanvasRecord dialogRecord = new CanvasRecord(dialogModel);
                dialogModel.setUndoSystem(this);
                dialogModel.setUndoContext(dialogRecord.undoContext);
                this.designs.add(dialogRecord);
            }
            this.undoActionHandler = new UndoActionHandler((IWorkbenchPartSite)site, this.currentCanvas.undoContext);
            this.undoActionHandler.setPruneHistory(true);
            this.redoActionHandler = new RedoActionHandler((IWorkbenchPartSite)site, this.currentCanvas.undoContext);
            this.redoActionHandler.setPruneHistory(true);
            this.partListener = new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                    System.out.println("part activated: " + part);
                    if (part != ApplicationEditor.this) {
                        System.out.println("part activated but not me: " + part);
                        return;
                    }
                    IEditorSite site = (IEditorSite)ApplicationEditor.this.getSite();
                    site.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)ApplicationEditor.this.undoActionHandler);
                    site.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)ApplicationEditor.this.redoActionHandler);
                    site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action("Copy"){

                        public void run() {
                            SelectionStructure selection = (this).ApplicationEditor.this.currentCanvas.renderedCanvas.getSelection();
                            if (selection.getPrimarySelection() instanceof ConnectorFrame) {
                                return;
                            }
                            ApplicationEditor.this.copySelectionToClipboard(selection);
                        }
                    });
                    site.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new Action("Cut"){

                        public void run() {
                            SelectionStructure selection = (this).ApplicationEditor.this.currentCanvas.renderedCanvas.getSelection();
                            if (selection.getPrimarySelection() instanceof ConnectorFrame) {
                                return;
                            }
                            ApplicationEditor.this.copySelectionToClipboard(selection);
                            (this).ApplicationEditor.this.currentCanvas.renderedCanvas.deleteSelectedItems();
                        }
                    });
                    site.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action("Paste"){

                        public void run() {
                            Clipboard clipboard = new Clipboard((this).ApplicationEditor.this.canvasTabs.getDisplay());
                            String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                            if (text != null) {
                                try {
                                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                    factory.setNamespaceAware(true);
                                    DocumentBuilder builder = factory.newDocumentBuilder();
                                    Document document = builder.parse(new ByteArrayInputStream(text.getBytes()));
                                    PartialDesignDocument pdd = new PartialDesignDocument((this).ApplicationEditor.this.designDocument, null, document);
                                    PasteOperation po = new PasteOperation(pdd, (this).ApplicationEditor.this.currentCanvas);
                                    po.addContext((this).ApplicationEditor.this.currentCanvas.undoContext);
                                    (this).ApplicationEditor.this.operationHistory.execute((IUndoableOperation)po, null, null);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                    site.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new Action("Print"){

                        public void run() {
                            Shell workbenchShell = Display.getCurrent().getActiveShell();
                            PrintDialog pd = new PrintDialog(workbenchShell);
                            pd.setStartPage(1);
                            pd.setEndPage((this).ApplicationEditor.this.designs.size());
                            PrinterData printerData = pd.open();
                            if (printerData != null) {
                                Printer printer = new Printer(printerData);
                                printer.startJob("Print Callflow");
                                int i = printerData.startPage - 1;
                                while (i < Math.min(printerData.endPage, (this).ApplicationEditor.this.designs.size())) {
                                    CanvasRecord cr = (this).ApplicationEditor.this.designs.get(i);
                                    RenderedModel renderedModel = cr.renderedCanvas;
                                    printer.startPage();
                                    Point dpi = printer.getDPI();
                                    System.out.println("printer dpi: " + dpi.x + ", " + dpi.y);
                                    float scaleX = (float)dpi.x / 96.0f;
                                    float scaleY = (float)dpi.y / 96.0f;
                                    Rectangle clientArea = printer.getClientArea();
                                    System.out.println("Client Area: " + clientArea);
                                    int printerOrientation = clientArea.width > clientArea.height ? 2 : 1;
                                    GC gc = new GC((Drawable)printer);
                                    Transform transform = new Transform((Device)printer);
                                    if (scaleX != 1.0f || scaleY != 1.0f) {
                                        transform.scale(scaleX, scaleY);
                                    }
                                    if (renderedModel.getUIModel().getOrientation() != printerOrientation) {
                                        transform.translate((float)(renderedModel.getUIModel().getHeight() / 2), (float)(renderedModel.getUIModel().getHeight() / 2));
                                        transform.rotate(90.0f);
                                        transform.translate(-1.0f * (float)renderedModel.getUIModel().getHeight() / 2.0f, -1.0f * (float)renderedModel.getUIModel().getHeight() / 2.0f);
                                    }
                                    gc.setTransform(transform);
                                    gc.setLineWidth(1);
                                    renderedModel.paintCanvas(gc, (this).ApplicationEditor.this.resourceMap, 16);
                                    transform.dispose();
                                    gc.dispose();
                                    printer.endPage();
                                    ++i;
                                }
                                printer.endJob();
                                printer.dispose();
                            }
                        }
                    });
                    site.getActionBars().updateActionBars();
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                    System.out.println("part brought to top: " + part);
                }

                public void partClosed(IWorkbenchPart part) {
                    System.out.println("part closed: " + part);
                }

                public void partDeactivated(IWorkbenchPart part) {
                    System.out.println("part deactivated: " + part);
                }

                public void partOpened(IWorkbenchPart part) {
                    System.out.println("part opened: " + part);
                }
            };
            site.getPage().addPartListener(this.partListener);
        }
        catch (Exception ex) {
            throw new PartInitException("Unable to read file", (Throwable)ex);
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    private void copySelectionToClipboard(SelectionStructure selection) {
        IDesignFilter selectionFilter = new IDesignFilter(selection){
            List<IDesignComponent> components = new ArrayList<IDesignComponent>();
            {
                for (ComponentFrame cf : selectionStructure.getSelectedItems()) {
                    this.components.add(cf.getDesignComponent());
                }
                for (ComponentFrame cf : selectionStructure.getSecondarySelectedItems()) {
                    this.components.add(cf.getDesignComponent());
                }
            }

            public boolean matches(IDesignComponent component) {
                for (IDesignComponent dc : this.components) {
                    if (!dc.getId().equals(component.getId())) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            DesignWriter writer = new DesignWriter();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "design-fragment", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", "4.0.0");
            if (!this.currentCanvas.renderedCanvas.getUIModel().equals(this.designDocument.getMainDesign())) {
                rootElement.setAttribute("dialog-only", "true");
                writer.writeDesign(rootElement, (Design)this.currentCanvas.renderedCanvas.getUIModel(), selectionFilter);
            } else {
                writer.writeDesign(rootElement, (Design)this.designDocument.getMainDesign(), selectionFilter);
                Element dialogsElement = rootElement.getOwnerDocument().createElement("dialogs");
                rootElement.appendChild(dialogsElement);
                block2: for (IDesign dialogDesign : this.designDocument.getDialogDesigns()) {
                    List<ComponentFrame> items = selection.getSelectedItems();
                    for (ComponentFrame cf : items) {
                        if (!cf.getDesignComponent().getId().equals(dialogDesign.getDesignId())) continue;
                        writer.writeDesign(dialogsElement, (Design)dialogDesign);
                        continue block2;
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transfactory = TransformerFactory.newInstance();
            Transformer t = transfactory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(document), new XMLWriter((OutputStream)baos).toXMLResult());
            Clipboard clipboard = new Clipboard(this.canvasTabs.getDisplay());
            clipboard.setContents(new Object[]{baos.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArrayList<Object> values = new ArrayList<Object>();
                values.addAll(ApplicationEditor.this.resourceMap.values());
                int i = 0;
                while (i < values.size()) {
                    if (values.get(i) instanceof Resource) {
                        ((Resource)values.get(i)).dispose();
                    }
                    ++i;
                }
                ApplicationEditor.this.resourceMap.clear();
            }
        });
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        File workingLocation = fileInput.getFile().getProject().getWorkingLocation("org.eclipse.vtp.desktop.model.core").toFile();
        File iconPath = new File(workingLocation, String.valueOf(fileInput.getFile().getProjectRelativePath().toString()) + "/");
        System.out.println(iconPath);
        iconPath.mkdirs();
        GC gc = new GC((Drawable)parent);
        this.canvasTabs = new CTabFolder(parent, 1024);
        for (CanvasRecord cr : this.designs) {
            RenderedModel renderedModel = cr.renderedCanvas;
            renderedModel.initializeGraphics(gc, this.resourceMap);
            if (renderedModel.getUIModel().getDocument().getDesignThumbnail(renderedModel.getUIModel().getDesignId()) == null) {
                try {
                    float scale = cr.renderedCanvas.getUIModel().getOrientation() == 2 ? 100.0f / (float)cr.renderedCanvas.getUIModel().getWidth() : 100.0f / (float)cr.renderedCanvas.getUIModel().getHeight();
                    Image icon = new Image((Device)Display.getCurrent(), 100, 100);
                    GC gc2 = new GC((Drawable)icon);
                    Transform transform = new Transform((Device)Display.getCurrent());
                    transform.scale(scale, scale);
                    gc2.setTransform(transform);
                    gc2.setLineWidth(1);
                    cr.renderedCanvas.paintCanvas(gc2, this.resourceMap, 2);
                    transform.dispose();
                    gc2.dispose();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{icon.getImageData()};
                    File iconFile = new File(iconPath, String.valueOf(cr.renderedCanvas.getUIModel().getDesignId()) + ".jpg");
                    FileOutputStream fos = new FileOutputStream(iconFile);
                    imageLoader.save((OutputStream)fos, 4);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            CTabItem canvasTab = new CTabItem(this.canvasTabs, 0);
            canvasTab.setText(renderedModel.getUIModel().getName());
            canvasTab.setControl(cr.createControls((Composite)this.canvasTabs));
            canvasTab.setData((Object)cr);
        }
        this.canvasTabs.setSelection(0);
        gc.dispose();
        this.canvasTabs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = ApplicationEditor.this.canvasTabs.getSelection();
                ApplicationEditor.this.setCurrentCanvas((CanvasRecord)item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        parent.setLayout((Layout)new FillLayout());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.designDocument.commitWorkingCopy();
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.vtp.desktop.editors.core", 0, "Could not save file: " + this.designDocument.getUnderlyingFile().getFullPath(), (Throwable)ex);
            Activator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Saving", (String)("An error occured while saving.\n\n" + ex.getMessage()));
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void setFocus() {
    }

    @Override
    public void graphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        GC gc = new GC((Drawable)this.currentCanvas.canvas);
        this.currentCanvas.controller.paintCanvas(gc);
        gc.dispose();
    }

    @Override
    public void selectionChanged(SelectionStructure selection) {
    }

    public boolean supportsMultipleCanvases() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.equals(ModelNavigationListener.class)) {
            return this;
        }
        if (adapter.equals(IResource.class)) {
            return ((FileEditorInput)this.getEditorInput()).getFile();
        }
        if (adapter.equals(IDesign.class)) {
            return this.currentCanvas.renderedCanvas.getUIModel();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void navigateToElement(String elementId) {
        this.designDocument.getProject().navigateToElement(elementId);
    }

    public void displayElement(String elementId) {
        CanvasRecord cr = this.designs.get(0);
        for (ElementFrame elementFrame : cr.renderedCanvas.getElementFrames()) {
            if (!elementFrame.getDesignElement().getId().equals(elementId)) continue;
            Rectangle rec = elementFrame.getBounds();
            cr.displayRegion(rec);
            break;
        }
    }

    @Override
    public void showDesign(String designId) {
        if (this.designDocument.getMainDesign().getDesignId().equals(designId)) {
            this.canvasTabs.setSelection(0);
        } else {
            List dialogDesigns = this.designDocument.getDialogDesigns();
            int i = 0;
            while (i < dialogDesigns.size()) {
                IDesign dialogDesign = (IDesign)dialogDesigns.get(i);
                if (dialogDesign.getDesignId().equals(designId)) {
                    this.canvasTabs.setSelection(i + 1);
                    break;
                }
                ++i;
            }
        }
        CTabItem item = this.canvasTabs.getSelection();
        this.setCurrentCanvas((CanvasRecord)item.getData());
    }

    private void setCurrentCanvas(CanvasRecord cr) {
        this.currentCanvas = cr;
        this.undoActionHandler.setContext(this.currentCanvas.undoContext);
        this.redoActionHandler.setContext(this.currentCanvas.undoContext);
        this.currentCanvas.canvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApplicationEditor.this.currentCanvas.canvas.redraw();
            }
        });
        for (PalletFocusListener focusListener : this.palletListeners) {
            focusListener.focusChanged(this.currentCanvas.renderedCanvas.getUIModel());
        }
    }

    public void addFocusListener(PalletFocusListener focusListener) {
        this.palletListeners.remove(focusListener);
        this.palletListeners.add(focusListener);
    }

    public void removeFocusListener(PalletFocusListener focusListener) {
        this.palletListeners.remove(focusListener);
    }

    private void updateTab(CanvasRecord cr) {
        CTabItem[] cTabItemArray = this.canvasTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData().equals(cr)) {
                item.setText(cr.designName);
                return;
            }
            ++n2;
        }
    }

    public void dialogDesignAdded(IDesignDocument designDocument, IDesign dialogDesign) {
        RenderedModel dialogModel = new RenderedModel(dialogDesign);
        dialogModel.setUndoSystem(this);
        CanvasRecord dialogRecord = new CanvasRecord(dialogModel);
        dialogModel.setUndoContext(dialogRecord.undoContext);
        this.designs.add(dialogRecord);
        CTabItem canvasTab = new CTabItem(this.canvasTabs, 0);
        canvasTab.setText(dialogModel.getUIModel().getName());
        canvasTab.setControl(dialogRecord.createControls((Composite)this.canvasTabs));
        canvasTab.setData((Object)dialogRecord);
        this.canvasTabs.layout(true, true);
    }

    public void dialogDesignRemoved(IDesignDocument designDocument, String dialogId) {
        block0: for (CanvasRecord cr : this.designs) {
            if (!cr.renderedCanvas.getUIModel().getDesignId().equals(dialogId)) continue;
            this.designs.remove(cr);
            CTabItem[] cTabItemArray = this.canvasTabs.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (item.getData() == cr) {
                    item.dispose();
                    break block0;
                }
                ++n2;
            }
            break block0;
        }
        this.canvasTabs.layout(true, true);
    }

    @Override
    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    @Override
    public void disableUndo() {
        BitbucketUndoContext context = new BitbucketUndoContext();
        this.undoActionHandler.setContext((IUndoContext)context);
        this.redoActionHandler.setContext((IUndoContext)context);
    }

    @Override
    public void enableUndo() {
        this.setCurrentCanvas(this.currentCanvas);
    }

    public class BitbucketUndoContext
    implements IUndoContext {
        public String getLabel() {
            return "BitBucket";
        }

        public boolean matches(IUndoContext context) {
            return false;
        }
    }

    private class CanvasRecord
    implements RenderedModelListener {
        RenderedModel renderedCanvas;
        CanvasFrame canvasFrame;
        Composite canvasFrameComp;
        Canvas canvas;
        BasicController controller;
        ScrolledComposite sc;
        String designName = null;
        IUndoContext undoContext = new CanvasUndoContext();

        public CanvasRecord(RenderedModel renderedCanvas) {
            this.renderedCanvas = renderedCanvas;
            this.designName = renderedCanvas.getUIModel().getName();
            renderedCanvas.addListener(this);
            this.controller = new BasicController(renderedCanvas);
            this.controller.setResourceMap(ApplicationEditor.this.resourceMap);
            this.controller.setContainer((IAdaptable)ApplicationEditor.this);
            this.canvasFrame = ThemeManager.getDefault().getDefaultTheme().createCanvasFrame(renderedCanvas.getUIModel());
        }

        public Control createControls(Composite parent) {
            this.sc = new ScrolledComposite(parent, 768);
            this.sc.getVerticalBar().setIncrement(30);
            this.sc.getVerticalBar().setPageIncrement(275);
            this.sc.getHorizontalBar().setIncrement(30);
            this.sc.getHorizontalBar().setPageIncrement(275);
            this.canvasFrameComp = new Composite((Composite)this.sc, 0x20040000);
            this.sc.setContent((Control)this.canvasFrameComp);
            this.canvasFrameComp.setLayout((Layout)new FormLayout());
            this.canvasFrameComp.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    CanvasRecord.this.canvasFrame.setBounds(CanvasRecord.this.canvasFrameComp.getBounds());
                }
            });
            this.canvasFrameComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    HashMap resourceMap = new HashMap();
                    CanvasRecord.this.canvasFrame.renderFrame(e.gc, 0, 0, resourceMap);
                }
            });
            int canvasWidth = this.renderedCanvas.getUIModel().getWidth();
            int canvasHeight = this.renderedCanvas.getUIModel().getHeight();
            this.sc.setMinSize(canvasWidth + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, canvasHeight + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
            this.sc.setExpandVertical(true);
            this.sc.setExpandHorizontal(true);
            this.canvas = new Canvas(this.canvasFrameComp, 0x20000000);
            Font nameFont = new Font((Device)this.canvas.getDisplay(), "sans", 9, 0);
            this.canvas.setFont(nameFont);
            this.canvas.setBackground(parent.getDisplay().getSystemColor(1));
            FormData fd = new FormData();
            fd.left = new FormAttachment(50, -1 * canvasWidth / 2);
            fd.top = new FormAttachment(50, -1 * canvasHeight / 2);
            fd.right = new FormAttachment(50, canvasWidth / 2);
            fd.bottom = new FormAttachment(50, canvasHeight / 2);
            this.canvas.setLayoutData((Object)fd);
            this.controller.setControl((Control)this.canvas);
            this.canvas.addPaintListener((PaintListener)this.controller);
            this.canvas.addMouseListener((MouseListener)this.controller);
            this.canvas.addMouseMoveListener((MouseMoveListener)this.controller);
            this.canvas.addMouseTrackListener((MouseTrackListener)this.controller);
            this.canvas.addKeyListener((KeyListener)this.controller);
            this.controller.addListener(ApplicationEditor.this);
            this.hookContextMenu();
            return this.sc;
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    CanvasRecord.this.fillContextMenu(manager);
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)this.canvas);
            this.canvas.setMenu(menu);
        }

        private void fillContextMenu(IMenuManager manager) {
            this.controller.fillContextMenu(manager);
        }

        @Override
        public void renderedModelChanged(RenderedModel renderedCanvas) {
            if (!this.designName.equals(renderedCanvas.getUIModel().getName())) {
                this.designName = renderedCanvas.getUIModel().getName();
                ApplicationEditor.this.updateTab(this);
            }
            ApplicationEditor.this.dirty = true;
            ApplicationEditor.this.firePropertyChange(257);
        }

        @Override
        public void renderedModelFormatChanged(RenderedModel renderedCanvas) {
            int width = renderedCanvas.getUIModel().getWidth();
            int height = renderedCanvas.getUIModel().getHeight();
            this.sc.setMinSize(width + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, height + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
            FormData fd = new FormData();
            fd.left = new FormAttachment(50, -1 * width / 2);
            fd.top = new FormAttachment(50, -1 * height / 2);
            fd.right = new FormAttachment(50, width / 2);
            fd.bottom = new FormAttachment(50, height / 2);
            this.canvas.setLayoutData((Object)fd);
            this.sc.layout(true, true);
            this.canvasFrameComp.layout();
            ApplicationEditor.this.dirty = true;
            ApplicationEditor.this.firePropertyChange(257);
        }

        public void displayRegion(Rectangle rec) {
            int exc = rec.width / 2 + rec.x;
            int eyc = rec.height / 2 + rec.y;
            Rectangle clientArea = this.sc.getClientArea();
            int caxc = (clientArea.width - clientArea.x) / 2;
            int cayc = (clientArea.height - clientArea.y) / 2;
            int x = exc - caxc;
            int y = eyc - cayc;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.sc.setOrigin(x, y);
        }

        public class CanvasUndoContext
        implements IUndoContext {
            public String getId() {
                return CanvasRecord.this.renderedCanvas.getUIModel().getDocument().getUnderlyingFile() + CanvasRecord.this.renderedCanvas.getUIModel().getDesignId();
            }

            public String getLabel() {
                return CanvasRecord.this.renderedCanvas.getUIModel().getName();
            }

            public boolean matches(IUndoContext context) {
                if (context instanceof CanvasUndoContext) {
                    return this.getId().equals(((CanvasUndoContext)context).getId());
                }
                return false;
            }
        }
    }

    public class PasteOperation
    extends AbstractOperation {
        PartialDesignDocument pdd;
        CanvasRecord targetDesign;

        public PasteOperation(PartialDesignDocument pdd, CanvasRecord targetDesign) {
            super("Paste");
            this.pdd = null;
            this.targetDesign = null;
            this.pdd = pdd;
            this.targetDesign = targetDesign;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DesignDocument dd = (DesignDocument)ApplicationEditor.this.designDocument;
            IDesign design = this.targetDesign.renderedCanvas.getUIModel();
            boolean doit = true;
            if (!dd.canMergeAll(design, this.pdd)) {
                MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                confirmationDialog.setMessage("Not all elements can be used in the target canvas.  Would you like to paste the remaining elements?");
                int result = confirmationDialog.open();
                boolean bl = doit = result == 64;
            }
            if (doit) {
                dd.merge(design, this.pdd);
                this.pdd = this.pdd.clone();
            }
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("redoing paste operation");
            DesignDocument dd = (DesignDocument)ApplicationEditor.this.designDocument;
            IDesign design = this.targetDesign.renderedCanvas.getUIModel();
            dd.merge(design, this.pdd.clone(), false);
            this.targetDesign.renderedCanvas.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("undoing paste operation");
            this.targetDesign.renderedCanvas.getSelection().clear();
            DesignDocument dd = (DesignDocument)ApplicationEditor.this.designDocument;
            IDesign design = this.targetDesign.renderedCanvas.getUIModel();
            dd.reverse(design, this.pdd.clone());
            this.targetDesign.renderedCanvas.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

