/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ElementFrame;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.internal.PartialDesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.w3c.dom.Document;

public class SelectionStructure {
    private List<ComponentFrame> selectedItems = new LinkedList<ComponentFrame>();
    private List<ComponentFrame> secondarySelections = new LinkedList<ComponentFrame>();
    private List<ComponentFrame> tertiarySelections = new LinkedList<ComponentFrame>();
    private ComponentFrame primarySelection = null;
    private Rectangle selectionBounds = null;
    private RenderedModel renderedCanvas = null;
    private int moveOffsetX = 0;
    private int moveOffsetY = 0;
    private boolean moving = false;
    int bufferedXoffset = 0;
    int bufferedYoffset = 0;

    public SelectionStructure(RenderedModel renderedCanvas) {
        this.renderedCanvas = renderedCanvas;
    }

    public void clear() {
        this.secondarySelections.clear();
        this.tertiarySelections.clear();
        for (ComponentFrame componentFrame : this.selectedItems) {
            componentFrame.setSelected(false);
        }
        this.selectedItems.clear();
        this.primarySelection = null;
        this.selectionBounds = null;
    }

    public void startMove() {
        this.renderedCanvas.disableUndo();
        this.moving = true;
        this.moveOffsetX = 0;
        this.moveOffsetY = 0;
    }

    public void endMove() {
        this.renderedCanvas.enableUndo();
        if (this.moving) {
            this.moving = false;
            try {
                IDesignDocument designDocument = this.renderedCanvas.getUIModel().getDocument();
                Document document = this.renderedCanvas.getSelectionDocument(true);
                PartialDesignDocument pdd = new PartialDesignDocument(designDocument, (Design)this.renderedCanvas.getUIModel(), document);
                MoveOperation delo = new MoveOperation(pdd, this.moveOffsetX, this.moveOffsetY);
                delo.addContext(this.renderedCanvas.getUndoContext());
                this.renderedCanvas.getOperationHistory().execute((IUndoableOperation)delo, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    SelectionResult select(ComponentFrame cof, boolean additive) {
        this.bufferedXoffset = 0;
        this.bufferedYoffset = 0;
        SelectionResult result = new SelectionResult();
        if (cof != null && cof instanceof ElementFrame) {
            result.setHit(true);
            if (!additive) {
                if (!this.selectedItems.contains(cof)) {
                    this.secondarySelections.clear();
                    this.tertiarySelections.clear();
                    for (ComponentFrame componentFrame : this.selectedItems) {
                        componentFrame.setSelected(false);
                    }
                    this.selectedItems.clear();
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                    this.addSecondaryAndTertiarySelections();
                    this.selectionBounds = null;
                    result.setSelectionChanged(true);
                    result.setPrimaryChanged(true);
                } else if (this.primarySelection != cof) {
                    result.setSelectionChanged(false);
                    result.setPrimaryChanged(true);
                    this.selectedItems.remove(cof);
                    this.selectedItems.add(0, cof);
                    this.primarySelection = cof;
                    this.selectionBounds = null;
                }
                return result;
            }
            this.secondarySelections.clear();
            this.tertiarySelections.clear();
            if (this.selectedItems.contains(cof)) {
                this.selectedItems.remove(cof);
                cof.setSelected(false);
                if (this.selectedItems.size() > 0) {
                    this.primarySelection = this.selectedItems.get(0);
                    this.addSecondaryAndTertiarySelections();
                } else {
                    this.primarySelection = null;
                }
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
                return result;
            }
            if (this.primarySelection != null && this.primarySelection instanceof ConnectorFrame) {
                this.primarySelection.setSelected(false);
                this.selectedItems.clear();
            }
            this.selectedItems.add(0, cof);
            this.primarySelection = cof;
            this.primarySelection.setSelected(true);
            this.addSecondaryAndTertiarySelections();
            this.selectionBounds = null;
            result.setSelectionChanged(true);
            result.setPrimaryChanged(true);
            return result;
        }
        if (cof != null && cof instanceof ConnectorFrame) {
            result.setHit(true);
            if (!additive) {
                if (this.primarySelection != cof) {
                    this.secondarySelections.clear();
                    this.tertiarySelections.clear();
                    for (ComponentFrame componentFrame : this.selectedItems) {
                        componentFrame.setSelected(false);
                    }
                    this.selectedItems.clear();
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                    this.selectionBounds = null;
                    result.setSelectionChanged(true);
                    result.setPrimaryChanged(true);
                } else {
                    result.setSelectionChanged(false);
                    result.setPrimaryChanged(false);
                }
            } else {
                this.secondarySelections.clear();
                this.tertiarySelections.clear();
                this.selectedItems.clear();
                if (this.primarySelection == cof) {
                    cof.setSelected(false);
                    this.primarySelection = null;
                } else {
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                }
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
            }
            return result;
        }
        if (cof == null && !additive) {
            if (this.primarySelection != null) {
                this.secondarySelections.clear();
                this.tertiarySelections.clear();
                for (ComponentFrame componentFrame : this.selectedItems) {
                    componentFrame.setSelected(false);
                }
                this.selectedItems.clear();
                this.primarySelection = null;
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
            }
        } else {
            result.setSelectionChanged(false);
            result.setPrimaryChanged(false);
        }
        return result;
    }

    void select(List<ElementFrame> selectionList, boolean additive) {
        this.bufferedXoffset = 0;
        this.bufferedYoffset = 0;
        this.secondarySelections.clear();
        this.tertiarySelections.clear();
        if (!additive) {
            for (ComponentFrame componentFrame : this.selectedItems) {
                componentFrame.setSelected(false);
            }
            this.selectedItems.clear();
        }
        for (ElementFrame ef : selectionList) {
            this.selectedItems.remove(ef);
            this.selectedItems.add(0, (ComponentFrame)ef);
            ef.setSelected(true);
            this.primarySelection = ef;
            this.selectionBounds = null;
        }
        if (this.primarySelection != null) {
            this.addSecondaryAndTertiarySelections();
        }
    }

    public void validateSelection() {
        this.selectionBounds = null;
        if (this.primarySelection instanceof ElementFrame) {
            this.secondarySelections.clear();
            this.tertiarySelections.clear();
            this.addSecondaryAndTertiarySelections();
        }
    }

    private void addSecondaryAndTertiarySelections() {
        for (ConnectorFrame cf : this.renderedCanvas.getConnectorFrames()) {
            ElementFrame originFrame = null;
            ElementFrame destinationFrame = null;
            for (ComponentFrame componentFrame : this.selectedItems) {
                ElementFrame ef = (ElementFrame)componentFrame;
                if (cf.getDesignConnector().getOrigin() == ef.getDesignElement()) {
                    originFrame = ef;
                }
                if (cf.getDesignConnector().getDestination() == ef.getDesignElement()) {
                    destinationFrame = ef;
                }
                if (originFrame != null && destinationFrame != null) break;
            }
            if (originFrame != null && destinationFrame != null) {
                this.secondarySelections.add((ComponentFrame)cf);
                continue;
            }
            if (originFrame == null && destinationFrame == null) continue;
            this.tertiarySelections.add((ComponentFrame)cf);
        }
    }

    public Rectangle getBounds() {
        if (this.selectionBounds == null) {
            for (ComponentFrame componentFrame : this.selectedItems) {
                if (this.selectionBounds == null) {
                    this.selectionBounds = componentFrame.getBounds();
                    continue;
                }
                this.selectionBounds.add(componentFrame.getBounds());
            }
            for (ComponentFrame componentFrame : this.secondarySelections) {
                this.selectionBounds.add(componentFrame.getBounds());
            }
        }
        return this.selectionBounds == null ? null : new Rectangle(this.selectionBounds.x, this.selectionBounds.y, this.selectionBounds.width, this.selectionBounds.height);
    }

    public Rectangle getTertiaryBounds() {
        Rectangle sb = this.getBounds();
        if (sb == null) {
            return null;
        }
        Rectangle rect = new Rectangle(sb.x, sb.y, sb.width, sb.height);
        for (ComponentFrame componentFrame : this.tertiarySelections) {
            rect.add(componentFrame.getBounds());
        }
        return rect;
    }

    public void alignEdge(int edge) {
        if (this.primarySelection instanceof ElementFrame) {
            Rectangle r = this.primarySelection.getBounds();
            int xy = 0;
            if (edge == 16384) {
                xy = r.x;
            } else if (edge == 128) {
                xy = r.y;
            } else if (edge == 131072) {
                xy = r.x + r.width;
            } else if (edge == 1024) {
                xy = r.y + r.height;
            } else {
                return;
            }
            try {
                AlignEdgeOperation delo = new AlignEdgeOperation(edge, xy);
                delo.addContext(this.renderedCanvas.getUndoContext());
                this.renderedCanvas.getOperationHistory().execute((IUndoableOperation)delo, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void alignCenter(int orientation) {
        if (this.primarySelection instanceof ElementFrame) {
            Point p = ((ElementFrame)this.primarySelection).getDesignElement().getCenterPoint();
            try {
                AlignCenterOperation delo = new AlignCenterOperation(orientation, p);
                delo.addContext(this.renderedCanvas.getUndoContext());
                this.renderedCanvas.getOperationHistory().execute((IUndoableOperation)delo, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void adjustPosition(int xoffset, int yoffset) {
        Rectangle rect = this.getBounds();
        if (xoffset < 0) {
            if (rect.x + xoffset < 0) {
                this.bufferedXoffset += xoffset + rect.x;
                xoffset = rect.x * -1;
            } else {
                this.bufferedXoffset += xoffset;
                if (this.bufferedXoffset < 0) {
                    xoffset = this.bufferedXoffset;
                    this.bufferedXoffset = 0;
                } else {
                    xoffset = 0;
                }
            }
        } else if (xoffset > 0) {
            if (rect.x + rect.width + xoffset > this.renderedCanvas.getUIModel().getWidth()) {
                this.bufferedXoffset += xoffset - (this.renderedCanvas.getUIModel().getWidth() - (rect.x + rect.width));
                xoffset = this.renderedCanvas.getUIModel().getWidth() - (rect.x + rect.width);
            } else {
                this.bufferedXoffset += xoffset;
                if (this.bufferedXoffset > 0) {
                    xoffset = this.bufferedXoffset;
                    this.bufferedXoffset = 0;
                } else {
                    xoffset = 0;
                }
            }
        }
        if (yoffset < 0) {
            if (rect.y + yoffset < 0) {
                this.bufferedYoffset += yoffset + rect.y;
                yoffset = rect.y * -1;
            } else {
                this.bufferedYoffset += yoffset;
                if (this.bufferedYoffset < 0) {
                    yoffset = this.bufferedYoffset;
                    this.bufferedYoffset = 0;
                } else {
                    yoffset = 0;
                }
            }
        } else if (yoffset > 0) {
            if (rect.y + rect.height + yoffset > this.renderedCanvas.getUIModel().getHeight()) {
                this.bufferedYoffset += yoffset - (this.renderedCanvas.getUIModel().getHeight() - (rect.y + rect.height));
                yoffset = this.renderedCanvas.getUIModel().getHeight() - (rect.y + rect.height);
            } else {
                this.bufferedYoffset += yoffset;
                if (this.bufferedYoffset > 0) {
                    yoffset = this.bufferedYoffset;
                    this.bufferedYoffset = 0;
                } else {
                    yoffset = 0;
                }
            }
        }
        this.moveOffsetX += xoffset;
        this.moveOffsetY += yoffset;
        for (ComponentFrame componentFrame : this.selectedItems) {
            componentFrame.adjustPosition(xoffset, yoffset);
        }
        for (ComponentFrame componentFrame : this.secondarySelections) {
            componentFrame.adjustPosition(xoffset, yoffset);
        }
        if (this.primarySelection instanceof ElementFrame) {
            this.selectionBounds.x += xoffset;
            this.selectionBounds.y += yoffset;
        } else {
            this.selectionBounds = null;
        }
    }

    public ComponentFrame getPrimarySelection() {
        return this.primarySelection;
    }

    public List<ComponentFrame> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }

    public List<ComponentFrame> getSecondarySelectedItems() {
        return Collections.unmodifiableList(this.secondarySelections);
    }

    public List<ComponentFrame> getTertiarySelectedItems() {
        return Collections.unmodifiableList(this.tertiarySelections);
    }

    public class AlignCenterOperation
    extends AbstractOperation {
        int orientation;
        Point p;
        PartialDesignDocument pdd;

        public AlignCenterOperation(int orientation, Point p) {
            super("Align Centers");
            this.orientation = 512;
            this.p = null;
            this.pdd = null;
            this.orientation = orientation;
            this.p = p;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            int xy = 0;
            if (this.orientation == 256) {
                xy = this.p.y;
            } else if (this.orientation == 512) {
                xy = this.p.x;
            } else {
                return Status.CANCEL_STATUS;
            }
            IDesignDocument designDocument = SelectionStructure.this.renderedCanvas.getUIModel().getDocument();
            Document document = SelectionStructure.this.renderedCanvas.getSelectionDocument(true);
            this.pdd = new PartialDesignDocument(designDocument, (Design)SelectionStructure.this.renderedCanvas.getUIModel(), document);
            for (ComponentFrame componentFrame : SelectionStructure.this.selectedItems) {
                ((ElementFrame)componentFrame).alignCenter(this.orientation, xy);
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            int xy = 0;
            if (this.orientation == 256) {
                xy = this.p.y;
            } else if (this.orientation == 512) {
                xy = this.p.x;
            }
            block0: for (IDesignElement designElement : this.pdd.getMainDesign().getDesignElements()) {
                for (ComponentFrame componentFrame : SelectionStructure.this.renderedCanvas.getElementFrames()) {
                    if (!componentFrame.getDesignComponent().getId().equals(designElement.getId())) continue;
                    ((ElementFrame)componentFrame).alignCenter(this.orientation, xy);
                    continue block0;
                }
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            block0: for (IDesignElement designElement : this.pdd.getMainDesign().getDesignElements()) {
                int xy = 0;
                if (this.orientation == 256) {
                    xy = designElement.getCenterPoint().y;
                } else if (this.orientation == 512) {
                    xy = designElement.getCenterPoint().x;
                }
                for (ComponentFrame componentFrame : SelectionStructure.this.renderedCanvas.getElementFrames()) {
                    if (!componentFrame.getDesignComponent().getId().equals(designElement.getId())) continue;
                    ((ElementFrame)componentFrame).alignCenter(this.orientation, xy);
                    continue block0;
                }
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    public class AlignEdgeOperation
    extends AbstractOperation {
        int edge;
        int xy;
        PartialDesignDocument pdd;
        Map<String, Point> locationOffsets;

        public AlignEdgeOperation(int edge, int xy) {
            super("Align Edge");
            this.pdd = null;
            this.locationOffsets = new HashMap<String, Point>();
            this.edge = edge;
            this.xy = xy;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IDesignDocument designDocument = SelectionStructure.this.renderedCanvas.getUIModel().getDocument();
            Document document = SelectionStructure.this.renderedCanvas.getSelectionDocument(true);
            this.pdd = new PartialDesignDocument(designDocument, (Design)SelectionStructure.this.renderedCanvas.getUIModel(), document);
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            for (ComponentFrame componentFrame : SelectionStructure.this.selectedItems) {
                ElementFrame ef = (ElementFrame)componentFrame;
                Point p = new Point(ef.getDesignElement().getCenterPoint().x, ef.getDesignElement().getCenterPoint().y);
                ef.alignEdge(this.edge, this.xy);
                Point newLocation = ef.getDesignElement().getCenterPoint();
                p.x = newLocation.x - p.x;
                p.y = newLocation.y - p.y;
                this.locationOffsets.put(ef.getDesignElement().getId(), p);
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            SelectionStructure.this.renderedCanvas.selectPartialDocument(this.pdd);
            for (ComponentFrame componentFrame : SelectionStructure.this.selectedItems) {
                ElementFrame ef = (ElementFrame)componentFrame;
                ef.alignEdge(this.edge, this.xy);
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            SelectionStructure.this.renderedCanvas.selectPartialDocument(this.pdd);
            for (ComponentFrame componentFrame : SelectionStructure.this.selectedItems) {
                ElementFrame ef = (ElementFrame)componentFrame;
                Point offsets = this.locationOffsets.get(ef.getDesignElement().getId());
                if (offsets == null) continue;
                ef.adjustPosition(offsets.x * -1, offsets.y * -1);
            }
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    public class MoveOperation
    extends AbstractOperation {
        PartialDesignDocument pdd;
        int xOffset;
        int yOffset;

        public MoveOperation(PartialDesignDocument pdd, int xOffset, int yOffset) {
            super("Move");
            this.pdd = null;
            this.xOffset = 0;
            this.yOffset = 0;
            this.pdd = pdd;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            SelectionStructure.this.renderedCanvas.selectPartialDocument(this.pdd);
            SelectionStructure.this.adjustPosition(this.xOffset, this.yOffset);
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            SelectionStructure.this.renderedCanvas.startBatchUpdate();
            SelectionStructure.this.renderedCanvas.selectPartialDocument(this.pdd);
            SelectionStructure.this.adjustPosition(this.xOffset * -1, this.yOffset * -1);
            SelectionStructure.this.renderedCanvas.endBatchUpdate();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

