/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.attraction;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.core.util.Geom;
import org.eclipse.vtp.desktop.editors.themes.attraction.AttractionComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ElementFrame;
import org.eclipse.vtp.desktop.editors.themes.core.commands.Command;
import org.eclipse.vtp.desktop.editors.themes.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.themes.core.commands.StartMove;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponentListener;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnectorLabel;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnectorMidpoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;

public class AttractionConnectorFrame
extends AttractionComponentFrame
implements ConnectorFrame {
    private IDesignConnector uiConnector;
    private boolean selected = false;
    private Point labelUpperLeft;
    private Point labelLowerRight;
    private Object dragTarget = null;
    ElementFrame source;
    ElementFrame destination;
    Point labelSize = null;

    public AttractionConnectorFrame(ElementFrame source, ElementFrame destination, IDesignConnector uiConnector) {
        super((IDesignComponent)uiConnector);
        this.source = source;
        this.destination = destination;
        this.uiConnector = uiConnector;
        uiConnector.addListener((IDesignComponentListener)this);
        uiConnector.addPropertyListener((PropertyChangeListener)this);
    }

    public IDesignConnector getDesignConnector() {
        return this.uiConnector;
    }

    public void adjustPosition(int xoffset, int yoffset) {
        block3: {
            block1: {
                block2: {
                    if (this.dragTarget == null) break block1;
                    if (!(this.dragTarget instanceof IDesignConnectorMidpoint)) break block2;
                    ((IDesignConnectorMidpoint)this.dragTarget).adjustPosition(xoffset, yoffset);
                    break block3;
                }
                if (!(this.dragTarget instanceof IDesignConnectorLabel)) break block3;
                IDesignConnectorLabel lineLabel = (IDesignConnectorLabel)this.dragTarget;
                lineLabel.adjustPosition(xoffset, yoffset);
                break block3;
            }
            List midPoints = this.uiConnector.getMidpoints();
            for (IDesignConnectorMidpoint midPoint : midPoints) {
                midPoint.adjustPosition(xoffset, yoffset);
            }
        }
        this.fireChange();
    }

    public Rectangle getBounds() {
        if (this.labelUpperLeft == null) {
            return null;
        }
        Rectangle ret = new Rectangle(this.labelUpperLeft.x, this.labelUpperLeft.y, this.labelLowerRight.x - this.labelUpperLeft.x + 1, this.labelLowerRight.y - this.labelUpperLeft.y + 1);
        Point[] ps = this.uiConnector.getPoints();
        int i = 0;
        while (i < ps.length - 1) {
            ret.add(new Rectangle(Math.min(ps[i].x, ps[i + 1].x) - 10, Math.min(ps[i].y, ps[i + 1].y) - 10, Math.abs(ps[i + 1].x - ps[i].x) + 20, Math.abs(ps[i + 1].y - ps[i].y) + 20));
            ++i;
        }
        return ret;
    }

    @Override
    public void mouseDoubleClick(CommandListener commandListener, int x, int y, int modifiers) {
        super.mouseDoubleClick(commandListener, x, y, modifiers);
    }

    public void mouseDown(CommandListener commandListener, int x, int y, int modifiers) {
        Rectangle labelRect = new Rectangle(this.labelUpperLeft.x, this.labelUpperLeft.y, this.labelLowerRight.x - this.labelUpperLeft.x, this.labelLowerRight.y - this.labelUpperLeft.y);
        if (labelRect.contains(x, y)) {
            this.dragTarget = this.uiConnector.getConnectorLabel();
            commandListener.executeCommand((Command)new StartMove());
        } else {
            List midPoints = this.uiConnector.getMidpoints();
            for (IDesignConnectorMidpoint midPoint : midPoints) {
                Point midPointCenter = midPoint.getPosition();
                if (!new Rectangle(midPointCenter.x - 4, midPointCenter.y - 4, 8, 8).contains(x, y)) continue;
                this.dragTarget = midPoint;
                commandListener.executeCommand((Command)new StartMove());
                break;
            }
        }
    }

    public void mouseMove(CommandListener commandListener, int x, int y, int modifiers) {
    }

    public void mouseUp(CommandListener commandListener, int x, int y, int modifiers) {
    }

    public Point getLineSegmentCenterPoint(int idex) {
        Point[] points = this.uiConnector.getPoints();
        Point p1 = points[idex];
        Point p2 = points[idex + 1];
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    @Override
    public void renderFrame(GC gc, int renderingPhase, int options, Map<String, Object> resourceMap) {
        Font labelFont = this.getFont(gc, resourceMap, "attaction.linelabel.font", "Arial", 9, 0);
        Color labelExitColor = this.getColor(gc, resourceMap, "attraction.linelabel.exit.color", 0, 0, 0);
        Color labelErrorColor = this.getColor(gc, resourceMap, "attraction.linelabel.error.color", 255, 0, 0);
        Color lineColor = this.getColor(gc, resourceMap, "attraction.line.color", 0, 0, 0);
        Color lineBendColor = this.getColor(gc, resourceMap, "attraction.line.color", 0, 0, 0);
        Color selectionColor = this.getColor(gc, resourceMap, "attraction.selection.color", 0, 0, 255);
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        Font originalFont = gc.getFont();
        Point[] ps = this.uiConnector.getPoints();
        if (ps[0] != null) {
            if (this.selected) {
                gc.setForeground(selectionColor);
            } else {
                gc.setForeground(lineColor);
            }
            int i = 0;
            while (i < ps.length - 2) {
                if (ps[i] != null && ps[i + 1] != null) {
                    gc.drawLine(ps[i].x, ps[i].y, ps[i + 1].x, ps[i + 1].y);
                }
                ++i;
            }
            if (ps[ps.length - 1] != null) {
                Point oi = ps[ps.length - 2];
                Point incursion = this.destination.getIncursionPoint(oi.x, oi.y);
                if (incursion != null) {
                    double rise1 = incursion.y - oi.y;
                    double run1 = incursion.x - oi.x;
                    double dist = Math.sqrt(Math.pow(rise1, 2.0) + Math.pow(run1, 2.0));
                    double line1Xnorm = run1 / dist;
                    double line1Ynorm = rise1 / dist;
                    double perpX = (double)incursion.x + -12.0 * line1Xnorm;
                    double perpY = (double)incursion.y + -12.0 * line1Ynorm;
                    double a1x = perpX + -6.0 * line1Ynorm;
                    double a1y = perpY + 6.0 * line1Xnorm;
                    double a2x = perpX + 6.0 * line1Ynorm;
                    double a2y = perpY + -6.0 * line1Xnorm;
                    gc.drawLine(oi.x, oi.y, incursion.x, incursion.y);
                    int[] triangle = new int[]{incursion.x, incursion.y, (int)a1x, (int)a1y, (int)a2x, (int)a2y};
                    gc.fillPolygon(triangle);
                    gc.drawPolygon(triangle);
                }
            }
            if (this.selected) {
                i = 0;
                while (i < ps.length - 1) {
                    if (ps[i] != null && ps[i + 1] != null && i != 0) {
                        gc.setBackground(lineBendColor);
                        gc.fillRectangle(ps[i].x - 4, ps[i].y - 4, 8, 8);
                    }
                    ++i;
                }
            }
            gc.setFont(labelFont);
            int nw = 0;
            int nh = 0;
            for (IDesignElementConnectionPoint cr : this.uiConnector.getConnectionPoints()) {
                Point np = gc.stringExtent(cr.getName());
                nw = Math.max(nw, np.x);
                nh = nh + 2 + np.y;
            }
            Point labelSegmentCenterPoint = this.getLineSegmentCenterPoint(this.uiConnector.getConnectorLabel().getAnchorSegment());
            Point labelOffset = this.uiConnector.getConnectorLabel().getOffsetPosition();
            Point labelCenterPoint = new Point(labelSegmentCenterPoint.x + labelOffset.x, labelSegmentCenterPoint.y + labelOffset.y);
            this.labelUpperLeft = new Point(labelCenterPoint.x - (nw / 2 + 2), labelCenterPoint.y - ((nh -= 2) / 2 + 2));
            this.labelLowerRight = new Point(labelCenterPoint.x + (nw / 2 + 2), labelCenterPoint.y + (nh / 2 + 2));
            int ry = this.labelUpperLeft.y + 1;
            for (IDesignElementConnectionPoint cr : this.uiConnector.getConnectionPoints()) {
                if (cr.getType() == IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT) {
                    gc.setForeground(labelErrorColor);
                } else {
                    gc.setForeground(labelExitColor);
                }
                Point np = gc.stringExtent(cr.getName());
                gc.drawString(cr.getName(), this.labelUpperLeft.x + 2, ry, true);
                ry += np.y;
                ry += 2;
            }
            gc.setForeground(foreground);
            gc.setBackground(background);
            gc.setFont(originalFont);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.dragTarget = null;
    }

    public boolean touchesComponent(int x, int y) {
        boolean ret = false;
        ret = new Rectangle(this.labelUpperLeft.x, this.labelUpperLeft.y, this.labelLowerRight.x - this.labelUpperLeft.x + 1, this.labelLowerRight.y - this.labelUpperLeft.y + 1).contains(x, y);
        if (!ret) {
            Point[] ps = this.uiConnector.getPoints();
            int i = 0;
            while (i < ps.length - 1) {
                if (x >= Math.min(ps[i].x, ps[i + 1].x) - 5 && x <= Math.max(ps[i].x, ps[i + 1].x) + 5 && y >= Math.min(ps[i].y, ps[i + 1].y) - 5 && y <= Math.max(ps[i].y, ps[i + 1].y) + 5) {
                    ret = ps[i].x == ps[i + 1].x ? (ret |= Math.abs(x - ps[i].x) < 5) : (ps[i].y == ps[i + 1].y ? (ret |= Math.abs(y - ps[i].y) < 5) : (ret |= Geom.DistancePointLine((Geom.Point3D)Geom.newPoint3D((float)x, (float)y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i].x, (float)ps[i].y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i + 1].x, (float)ps[i + 1].y, (float)0.0f)) < 5.0f));
                    if (ret) break;
                }
                ++i;
            }
        }
        return ret;
    }

    public void initializeGraphics(GC gc, Map<String, Object> resourceMap) {
    }

    public void toggleMidPoint(int x, int y) {
        float oldDistance = Float.MAX_VALUE;
        Point[] ps = this.uiConnector.getPoints();
        int i = 0;
        while (i < ps.length) {
            Rectangle midPointRect = new Rectangle(ps[i].x - 5, ps[i].y - 5, 10, 10);
            if (midPointRect.contains(x, y)) {
                this.uiConnector.removeMidpoint(i);
                return;
            }
            ++i;
        }
        int index = ps.length - 1;
        int i2 = 0;
        while (i2 < ps.length - 1) {
            if (x >= Math.min(ps[i2].x, ps[i2 + 1].x) - 5 && x <= Math.max(ps[i2].x, ps[i2 + 1].x) + 5 && y >= Math.min(ps[i2].y, ps[i2 + 1].y) - 5 && y <= Math.max(ps[i2].y, ps[i2 + 1].y) + 5) {
                float distance = Geom.DistancePointLine((Geom.Point3D)Geom.newPoint3D((float)x, (float)y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i2].x, (float)ps[i2].y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i2 + 1].x, (float)ps[i2 + 1].y, (float)0.0f));
                if (distance < oldDistance) {
                    index = i2 + 1;
                }
                oldDistance = distance;
            }
            ++i2;
        }
        this.uiConnector.insertMidpoint(index, x, y);
    }
}

