/*--------------------------------------------------------------------------
 * Copyright (c) 2004, 2006-2007 OpenMethods, LLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Trip Gilman (OpenMethods), Lonnie G. Pryor (OpenMethods)
 *    - initial API and implementation
 -------------------------------------------------------------------------*/
package org.eclipse.vtp.desktop.editors.themes.core;

/**
 * Listener interface for the events that can be generated by component frames.
 * 
 * @author trip
 */
public interface ComponentFrameListener
{
	/**
	 * Indicates that the given component frame is graphically dirty and should
	 * be repainted.
	 * 
	 * @param componentFrame The component frame that needs repainting
	 */
	public void componentFrameRepaintRequested(ComponentFrame componentFrame);
	
	/**
	 * Indicates that some aspect of the given component frame has been modified.
	 * 
	 * @param componentFrame The component frame that was modified
	 */
	public void componentFrameChanged(ComponentFrame componentFrame);
	
	/**
	 * Indicates that the given component frame has been removed from its parent
	 * design.
	 * 
	 * @param componentFrame The component frame that has been removed
	 */
	public void componentFrameDeleted(ComponentFrame componentFrame);
}
