/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vtp.desktop.editors.themes.core.Activator;
import org.eclipse.vtp.desktop.editors.themes.core.Theme;
import org.osgi.framework.Bundle;

public class ThemeManager {
    public static String themeExtensionPointId = "org.eclipse.vtp.desktop.editors.themes.core.editorTheme";
    private static ThemeManager instance = new ThemeManager();
    private Map<String, Theme> themes = new HashMap<String, Theme>();

    public static ThemeManager getDefault() {
        return instance;
    }

    public ThemeManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(themeExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class providerClass = contributor.loadClass(className);
                this.themes.put(id, (Theme)providerClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public List<Theme> getInstalledThemes() {
        LinkedList<Theme> ret = new LinkedList<Theme>();
        ret.addAll(this.themes.values());
        return ret;
    }

    public Theme getDefaultTheme() {
        return this.themes.get("org.eclipse.vtp.desktop.editors.themes.attraction");
    }

    public Theme getCurrentTheme() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String themeId = store.getString("CurrentTheme");
        Theme theme = this.themes.get(themeId);
        if (theme == null) {
            theme = this.getDefaultTheme();
        }
        return theme;
    }
}

