/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.editor;

import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.editors.voice.editor.VoiceContentDialog;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceModel;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.ContentComposite;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.ReferencedContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public class SharedContentPage
extends LabelProvider
implements IStructuredContentProvider,
ITableLabelProvider,
IDoubleClickListener,
ISelectionChangedListener,
SelectionListener {
    private VoiceModel model = null;
    private TableViewer sharedContentTable = null;
    private Button addSharedContentButton = null;
    private Button editSharedContentButton = null;
    private Button removeSharedContentButton = null;

    public Control initialize(Composite parent, VoiceModel model) {
        this.model = model;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        Table table = new Table(composite, 2818);
        table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setWidth(100);
        valueColumn.setText("Value");
        table.pack();
        this.sharedContentTable = new TableViewer(table);
        this.sharedContentTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.sharedContentTable.addDoubleClickListener((IDoubleClickListener)this);
        this.sharedContentTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.sharedContentTable.setLabelProvider((IBaseLabelProvider)this);
        this.sharedContentTable.setContentProvider((IContentProvider)this);
        this.sharedContentTable.setInput((Object)model);
        this.sharedContentTable.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    SharedContentPage.this.removeSharedContent();
                }
            }
        });
        this.addSharedContentButton = new Button(composite, 8);
        this.addSharedContentButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addSharedContentButton.setText("Add Shared Content");
        this.addSharedContentButton.addSelectionListener((SelectionListener)this);
        this.editSharedContentButton = new Button(composite, 8);
        this.editSharedContentButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.editSharedContentButton.setText("Edit Shared Content");
        this.editSharedContentButton.setEnabled(false);
        this.editSharedContentButton.addSelectionListener((SelectionListener)this);
        this.removeSharedContentButton = new Button(composite, 8);
        this.removeSharedContentButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeSharedContentButton.setText("Remove Shared Content");
        this.removeSharedContentButton.setEnabled(false);
        this.removeSharedContentButton.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void addSharedContent() {
        VoiceContentDialog dialog = new VoiceContentDialog(this.sharedContentTable.getControl().getShell());
        dialog.initialize(null, this.model.getSharedContentNames(), null, InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaProject(this.model.getProject()).getMediaProvider());
        if (dialog.open() != 0) {
            return;
        }
        this.model.putSharedContent(dialog.getItemName(), dialog.getContentItem());
        this.sharedContentTable.refresh();
    }

    private void editSharedContent() {
        IStructuredSelection selection = (IStructuredSelection)this.sharedContentTable.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String itemName = (String)selection.getFirstElement();
        VoiceContentDialog dialog = new VoiceContentDialog(this.sharedContentTable.getControl().getShell());
        dialog.initialize(itemName, this.model.getSharedContentNames(), this.model.getSharedContent(itemName), InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaProject(this.model.getProject()).getMediaProvider());
        if (dialog.open() != 0) {
            return;
        }
        if (!itemName.equals(dialog.getItemName())) {
            this.model.removeSharedContent(itemName);
        }
        this.model.putSharedContent(dialog.getItemName(), dialog.getContentItem());
        this.sharedContentTable.refresh();
    }

    private void removeSharedContent() {
        IStructuredSelection selection = (IStructuredSelection)this.sharedContentTable.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1 ? !MessageDialog.openConfirm((Shell)this.sharedContentTable.getControl().getShell(), (String)"Remove Item", (String)("Are you sure you want to remove the item \"" + selection.getFirstElement() + "\" and its content?")) : !MessageDialog.openConfirm((Shell)this.sharedContentTable.getControl().getShell(), (String)"Remove Item", (String)("Are you sure you want to remove the " + selection.size() + " selected items and their content?"))) {
            return;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            this.model.removeSharedContent((String)i.next());
        }
        this.sharedContentTable.refresh();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.model.getSharedContentNames();
    }

    public void dispose() {
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return (String)element;
        }
        if (columnIndex == 1) {
            StringBuffer buf = new StringBuffer();
            Content content = this.model.getSharedContent((String)element);
            if (content instanceof FormattableContent) {
                FormattableContent fc = (FormattableContent)content;
                buf.append(String.valueOf(fc.getContentTypeName()) + "(" + fc.getFormatName() + ", " + fc.getValue() + ")");
            } else if (content instanceof TextContent) {
                buf.append(((TextContent)content).getText());
            } else if (content instanceof ReferencedContent) {
                buf.append("REFERENCE(" + ((ReferencedContent)content).getReferencedName() + ")");
            } else if (content instanceof FileContent) {
                FileContent fc = (FileContent)content;
                buf.append(String.valueOf(fc.getFileTypeName()) + "(" + fc.getPath() + ")");
            } else if (content instanceof ContentComposite) {
                buf.append("COMPOSITE");
            }
            return buf.toString();
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.editSharedContent();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int size = 0;
        IStructuredSelection selection = (IStructuredSelection)this.sharedContentTable.getSelection();
        if (selection != null) {
            size = selection.size();
        }
        this.editSharedContentButton.setEnabled(size == 1);
        this.removeSharedContentButton.setEnabled(size > 0);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (this.addSharedContentButton == source) {
            this.addSharedContent();
        } else if (this.editSharedContentButton == source) {
            this.editSharedContent();
        } else if (this.removeSharedContentButton == source) {
            this.removeSharedContent();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

