/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IExportAgent;
import org.eclipse.vtp.desktop.export.internal.Activator;
import org.eclipse.vtp.desktop.export.internal.ExportAgent;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ExportCore {
    private static final IPreferencesService preferences = Platform.getPreferencesService();
    private static Map<String, IConfigurationExporter> exporters = new HashMap<String, IConfigurationExporter>();

    static {
        try {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.vtp.desktop.export.configurationExporters");
            int i = 0;
            while (i < extensions.length) {
                String id = extensions[i].getAttribute("id");
                Bundle contributor = Platform.getBundle((String)extensions[i].getContributor().getName());
                String className = extensions[i].getAttribute("class");
                try {
                    Class exporterClass = contributor.loadClass(className);
                    exporters.put(id, (IConfigurationExporter)exporterClass.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
    }

    public static String getSymbolicName() {
        return Activator.instance.getBundle().getSymbolicName();
    }

    public static Bundle[] getBundles() {
        return Activator.instance.context.getBundles();
    }

    public static void logError(String message, Throwable thrown) {
        System.err.println(message);
        thrown.printStackTrace(System.err);
    }

    public static void displayError(Shell shell, String message, Throwable thrown) {
        new ErrorDialog(shell, "Error Exporting Projects", message, (IStatus)new Status(4, ExportCore.getSymbolicName(), 1, message, thrown), 4).open();
    }

    public static Map<String, String> loadSettings(String archive, String project) {
        HashMap<String, String> settings = new HashMap<String, String>();
        Preferences rootNode = preferences.getRootNode().node("instance").node(ExportCore.getSymbolicName());
        Preferences archiveNode = rootNode.node(ExportCore.escapeKey(archive));
        Preferences projectNode = archiveNode.node(ExportCore.escapeKey(project));
        try {
            String[] stringArray = projectNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                settings.put(key, projectNode.get(key, ""));
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }

    public static void saveSettings(String archive, String project, Map<String, String> settings) {
        Preferences rootNode = preferences.getRootNode().node("instance").node(ExportCore.getSymbolicName());
        Preferences archiveNode = rootNode.node(ExportCore.escapeKey(archive));
        Preferences projectNode = archiveNode.node(ExportCore.escapeKey(project));
        try {
            projectNode.clear();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                projectNode.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getPreference(String key) {
        return preferences.getRootNode().node("instance").node(ExportCore.getSymbolicName()).get(ExportCore.escapeKey(key), null);
    }

    public static void setPreference(String key, String value) {
        preferences.getRootNode().node("instance").node(ExportCore.getSymbolicName()).put(ExportCore.escapeKey(key), value);
    }

    public static void flushPreferences() throws BackingStoreException {
        preferences.getRootNode().node("instance").node(ExportCore.getSymbolicName()).flush();
    }

    private static String escapeKey(String key) {
        StringBuilder sb = new StringBuilder(key);
        int i = sb.indexOf("\\");
        while (i >= 0) {
            sb.replace(i, i + 1, "\\\\");
            i = sb.indexOf("\\", i + 2);
        }
        i = sb.indexOf("/");
        while (i >= 0) {
            sb.replace(i, i + 1, "\\");
            i = sb.indexOf("/", i + 1);
        }
        return sb.toString();
    }

    public static List<ExportAgent> createExportAgents() {
        IExtension[] agents = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(ExportCore.getSymbolicName()) + ".exportAgents").getExtensions();
        int count = 0;
        Integer ZERO = 0;
        TreeMap<Integer, LinkedList<ExportAgent>> map = new TreeMap<Integer, LinkedList<ExportAgent>>();
        IExtension[] iExtensionArray = agents;
        int n = agents.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension agent = iExtensionArray[n2];
            Bundle contributor = Platform.getBundle((String)agent.getContributor().getName());
            IConfigurationElement[] iConfigurationElementArray = agent.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String id = element.getAttribute("id");
                try {
                    Integer ranking = ZERO;
                    String value = element.getAttribute("ranking");
                    if (value != null && value.length() > 0) {
                        ranking = Integer.parseInt(value);
                    }
                    String name = element.getAttribute("class");
                    IExportAgent object = (IExportAgent)contributor.loadClass(name).newInstance();
                    LinkedList<ExportAgent> list = (LinkedList<ExportAgent>)map.get(ranking);
                    if (list == null) {
                        list = new LinkedList<ExportAgent>();
                        map.put(ranking, list);
                    }
                    list.add(new ExportAgent(id, object));
                    ++count;
                }
                catch (Exception e) {
                    ExportCore.logError("Error loading export agent \"" + id + "\".", e);
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<ExportAgent> result = new ArrayList<ExportAgent>(count);
        for (List list : map.values()) {
            result.addAll(list);
        }
        return result;
    }

    public static IConfigurationExporter getConfigurationExporter(String elementTypeId) {
        return exporters.get(elementTypeId);
    }
}

