/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.vtp.desktop.export.IWorkflowExporter;
import org.eclipse.vtp.desktop.export.internal.Exporter;
import org.eclipse.vtp.desktop.export.internal.MediaExporter;
import org.eclipse.vtp.desktop.export.internal.ProjectExporter;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.framework.util.ConfigurationDictionary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class WorkflowExporter
extends ProjectExporter
implements IWorkflowExporter {
    private final String id;
    private final IWorkflowProject project;
    private final Map<String, MediaExporter> mediaDependencies = new HashMap<String, MediaExporter>();
    private final Set<WorkflowExporter> workflowDependencies = new HashSet<WorkflowExporter>();
    private final Map<String, List<String>> languageMapping = new HashMap<String, List<String>>();

    public WorkflowExporter(Exporter exporter, DocumentBuilder db, IWorkflowProject project) {
        this.project = project;
        String id = "";
        try {
            InputStream input = project.getUnderlyingProject().getFile(".buildPath").getContents();
            try {
                id = db.parse(input).getDocumentElement().getAttribute("id");
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = id;
        this.loadSettings(exporter);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public IWorkflowProject getWorkflowProject() {
        return this.project;
    }

    @Override
    public IProject getProject() {
        return this.project.getUnderlyingProject();
    }

    @Override
    public Collection<ConfigurationDictionary> getConfigurationDictionaries(String uniqueToken) {
        ConfigurationDictionary config = new ConfigurationDictionary("org.eclipse.vtp.framework.engine.http.deployments." + this.getProject().getName() + "." + uniqueToken, "org.eclipse.vtp.framework.engine.http.deployments");
        config.put((Object)"deployment.id", (Object)this.project.getName());
        config.put((Object)"definition.id", (Object)(String.valueOf(this.project.getName()) + "." + uniqueToken));
        config.put((Object)"resources", (Object)this.mediaDependencies.keySet().toArray(new String[this.mediaDependencies.size()]));
        config.put((Object)"path", (Object)("/" + this.project.getName()));
        config.put((Object)"fragment", (Object)"false");
        return Collections.singleton(config);
    }

    public Collection<MediaExporter> getMediaDependencies() {
        return Collections.unmodifiableCollection(this.mediaDependencies.values());
    }

    public Map<String, List<String>> getLanguageMapping() {
        return Collections.unmodifiableMap(this.languageMapping);
    }

    public Map<String, MediaExporter> getMediaDependencyMap() {
        return Collections.unmodifiableMap(this.mediaDependencies);
    }

    public Collection<WorkflowExporter> getWorkflowDependencies() {
        return new ArrayList<WorkflowExporter>(this.workflowDependencies);
    }

    public void resolveDependencies(SAXParser sp, Map<String, WorkflowExporter> workflowExporters, Map<String, MediaExporter> mediaExporters) {
        final HashSet linkedIds = new HashSet();
        DefaultHandler handler = new DefaultHandler(){
            boolean active = false;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                super.startElement(uri, localName, qName, attributes);
                if ("element".equals(qName) && "org.eclipse.vtp.desktop.model.elements.core.include".equals(attributes.getValue("type"))) {
                    this.active = true;
                } else if (this.active && "property".equals(qName) && "instanceId".equals(attributes.getValue("name"))) {
                    linkedIds.add(attributes.getValue("value"));
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                super.endElement(uri, localName, qName);
                if (this.active && "element".equals(qName)) {
                    this.active = false;
                }
            }
        };
        for (IDesignDocument doc : this.getDesignDocuments()) {
            try {
                InputStream input = doc.getUnderlyingFile().getContents();
                try {
                    sp.parse(input, handler);
                }
                finally {
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (WorkflowExporter exporter : workflowExporters.values()) {
            if (!linkedIds.contains(exporter.getId())) continue;
            this.workflowDependencies.add(exporter);
        }
        if (this.project instanceof IInteractiveWorkflowProject) {
            IInteractiveWorkflowProject iProject = (IInteractiveWorkflowProject)this.project;
            for (String interactionType : iProject.getSupportedInteractionTypes()) {
                this.languageMapping.put(interactionType, iProject.getSupportedLanguages(interactionType));
                for (String language : iProject.getSupportedLanguages(interactionType)) {
                    this.resolveMediaDependencies(mediaExporters, iProject, interactionType, language, iProject.getBrandManager().getDefaultBrand());
                }
            }
        }
    }

    private void resolveMediaDependencies(Map<String, MediaExporter> mediaExporters, IInteractiveWorkflowProject iProject, String interactionType, String language, IBrand brand) {
        MediaExporter exporter;
        IMediaProject mediaProject = iProject.getMediaProviderManager().getMediaProject(interactionType, brand, language);
        if (mediaProject != null && (exporter = mediaExporters.get(mediaProject.getName())) != null) {
            this.mediaDependencies.put(String.valueOf(brand.getId()) + ":" + interactionType + ":" + language, exporter);
        }
        for (IBrand child : brand.getChildBrands()) {
            this.resolveMediaDependencies(mediaExporters, iProject, interactionType, language, child);
        }
    }

    public Collection<IDesignDocument> getDesignDocuments() {
        LinkedList<IDesignDocument> documents = new LinkedList<IDesignDocument>();
        this.findDesignDocuments((IDesignItemContainer)this.project.getDesignRootFolder(), documents);
        return documents;
    }

    private void findDesignDocuments(IDesignItemContainer container, Collection<IDesignDocument> documents) {
        documents.addAll(container.getDesignDocuments());
        for (IDesignFolder folder : container.getDesignFolders()) {
            this.findDesignDocuments((IDesignItemContainer)folder, documents);
        }
    }
}

