/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.vtp.desktop.export.internal.main.ExportWriter;
import org.osgi.framework.Bundle;

public class BundleExporter {
    private final Bundle bundle;

    public BundleExporter(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public boolean isFragment() {
        return this.getHeaders().get("Fragment-Host") != null;
    }

    public Dictionary<?, ?> getHeaders() {
        return this.bundle.getHeaders();
    }

    public void export(ExportWriter output, String basePath) throws Exception {
        File bundleFile = FileLocator.getBundleFile((Bundle)this.bundle);
        if (bundleFile == null) {
            return;
        }
        if (!(bundleFile = bundleFile.getCanonicalFile()).exists()) {
            return;
        }
        String jarName = String.valueOf(basePath) + this.getSymbolicName() + "_" + (String)this.bundle.getHeaders().get("Bundle-Version");
        if (bundleFile.isFile()) {
            output.writeFile(String.valueOf(jarName) + ".jar", bundleFile, null);
        } else {
            jarName = String.valueOf(jarName) + "/";
            File buildProperties = new File(bundleFile, "build.properties");
            if (buildProperties.exists()) {
                Properties props = new Properties();
                InputStream input = null;
                try {
                    input = new FileInputStream(buildProperties);
                    props.load(input);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
                StringTokenizer i = new StringTokenizer(props.getProperty("bin.includes"), ",");
                while (i.hasMoreTokens()) {
                    String binToken = i.nextToken().trim();
                    if (binToken.length() == 0) continue;
                    String target = props.getProperty("output." + binToken);
                    if (target == null) {
                        output.writeFile(String.valueOf(jarName) + binToken, new File(bundleFile, binToken).getCanonicalFile(), null);
                        continue;
                    }
                    StringTokenizer j = new StringTokenizer(target, ",");
                    while (j.hasMoreTokens()) {
                        String outputToken = j.nextToken().trim();
                        if (outputToken.length() == 0) continue;
                        String entryName = ".".equals(binToken) ? jarName : String.valueOf(jarName) + binToken;
                        output.writeFile(entryName, new File(bundleFile, outputToken).getCanonicalFile(), null);
                    }
                }
            } else {
                output.writeFile(jarName, bundleFile.getCanonicalFile(), null);
            }
        }
    }
}

