/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.wizards;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.vtp.desktop.export.internal.ExportAgent;
import org.eclipse.vtp.desktop.export.internal.ExportCore;
import org.eclipse.vtp.desktop.export.internal.Exporter;
import org.eclipse.vtp.desktop.export.internal.MediaExporter;
import org.eclipse.vtp.desktop.export.internal.ProjectExporter;
import org.eclipse.vtp.desktop.export.internal.WorkflowExporter;
import org.eclipse.vtp.desktop.export.internal.main.WebApplicationExporter;
import org.eclipse.vtp.desktop.export.internal.pages.ArchiveSelectionPage;
import org.eclipse.vtp.desktop.export.internal.pages.ProjectSelectionPage;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;

public class ExportWizard
extends Wizard
implements IExportWizard {
    private final List<ExportAgent> agents = Collections.unmodifiableList(ExportCore.createExportAgents());
    private final Exporter exporter = new Exporter(this.agents);
    private List<WorkflowExporter> workflowProjects;
    private final Map<IWizardPage, ExportAgent> pages = new LinkedHashMap<IWizardPage, ExportAgent>();

    public ExportWizard() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            List rawProjects = WorkflowCore.getDefault().getWorkflowModel().listWorkflowProjects();
            ArrayList<WorkflowExporter> workflowList = new ArrayList<WorkflowExporter>(rawProjects.size());
            for (IWorkflowProject project : rawProjects) {
                workflowList.add(new WorkflowExporter(this.exporter, db, project));
            }
            Collections.sort(workflowList);
            this.workflowProjects = Collections.unmodifiableList(workflowList);
            this.setNeedsProgressMonitor(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            HashMap<String, WorkflowExporter> workflowMap = new HashMap<String, WorkflowExporter>();
            for (WorkflowExporter project : this.workflowProjects) {
                workflowMap.put(project.getProject().getName(), project);
            }
            HashMap<String, MediaExporter> mediaMap = new HashMap<String, MediaExporter>();
            for (IMediaProject project : InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().listMediaProjects()) {
                mediaMap.put(project.getName(), new MediaExporter(this.exporter, project));
            }
            ArrayList mediaList = new ArrayList(mediaMap.values());
            Collections.sort(mediaList);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser sp = spf.newSAXParser();
            for (WorkflowExporter exporter : this.workflowProjects) {
                exporter.resolveDependencies(sp, workflowMap, mediaMap);
            }
            IWorkbenchPage[] workbenchPages = workbench.getActiveWorkbenchWindow().getPages();
            int i = 0;
            while (i < workbenchPages.length) {
                IEditorReference[] editorReferences = workbenchPages[i].getEditorReferences();
                int j = 0;
                while (j < editorReferences.length) {
                    if (editorReferences[j].isDirty()) {
                        String name;
                        ProjectExporter project;
                        IEditorInput editorInput = null;
                        try {
                            editorInput = editorReferences[j].getEditorInput();
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        if (editorInput instanceof IFileEditorInput && ((project = (ProjectExporter)workflowMap.get(name = ((IFileEditorInput)editorInput).getFile().getProject().getName())) != null || (project = (ProjectExporter)mediaMap.get(name)) != null)) {
                            project.setDirty(true);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            HashSet<WorkflowExporter> selectedProjects = new HashSet<WorkflowExporter>();
            ISelection currentSelection = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (currentSelection instanceof IStructuredSelection) {
                for (Object selected : ((IStructuredSelection)currentSelection).toList()) {
                    WorkflowExporter project;
                    if (!(selected instanceof IProject) || (project = (WorkflowExporter)workflowMap.get(((IProject)selected).getName())) == null) continue;
                    selectedProjects.add(project);
                }
            }
            ArchiveSelectionPage archiveSelectionPage = new ArchiveSelectionPage(this.exporter);
            ProjectSelectionPage projectSelectionPage = new ProjectSelectionPage(this.exporter, this.workflowProjects, selectedProjects);
            this.pages.put((IWizardPage)archiveSelectionPage, null);
            this.pages.put((IWizardPage)projectSelectionPage, null);
            for (ExportAgent agent : this.agents) {
                for (IWizardPage page : agent.getValue().init()) {
                    this.pages.put(page, agent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addPages() {
        for (IWizardPage page : this.pages.keySet()) {
            this.addPage(page);
        }
    }

    public final IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        ExportAgent agent = this.pages.get(nextPage);
        while (agent != null && !agent.getValue().shouldBeShown(nextPage)) {
            nextPage = super.getNextPage(nextPage);
            agent = this.pages.get(nextPage);
        }
        return nextPage;
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previousPage = super.getPreviousPage(page);
        ExportAgent agent = this.pages.get(previousPage);
        while (agent != null && !agent.getValue().shouldBeShown(previousPage)) {
            previousPage = super.getPreviousPage(previousPage);
            agent = this.pages.get(previousPage);
        }
        return previousPage;
    }

    public final boolean canFinish() {
        for (ExportAgent agent : this.agents) {
            if (agent.getValue().canFinish()) continue;
            return false;
        }
        return super.canFinish();
    }

    public final boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (!(ExportWizard.this.exporter.isUsingArchiveFile() || ExportWizard.this.exporter.getArchiveLocation().isDirectory() || ExportWizard.this.exporter.getArchiveLocation().mkdirs())) {
                            throw new FileNotFoundException(ExportWizard.this.exporter.getArchiveLocation().getAbsolutePath());
                        }
                        new WebApplicationExporter(ExportWizard.this.agents).export(ExportWizard.this.exporter.getArchiveLocation(), ExportWizard.this.exporter.getWorkflowSelection(), ExportWizard.this.exporter.getMediaSelection(), ExportWizard.this.exporter.hasSeparateMedia(), ExportWizard.this.exporter.getMediaLocation(), monitor);
                        ((ArchiveSelectionPage)((Object)ExportWizard.this.pages.keySet().iterator().next())).saveArchivePath();
                        for (WorkflowExporter workflowExporter : ExportWizard.this.exporter.getWorkflowSelection()) {
                            workflowExporter.saveSettings(ExportWizard.this.exporter);
                        }
                        for (MediaExporter mediaExporter : ExportWizard.this.exporter.getMediaSelection()) {
                            mediaExporter.saveSettings(ExportWizard.this.exporter);
                        }
                        ExportCore.flushPreferences();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new InvocationTargetException(exception);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            ExportCore.displayError(this.getShell(), "Error Exporting Web Application", e.getTargetException());
        }
        catch (Exception e) {
            ExportCore.displayError(this.getShell(), "Error Exporting Web Application", e);
        }
        return false;
    }
}

