/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.MissingContentCreatorPanel;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentType;
import org.osgi.framework.Bundle;

public class ContentCreatorPanelManager {
    public static final String contentCreatorPanelExtensionId = "org.eclipse.vtp.desktop.media.core.contentCreatorPanels";
    private static final ContentCreatorPanelManager INSTANCE = new ContentCreatorPanelManager();
    Map<String, ContentCreatorRecord> creatorPanels = new HashMap<String, ContentCreatorRecord>();

    public static ContentCreatorPanelManager getInstance() {
        return INSTANCE;
    }

    public ContentCreatorPanelManager() {
        IConfigurationElement[] creatorExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(contentCreatorPanelExtensionId);
        int i = 0;
        while (i < creatorExtensions.length) {
            block3: {
                ContentCreatorRecord ccr = new ContentCreatorRecord();
                ccr.contentType = creatorExtensions[i].getAttribute("content-type");
                String className = creatorExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)creatorExtensions[i].getContributor().getName());
                try {
                    ccr.creatorClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block3;
                }
                this.creatorPanels.put(ccr.contentType, ccr);
            }
            ++i;
        }
    }

    public ContentCreatorPanel getCreatorPanel(ContentType contentType) {
        ContentCreatorRecord ccr = this.creatorPanels.get(contentType.getId());
        if (ccr != null) {
            try {
                return ccr.creatorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new MissingContentCreatorPanel();
    }

    private class ContentCreatorRecord {
        String contentType;
        Class<ContentCreatorPanel> creatorClass;

        private ContentCreatorRecord() {
        }
    }
}

