/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.media.core.ContentEntryDialog;
import org.eclipse.vtp.desktop.media.core.ContentPlaceholder;
import org.eclipse.vtp.desktop.media.core.ScriptDialog;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingCase;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingEntry;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingNode;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingSwitch;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.PlaceholderContent;
import org.eclipse.vtp.framework.interactions.core.media.ReferencedContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public abstract class ContentTreeDialog
extends Dialog {
    private PromptBindingItem treeContent = null;
    private IMediaProvider mediaProvider = null;
    private TreeViewer viewer = null;
    List<ContentPlaceholder> placeholders;

    public ContentTreeDialog(Shell parentShell) {
        super(parentShell);
    }

    public ContentTreeDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    protected PromptBindingItem getTreeContent() {
        return this.treeContent;
    }

    protected void setTreeContent(PromptBindingItem treeContent) {
        this.treeContent = treeContent;
        if (this.viewer != null) {
            this.viewer.setInput((Object)treeContent);
        }
    }

    public void setPlaceholders(List<ContentPlaceholder> placeholders) {
        this.placeholders = placeholders;
    }

    public void setMediaProvider(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    protected void contentChanged() {
        this.getButton(0).setEnabled(this.isContentValid());
    }

    protected boolean isContentValid() {
        return true;
    }

    protected List<Variable> getVariables() {
        return Collections.emptyList();
    }

    private void addEntry(Object parent) {
        ContentEntryDialog pbed = new ContentEntryDialog(this.getShell());
        pbed.setMediaProvider(this.mediaProvider);
        pbed.setVariables(this.getVariables());
        pbed.setPlaceholders(this.placeholders);
        int result = pbed.open();
        if (result == 0) {
            Content c = pbed.getContent();
            if (parent instanceof PromptBindingCase) {
                ((PromptBindingCase)parent).addChild((PromptBindingNode)new PromptBindingEntry(c));
            } else if (parent instanceof PromptBindingItem) {
                ((PromptBindingItem)parent).addEntry((PromptBindingNode)new PromptBindingEntry(c));
            }
            this.viewer.refresh();
            this.contentChanged();
        }
    }

    private void addSwitch(Object parent) {
        if (parent instanceof PromptBindingCase) {
            ((PromptBindingCase)parent).addChild((PromptBindingNode)new PromptBindingSwitch());
        } else if (parent instanceof PromptBindingItem) {
            ((PromptBindingItem)parent).addEntry((PromptBindingNode)new PromptBindingSwitch());
        }
        this.viewer.refresh();
        this.contentChanged();
    }

    private void addCase(Object parent) {
        ScriptDialog sd;
        if (parent instanceof PromptBindingSwitch && (sd = new ScriptDialog(this.getShell())).open() == 0) {
            ((PromptBindingSwitch)parent).addChild(new PromptBindingCase(sd.getScript()));
            this.viewer.refresh();
            this.contentChanged();
        }
    }

    private void editNode(PromptBindingNode target) {
        if (target instanceof PromptBindingCase) {
            ScriptDialog sd = new ScriptDialog(this.getShell());
            sd.setScript(((PromptBindingCase)target).getCondition());
            if (sd.open() == 0) {
                ((PromptBindingCase)target).setCondition(sd.getScript());
                this.viewer.refresh();
                this.contentChanged();
            }
        } else {
            PromptBindingEntry node = (PromptBindingEntry)target;
            ContentEntryDialog pbed = new ContentEntryDialog(this.getShell());
            pbed.setMediaProvider(this.mediaProvider);
            pbed.setVariables(this.getVariables());
            pbed.setPlaceholders(this.placeholders);
            pbed.setContent(node.getContent());
            int result = pbed.open();
            if (result == 0) {
                node.setContent(pbed.getContent());
                this.viewer.refresh();
                this.contentChanged();
            }
        }
    }

    private void removeNode(PromptBindingNode target) {
        PromptBindingNode parent = target.getParent();
        if (parent == null) {
            this.treeContent.getEntries().remove(target);
        } else if (parent instanceof PromptBindingSwitch) {
            ((PromptBindingSwitch)parent).removeChild((Object)target);
        } else if (parent instanceof PromptBindingCase) {
            ((PromptBindingCase)parent).removeChild(target);
        }
        this.viewer.refresh();
        this.contentChanged();
    }

    protected Control createContents(Composite parent) {
        Control createdContents = super.createContents(parent);
        this.contentChanged();
        return createdContents;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Contents");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData());
        Tree tree = new Tree(comp, 66052);
        tree.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.widthHint = 255;
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        TreeColumn entryColumn = new TreeColumn(tree, 0);
        entryColumn.setText("Entries");
        entryColumn.setWidth(250);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new PromptBindingContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PromptBindingLabelProvider());
        if (this.treeContent != null) {
            this.viewer.setInput((Object)this.treeContent);
        }
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    try {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        ContentTreeDialog.this.editNode((PromptBindingNode)selection.getFirstElement());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    confirmationDialog.setMessage("Are you sure you want to delete the selected item?");
                    int result = confirmationDialog.open();
                    if (result == 64) {
                        try {
                            IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                            ContentTreeDialog.this.removeNode((PromptBindingNode)selection.getFirstElement());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.verticalIndent = 20;
        gd.verticalAlignment = 128;
        buttonComp.setLayoutData((Object)gd);
        Button addEntryButton = new Button(buttonComp, 8);
        addEntryButton.setText("Add Entry");
        addEntryButton.setLayoutData((Object)new GridData(768));
        addEntryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                    Object selected = selection.getFirstElement();
                    if (selected == null) {
                        ContentTreeDialog.this.addEntry(ContentTreeDialog.this.treeContent);
                    } else if (selected instanceof PromptBindingEntry) {
                        ContentTreeDialog.this.addEntry(ContentTreeDialog.this.parentOf(selected));
                    } else if (selected instanceof PromptBindingSwitch) {
                        ContentTreeDialog.this.addEntry(ContentTreeDialog.this.parentOf(selected));
                    } else {
                        ContentTreeDialog.this.addEntry(selected);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        Button addChoicesButton = new Button(buttonComp, 8);
        addChoicesButton.setText("Add Choices");
        addChoicesButton.setLayoutData((Object)new GridData(768));
        addChoicesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                    Object selected = selection.getFirstElement();
                    if (selected == null) {
                        ContentTreeDialog.this.addSwitch(ContentTreeDialog.this.treeContent);
                    } else if (selected instanceof PromptBindingEntry) {
                        ContentTreeDialog.this.addSwitch(ContentTreeDialog.this.parentOf(selected));
                    } else if (selected instanceof PromptBindingSwitch) {
                        ContentTreeDialog.this.addSwitch(ContentTreeDialog.this.parentOf(selected));
                    } else {
                        ContentTreeDialog.this.addSwitch(selected);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Button addChoiceButton = new Button(buttonComp, 8);
        addChoiceButton.setText("Add Choice");
        addChoiceButton.setLayoutData((Object)new GridData(768));
        addChoiceButton.setEnabled(false);
        addChoiceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                    Object selected = selection.getFirstElement();
                    if (selected instanceof PromptBindingCase) {
                        ContentTreeDialog.this.addCase(ContentTreeDialog.this.parentOf(selected));
                    } else if (selected instanceof PromptBindingSwitch) {
                        ContentTreeDialog.this.addCase(selected);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Button editButton = new Button(buttonComp, 8);
        editButton.setText("Edit");
        editButton.setEnabled(false);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                    ContentTreeDialog.this.editNode((PromptBindingNode)selection.getFirstElement());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Button removeButton = new Button(buttonComp, 8);
        removeButton.setText("Remove");
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                confirmationDialog.setMessage("Are you sure you want to delete the selected item?");
                int result = confirmationDialog.open();
                if (result == 64) {
                    try {
                        IStructuredSelection selection = (IStructuredSelection)ContentTreeDialog.this.viewer.getSelection();
                        ContentTreeDialog.this.removeNode((PromptBindingNode)selection.getFirstElement());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                addChoiceButton.setEnabled(selection.getFirstElement() instanceof PromptBindingSwitch || selection.getFirstElement() instanceof PromptBindingCase);
                editButton.setEnabled(!(selection.getFirstElement() instanceof PromptBindingSwitch));
                removeButton.setEnabled(!selection.isEmpty());
            }
        });
        return comp;
    }

    private Object parentOf(Object element) {
        if (element instanceof PromptBindingNode) {
            PromptBindingNode parent = ((PromptBindingNode)element).getParent();
            return parent == null ? this.treeContent : parent;
        }
        return null;
    }

    private class PromptBindingContentProvider
    implements ITreeContentProvider {
        private PromptBindingContentProvider() {
        }

        public Object getParent(Object element) {
            return ContentTreeDialog.this.parentOf(element);
        }

        public boolean hasChildren(Object element) {
            return element instanceof PromptBindingItem || element instanceof PromptBindingSwitch || element instanceof PromptBindingCase;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PromptBindingItem) {
                return ((PromptBindingItem)parentElement).getEntries().toArray();
            }
            if (parentElement instanceof PromptBindingSwitch) {
                return ((PromptBindingSwitch)parentElement).getChildren().toArray();
            }
            if (parentElement instanceof PromptBindingCase) {
                return ((PromptBindingCase)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PromptBindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PromptBindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PromptBindingSwitch) {
                return "Choices";
            }
            if (element instanceof PromptBindingCase) {
                return ((PromptBindingCase)element).getCondition();
            }
            StringBuffer buf = new StringBuffer();
            Content content = ((PromptBindingEntry)element).getContent();
            if (content instanceof FormattableContent) {
                FormattableContent fc = (FormattableContent)content;
                buf.append(String.valueOf(fc.getContentTypeName()) + "(" + fc.getFormatName() + ", " + fc.getValue() + ")");
            } else if (content instanceof TextContent) {
                buf.append(((TextContent)content).getText());
            } else if (content instanceof ReferencedContent) {
                buf.append("REFERENCE(" + ((ReferencedContent)content).getReferencedName() + ")");
            } else if (content instanceof FileContent) {
                FileContent fc = (FileContent)content;
                buf.append(String.valueOf(fc.getFileTypeName()) + "(" + fc.getPath() + ")");
            } else if (content instanceof PlaceholderContent) {
                buf.append("Placeholder(");
                buf.append(((PlaceholderContent)content).getPlaceholder());
                buf.append(")");
            }
            return buf.toString();
        }
    }
}

