/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.media.core.DynamicContentCreatorPanel;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.DateContent;

public class DateContentCreatorPanel
extends DynamicContentCreatorPanel {
    Text text = null;
    Composite options = null;
    StackLayout optionsLayout = null;
    Label noOptions = null;
    Map<String, FormatOptions> optionMap = new HashMap<String, FormatOptions>();

    @Override
    public Content createContent() {
        DateContent content = new DateContent();
        if (this.isDynamicSelected()) {
            content.setVariableValue(this.getDynamicSelection());
        } else {
            content.setStaticValue(this.text.getText());
        }
        content.setFormatName(this.getFormat());
        FormatOptions formatOptions = this.optionMap.get(this.getFormat());
        if (formatOptions != null) {
            content.setFormatOptions(formatOptions.getEncodedOptions());
        }
        return content;
    }

    @Override
    public Control createStaticControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.text = new Text(comp, 0x800804);
        this.text.setLayoutData((Object)new GridData(768));
        return comp;
    }

    @Override
    protected Control createFormatterControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(768));
        super.createFormatterControls(composite);
        this.options = new Composite(composite, 0);
        this.optionsLayout = new StackLayout();
        this.options.setLayout((Layout)this.optionsLayout);
        this.options.setLayoutData((Object)new GridData(768));
        this.noOptions = new Label(this.options, 0);
        this.optionMap.put("Day of Week", new DayOfWeekFormatOptions());
        this.optionMap.put("Hour of Day", new HourOfDayFormatOptions());
        for (FormatOptions formatOptions : this.optionMap.values()) {
            formatOptions.createOptionsControls(this.options);
        }
        this.optionsLayout.topControl = this.noOptions;
        this.formatCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateContentCreatorPanel.this.updateFormatOptions();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    @Override
    public void setInitialContent(Content content) {
        if (content instanceof DateContent) {
            DateContent dateContent = (DateContent)content;
            if (dateContent.getValueType() == 1) {
                this.setDynamicSelected(false);
                this.text.setText(dateContent.getValue());
            } else {
                this.setDynamicSelected(true);
                this.setDynamicSelection(dateContent.getValue());
            }
        }
        super.setInitialContent(content);
        FormatOptions formatOptions = this.updateFormatOptions();
        if (formatOptions != null && content instanceof DateContent) {
            formatOptions.setEncodedOptions(((DateContent)content).getFormatOptions());
        }
    }

    private FormatOptions updateFormatOptions() {
        FormatOptions formatOptions = this.optionMap.get(this.getFormat());
        this.optionsLayout.topControl = formatOptions == null ? this.noOptions : formatOptions.getControl();
        this.options.layout(true, true);
        return formatOptions;
    }

    private final class DayOfWeekFormatOptions
    extends FormatOptions {
        Composite dayOfWeekOptions;
        Button dayOfWeekToday;
        Button dayOfWeekTomorrow;
        Button dayOfWeekThisXXX;
        Button dayOfWeekNextXXX;

        private DayOfWeekFormatOptions() {
            this.dayOfWeekOptions = null;
            this.dayOfWeekToday = null;
            this.dayOfWeekTomorrow = null;
            this.dayOfWeekThisXXX = null;
            this.dayOfWeekNextXXX = null;
        }

        @Override
        Control getControl() {
            return this.dayOfWeekOptions;
        }

        @Override
        String getEncodedOptions() {
            StringBuilder builder = new StringBuilder();
            if (this.dayOfWeekToday.getSelection()) {
                builder.append("today,");
            }
            if (this.dayOfWeekTomorrow.getSelection()) {
                builder.append("tomorrow,");
            }
            if (this.dayOfWeekThisXXX.getSelection()) {
                builder.append("this,");
            }
            if (this.dayOfWeekNextXXX.getSelection()) {
                builder.append("next,");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }

        @Override
        void setEncodedOptions(String options) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(options.split(",")));
            this.dayOfWeekToday.setSelection(set.contains("today"));
            this.dayOfWeekTomorrow.setSelection(set.contains("tomorrow"));
            this.dayOfWeekThisXXX.setSelection(set.contains("this"));
            this.dayOfWeekNextXXX.setSelection(set.contains("next"));
        }

        @Override
        void createOptionsControls(Composite parent) {
            this.dayOfWeekOptions = new Composite(parent, 0);
            this.dayOfWeekOptions.setLayout((Layout)new GridLayout(2, true));
            this.dayOfWeekOptions.setLayoutData((Object)new GridData(768));
            this.dayOfWeekToday = new Button(this.dayOfWeekOptions, 32);
            this.dayOfWeekToday.setText("Today");
            this.dayOfWeekToday.setLayoutData((Object)new GridData(768));
            this.dayOfWeekTomorrow = new Button(this.dayOfWeekOptions, 32);
            this.dayOfWeekTomorrow.setText("Tomorrow");
            this.dayOfWeekTomorrow.setLayoutData((Object)new GridData(768));
            this.dayOfWeekThisXXX = new Button(this.dayOfWeekOptions, 32);
            this.dayOfWeekThisXXX.setText("This ...");
            this.dayOfWeekThisXXX.setLayoutData((Object)new GridData(768));
            this.dayOfWeekNextXXX = new Button(this.dayOfWeekOptions, 32);
            this.dayOfWeekNextXXX.setText("Next ...");
            this.dayOfWeekNextXXX.setLayoutData((Object)new GridData(768));
        }
    }

    private abstract class FormatOptions {
        private FormatOptions() {
        }

        abstract Control getControl();

        abstract String getEncodedOptions();

        abstract void setEncodedOptions(String var1);

        abstract void createOptionsControls(Composite var1);
    }

    private final class HourOfDayFormatOptions
    extends FormatOptions {
        Composite hourOfDayOptions = null;
        Button hourOfDayMinutes = null;

        private HourOfDayFormatOptions() {
        }

        @Override
        Control getControl() {
            return this.hourOfDayOptions;
        }

        @Override
        String getEncodedOptions() {
            StringBuilder builder = new StringBuilder();
            if (this.hourOfDayMinutes != null && this.hourOfDayMinutes.getSelection()) {
                builder.append("minutes,");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }

        @Override
        void setEncodedOptions(String options) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(options.split(",")));
            if (this.hourOfDayMinutes != null) {
                this.hourOfDayMinutes.setSelection(set.contains("minutes"));
            }
        }

        @Override
        void createOptionsControls(Composite parent) {
            this.hourOfDayOptions = new Composite(DateContentCreatorPanel.this.options, 0);
            this.hourOfDayOptions.setLayout((Layout)new GridLayout(1, true));
            this.hourOfDayOptions.setLayoutData((Object)new GridData(768));
            this.hourOfDayMinutes = new Button(this.hourOfDayOptions, 32);
            this.hourOfDayMinutes.setText("Minutes");
            this.hourOfDayMinutes.setLayoutData((Object)new GridData(768));
        }
    }
}

