/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanel;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;

public abstract class DynamicContentCreatorPanel
extends ContentCreatorPanel {
    private List<Variable> variables = null;
    private boolean dynamicSelected = false;
    private Button staticButton = null;
    private Button dynamicButton = null;
    private Combo options = null;
    Combo formatCombo = null;
    List<String> formatNames = null;

    protected DynamicContentCreatorPanel() {
    }

    public boolean isDynamic() {
        return this.variables != null;
    }

    public boolean isDynamicSelected() {
        return this.dynamicSelected;
    }

    public String getDynamicSelection() {
        if (this.options == null || !this.dynamicSelected) {
            return null;
        }
        return this.options.getItem(this.options.getSelectionIndex());
    }

    public void setVariables(List<Variable> variables) {
        if (variables == null) {
            this.setDynamicSelected(false);
            this.variables = null;
        } else {
            this.variables = new ArrayList<Variable>(variables);
            Collections.sort(this.variables, new Comparator<Variable>(){

                @Override
                public int compare(Variable o1, Variable o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    public void setDynamicSelected(boolean dynamicSelected) {
        if (!this.isDynamic() && dynamicSelected) {
            return;
        }
        this.dynamicSelected = dynamicSelected;
        if (this.staticButton != null) {
            this.staticButton.setSelection(!dynamicSelected);
        }
        if (this.dynamicButton != null) {
            this.dynamicButton.setSelection(dynamicSelected);
        }
    }

    public void setDynamicSelection(String dynamicSelection) {
        if (this.options == null || !this.dynamicSelected || dynamicSelection == null) {
            return;
        }
        int i = 0;
        while (i < this.options.getItemCount()) {
            if (dynamicSelection.equals(this.options.getItem(i))) {
                this.options.select(i);
                break;
            }
            ++i;
        }
    }

    public String getFormat() {
        if (this.formatCombo != null && this.formatCombo.getSelectionIndex() != -1) {
            return this.formatCombo.getItem(this.formatCombo.getSelectionIndex());
        }
        return "Default";
    }

    @Override
    public final void createControls(Composite parent) {
        if (!this.isDynamic()) {
            this.setControl(this.createStaticControls(parent));
            return;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.staticButton = new Button(composite, 16);
        this.staticButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.staticButton.setSelection(!this.dynamicSelected);
        this.staticButton.setText("Use a static value:");
        Control staticControl = this.createStaticControls(composite);
        staticControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dynamicButton = new Button(composite, 16);
        this.dynamicButton.setLayoutData((Object)new GridData(768));
        this.dynamicButton.setSelection(this.dynamicSelected);
        this.dynamicButton.setText("Use a value from a variable:");
        Control dynamicControl = this.createDynamicControls(composite);
        dynamicControl.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DynamicContentCreatorPanel.this.staticButton.equals(e.getSource())) {
                    DynamicContentCreatorPanel.this.dynamicSelected = false;
                } else if (DynamicContentCreatorPanel.this.dynamicButton.equals(e.getSource())) {
                    DynamicContentCreatorPanel.this.dynamicSelected = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.staticButton.addSelectionListener(selectionListener);
        this.dynamicButton.addSelectionListener(selectionListener);
        if (this.createContent() instanceof FormattableContent) {
            this.createFormatterControls(composite);
        }
        this.setControl((Control)composite);
    }

    protected Control createFormatterControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(768));
        Label formatLabel = new Label(composite, 0);
        formatLabel.setText("Please select a format:");
        formatLabel.setLayoutData((Object)new GridData(768));
        this.formatCombo = new Combo(composite, 12);
        this.formatNames = this.getMediaProvider().getFormatManager().getFormats((FormattableContent)this.createContent());
        for (String formatName : this.formatNames) {
            this.formatCombo.add(formatName);
        }
        this.formatCombo.setLayoutData((Object)new GridData(768));
        this.formatCombo.select(0);
        return composite;
    }

    protected Control createDynamicControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData());
        comp.setLayout((Layout)new GridLayout(2, false));
        this.options = new Combo(comp, 12);
        this.options.setLayoutData((Object)new GridData(768));
        for (Variable v : this.variables) {
            this.processVariable((ObjectDefinition)v);
        }
        this.options.add("LastResult.markname");
        this.options.add("LastResult.marktime");
        this.options.add("LastResult.confidence");
        this.options.add("LastResult.utterance");
        this.options.add("LastResult.inputmode");
        this.options.add("LastResult.interpretation");
        if (this.options.getItemCount() > 0) {
            this.options.select(0);
        }
        return comp;
    }

    private void processVariable(ObjectDefinition def) {
        this.options.add(def.getPath());
        for (ObjectField field : def.getFields()) {
            this.processVariable((ObjectDefinition)field);
        }
    }

    @Override
    public void setInitialContent(Content content) {
        if (content instanceof FormattableContent) {
            FormattableContent dateContent = (FormattableContent)content;
            int i = 0;
            while (i < this.formatNames.size()) {
                String formatName = this.formatNames.get(i);
                if (formatName.equals(dateContent.getFormatName())) {
                    this.formatCombo.select(i);
                }
                ++i;
            }
        }
    }

    protected abstract Control createStaticControls(Composite var1);
}

