/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.media.core.InputGrammarCreatorPanel;
import org.eclipse.vtp.desktop.media.core.ResourceChooserDialog;
import org.eclipse.vtp.framework.interactions.core.media.FileInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;

public abstract class GrammarFileCreatorPanel
extends InputGrammarCreatorPanel
implements SelectionListener {
    Text text = null;

    @Override
    public InputGrammar createGrammar() {
        if (this.text.getText().equals("")) {
            return null;
        }
        FileInputGrammar content = this.createNewGrammar();
        content.setStaticPath(this.text.getText());
        return content;
    }

    @Override
    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.text = new Text(comp, 0x800804);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        Button browseButton = new Button(comp, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)comp);
    }

    @Override
    public void setInitialInput(InputGrammar content) {
        if (content instanceof FileInputGrammar) {
            this.text.setText(((FileInputGrammar)content).getPath());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        ResourceChooserDialog dialog = new ResourceChooserDialog(this.text.getShell(), this.getMediaProvider().getResourceManager(), this.text.getText());
        if (dialog.open() != 0) {
            return;
        }
        this.text.setText(dialog.getValue());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected abstract FileInputGrammar createNewGrammar();
}

