/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.InputGrammarCreatorPanel;
import org.eclipse.vtp.desktop.model.interactive.core.input.InputType;
import org.osgi.framework.Bundle;

public class InputGrammarCreatorPanelManager {
    public static final String inputCreatorPanelExtensionId = "org.eclipse.vtp.desktop.media.core.inputCreatorPanels";
    private static final InputGrammarCreatorPanelManager INSTANCE = new InputGrammarCreatorPanelManager();
    Map<String, ContentCreatorRecord> creatorPanels = new HashMap<String, ContentCreatorRecord>();
    List<ContentCreatorRecord> sortedPanels = new ArrayList<ContentCreatorRecord>();

    public static InputGrammarCreatorPanelManager getInstance() {
        return INSTANCE;
    }

    public InputGrammarCreatorPanelManager() {
        IConfigurationElement[] creatorExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(inputCreatorPanelExtensionId);
        int i = 0;
        while (i < creatorExtensions.length) {
            block6: {
                ContentCreatorRecord ccr = new ContentCreatorRecord();
                ccr.contentType = creatorExtensions[i].getAttribute("input-type");
                ccr.contentName = creatorExtensions[i].getAttribute("input-type-name");
                String className = creatorExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)creatorExtensions[i].getContributor().getName());
                try {
                    ccr.creatorClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block6;
                }
                this.creatorPanels.put(ccr.contentType, ccr);
                boolean inserted = false;
                int r = 0;
                while (r < this.sortedPanels.size()) {
                    ContentCreatorRecord record = this.sortedPanels.get(r);
                    if (ccr.contentName.compareToIgnoreCase(record.contentName) < 0) {
                        this.sortedPanels.add(r, ccr);
                        inserted = true;
                        break;
                    }
                    ++r;
                }
                if (!inserted) {
                    this.sortedPanels.add(ccr);
                }
            }
            ++i;
        }
    }

    public List<ContentCreatorRecord> getInputTypes() {
        return new ArrayList<ContentCreatorRecord>(this.sortedPanels);
    }

    public InputGrammarCreatorPanel getCreatorPanel(InputType contentType) {
        ContentCreatorRecord ccr = this.creatorPanels.get(contentType.getId());
        if (ccr != null) {
            try {
                return ccr.creatorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public class ContentCreatorRecord {
        String contentType;
        String contentName;
        Class<InputGrammarCreatorPanel> creatorClass;
    }
}

