/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.osgi.framework.Bundle;

public class MediaConfigurationScreenManager {
    public static final String mediaConfigurationScreenExtensionId = "org.eclipse.vtp.desktop.media.core.mediaConfigurationScreens";
    private static final MediaConfigurationScreenManager INSTANCE = new MediaConfigurationScreenManager();
    Map<String, Map<String, ConfigurationScreenRecord>> configurationScreens = new HashMap<String, Map<String, ConfigurationScreenRecord>>();

    public static MediaConfigurationScreenManager getInstance() {
        return INSTANCE;
    }

    public MediaConfigurationScreenManager() {
        IConfigurationElement[] screenExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaConfigurationScreenExtensionId);
        int i = 0;
        while (i < screenExtensions.length) {
            block4: {
                ConfigurationScreenRecord csr = new ConfigurationScreenRecord();
                csr.primitiveTypeId = screenExtensions[i].getAttribute("primitive-id");
                csr.interactionType = screenExtensions[i].getAttribute("interaction-type");
                String className = screenExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)screenExtensions[i].getContributor().getName());
                try {
                    csr.screenClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block4;
                }
                Map<String, ConfigurationScreenRecord> byInteraction = this.configurationScreens.get(csr.primitiveTypeId);
                if (byInteraction == null) {
                    byInteraction = new HashMap<String, ConfigurationScreenRecord>();
                    this.configurationScreens.put(csr.primitiveTypeId, byInteraction);
                }
                byInteraction.put(csr.interactionType, csr);
            }
            ++i;
        }
    }

    public MediaConfigurationScreen getMediaConfigurationScreen(String primitiveTypeId, String interactionType) {
        ConfigurationScreenRecord csr;
        MediaConfigurationScreen ret = null;
        Map<String, ConfigurationScreenRecord> byInteraction = this.configurationScreens.get(primitiveTypeId);
        if (byInteraction != null && (csr = byInteraction.get(interactionType)) != null) {
            try {
                ret = csr.screenClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Map<String, MediaConfigurationScreen> getIndexedMediaConfigurationScreens(String primitiveTypeId, MediaConfigurationScreenContainer container) {
        HashMap<String, MediaConfigurationScreen> ret = new HashMap<String, MediaConfigurationScreen>();
        Map<String, ConfigurationScreenRecord> byInteraction = this.configurationScreens.get(primitiveTypeId);
        if (byInteraction != null) {
            for (Map.Entry<String, ConfigurationScreenRecord> entry : byInteraction.entrySet()) {
                ConfigurationScreenRecord csr = entry.getValue();
                if (csr == null) continue;
                try {
                    Constructor<MediaConfigurationScreen> con = csr.screenClass.getConstructor(MediaConfigurationScreenContainer.class);
                    ret.put(entry.getKey(), con.newInstance(container));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private class ConfigurationScreenRecord {
        String primitiveTypeId;
        String interactionType;
        Class<MediaConfigurationScreen> screenClass;

        private ConfigurationScreenRecord() {
        }
    }
}

