/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;

public class ResourceChooserDialog
extends Dialog {
    private IResourceManager resourceManager = null;
    private String value = null;
    private TreeViewer viewer;

    public ResourceChooserDialog(Shell parentShell, IResourceManager resourceManager, String initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.resourceManager = resourceManager;
        this.value = initialValue;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Select a File");
        this.getShell().pack();
        this.getShell().setSize(250, 300);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = new TreeViewer(composite, 772);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new FilesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FilesLabelProvider());
        this.viewer.setSorter((ViewerSorter)new FilesSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    ResourceChooserDialog.this.getButton(0).setEnabled(false);
                } else {
                    ResourceChooserDialog.this.getButton(0).setEnabled(!selection.getFirstElement().toString().endsWith("/"));
                }
            }
        });
        this.viewer.setInput((Object)this.resourceManager);
        this.viewer.setAutoExpandLevel(1);
        return composite;
    }

    protected void okPressed() {
        this.value = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement().toString();
        super.okPressed();
    }

    public String getValue() {
        return this.value;
    }

    private final class FilesContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private FilesContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child == ResourceChooserDialog.this.resourceManager) {
                return null;
            }
            String str = child.toString();
            while (str.endsWith("/")) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.lastIndexOf(47) < 0) {
                return ResourceChooserDialog.this.resourceManager;
            }
            return str.substring(0, str.lastIndexOf(47) + 1);
        }

        public Object[] getChildren(Object parent) {
            String[] children;
            if (parent == ResourceChooserDialog.this.resourceManager) {
                parent = "";
            }
            if ((children = ResourceChooserDialog.this.resourceManager.listResources(parent.toString())) == null) {
                return new Object[0];
            }
            Object[] results = new Object[children.length];
            int i = 0;
            while (i < results.length) {
                results[i] = parent + children[i];
                ++i;
            }
            return results;
        }

        public boolean hasChildren(Object parent) {
            return parent == ResourceChooserDialog.this.resourceManager || parent.toString().endsWith("/");
        }

        public void dispose() {
        }
    }

    private final class FilesLabelProvider
    extends LabelProvider {
        private FilesLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj == ResourceChooserDialog.this.resourceManager) {
                return "Media Files";
            }
            String str = obj.toString();
            while (str.endsWith("/")) {
                str = str.substring(0, str.length() - 1);
            }
            return str.substring(str.lastIndexOf(47) + 1);
        }

        public Image getImage(Object obj) {
            if (obj == ResourceChooserDialog.this.resourceManager || obj.toString().endsWith("/")) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }

    private final class FilesSorter
    extends ViewerSorter {
        private FilesSorter() {
        }

        public int category(Object element) {
            if (element == ResourceChooserDialog.this.resourceManager || element.toString().endsWith("/")) {
                return 1;
            }
            return 2;
        }
    }
}

