/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.media.core.IMediaDefaultPanel;
import org.eclipse.vtp.desktop.media.core.MediaDefaultsPanelManager;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults.WorkspaceMediaDefaultSettings;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class MediaDefaultsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IMediaDefaultSettings wmd = WorkspaceMediaDefaultSettings.getInstance();
    ScrolledComposite scrollComp = null;
    Composite stackComp = null;
    StackLayout stack = null;
    Combo interactionSelector = null;
    List<InteractionType> interactionTypes = null;
    List<Composite> interactionComposites = new ArrayList<Composite>();
    List<IMediaDefaultPanel> settingPanels = new ArrayList<IMediaDefaultPanel>();

    public MediaDefaultsPreferencePage() {
    }

    public MediaDefaultsPreferencePage(String title) {
        super(title);
    }

    public MediaDefaultsPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label interactionSelectorLabel = new Label(comp, 0);
        interactionSelectorLabel.setText("Interaction Type:");
        interactionSelectorLabel.setLayoutData((Object)new GridData());
        this.interactionSelector = new Combo(comp, 12);
        this.interactionSelector.setLayoutData((Object)new GridData());
        this.scrollComp = new ScrolledComposite(comp, 2560);
        this.scrollComp.setBackground(parent.getDisplay().getSystemColor(1));
        this.scrollComp.getVerticalBar().setIncrement(4);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 400;
        this.scrollComp.setLayoutData((Object)gridData);
        this.stack = new StackLayout();
        this.stackComp = new Composite((Composite)this.scrollComp, 0);
        this.stackComp.setBackground(this.scrollComp.getBackground());
        this.stackComp.setLayout((Layout)this.stack);
        this.interactionTypes = InteractionTypeManager.getInstance().getInteractionTypes();
        for (InteractionType interactionType : this.interactionTypes) {
            this.interactionSelector.add(interactionType.getName());
            Composite interactionComp = new Composite(this.stackComp, 0);
            interactionComp.setBackground(this.stackComp.getBackground());
            this.interactionComposites.add(interactionComp);
            interactionComp.setLayout((Layout)new GridLayout(1, false));
            Map<String, IMediaDefaultPanel> panelMap = MediaDefaultsPanelManager.getInstance().getIndexedMediaDefaultsPanels(interactionType.getId());
            for (IMediaDefaultPanel panel : panelMap.values()) {
                Control panelControl = panel.createControls(interactionComp, false);
                panelControl.setLayoutData((Object)new GridData(768));
                this.settingPanels.add(panel);
                if (this.wmd == null) continue;
                panel.setDefaultSettings(this.wmd);
            }
        }
        this.interactionSelector.select(0);
        this.stack.topControl = (Control)this.interactionComposites.get(0);
        this.stackComp.layout(true, true);
        this.scrollComp.setContent((Control)this.stackComp);
        this.scrollComp.setMinWidth(this.stackComp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.scrollComp.setMinHeight(this.stackComp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(true);
        this.interactionSelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                MediaDefaultsPreferencePage.this.stack.topControl = (Control)MediaDefaultsPreferencePage.this.interactionComposites.get(MediaDefaultsPreferencePage.this.interactionSelector.getSelectionIndex());
                MediaDefaultsPreferencePage.this.stackComp.layout(true, true);
                Point preferred = MediaDefaultsPreferencePage.this.stackComp.computeSize(MediaDefaultsPreferencePage.this.scrollComp.getMinWidth(), -1, true);
                MediaDefaultsPreferencePage.this.scrollComp.setMinSize(preferred);
                MediaDefaultsPreferencePage.this.stackComp.layout();
                if (preferred.y > MediaDefaultsPreferencePage.this.scrollComp.getClientArea().height) {
                    preferred = MediaDefaultsPreferencePage.this.stackComp.computeSize(MediaDefaultsPreferencePage.this.scrollComp.getClientArea().width, -1, true);
                    MediaDefaultsPreferencePage.this.scrollComp.setMinSize(preferred);
                    MediaDefaultsPreferencePage.this.stackComp.layout();
                }
                MediaDefaultsPreferencePage.this.stackComp.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).MediaDefaultsPreferencePage.this.stackComp.layout(true, true);
                    }
                });
            }
        });
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        if (this.stackComp != null) {
            int i = 0;
            while (i < this.settingPanels.size()) {
                this.settingPanels.get(i).setDefaultSettings(this.wmd);
                ++i;
            }
        }
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.settingPanels.size()) {
            this.settingPanels.get(i).save();
            ++i;
        }
        return super.performOk();
    }
}

