/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MenuChoice;
import org.eclipse.vtp.modules.interactive.ui.OptionSetInformationProvider;
import org.eclipse.vtp.modules.interactive.ui.properties.MenuChoiceBindingManager;

public class NewMenuChoiceWizard
extends Wizard {
    private ApplicationPage page = null;
    private OptionSetInformationProvider menu = null;
    private String brandName = null;
    private IBrand brand = null;
    private MenuChoiceBindingManager mcBindingManager = null;

    public NewMenuChoiceWizard(IBrand brand, OptionSetInformationProvider menu, MenuChoiceBindingManager mcBindingManager) {
        this.menu = menu;
        this.page = new ApplicationPage();
        this.addPage((IWizardPage)this.page);
        this.brandName = brand.getName();
        this.brand = brand;
        this.mcBindingManager = mcBindingManager;
    }

    public boolean performFinish() {
        MenuChoice choice = new MenuChoice(this.page.nameField.getText(), null);
        choice.setScriptText("");
        this.menu.addChoice(this.brandName, choice);
        this.mcBindingManager.addChoice(this.brandName, choice);
        return true;
    }

    private class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "New Menu Option", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            this.setControl((Control)parent);
            Label hostLabel = new Label(parent, 0);
            hostLabel.setText("Option Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(parent, 2052);
            this.nameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (ApplicationPage.this.nameField.getText().length() == 0) {
                        ApplicationPage.this.setPageComplete(false);
                    } else {
                        List options = NewMenuChoiceWizard.this.mcBindingManager.getChoicesByBrand(NewMenuChoiceWizard.this.brand);
                        for (MenuChoice mc : options) {
                            if (!ApplicationPage.this.nameField.getText().equalsIgnoreCase(mc.getOptionName())) continue;
                            ApplicationPage.this.setPageComplete(false);
                            ApplicationPage.this.setErrorMessage("Another option already exists with that name.");
                            return;
                        }
                        ApplicationPage.this.setPageComplete(true);
                        ApplicationPage.this.setErrorMessage(null);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 13);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 13 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }
    }
}

