/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.vtp.desktop.media.core.DefaultValueStack;
import org.eclipse.vtp.desktop.media.core.IMediaDefaultPanel;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class OptionSetMediaDefaultsPanel
implements IMediaDefaultPanel {
    private static final String interactionType = "org.eclipse.vtp.framework.interactions.voice.interaction";
    private static final String elementType = "org.eclipse.vtp.modules.interactive.optionSet";
    IMediaDefaultSettings settings = null;
    Combo inputModeCombo = null;
    Combo barginCombo = null;
    Spinner initialTimeoutSpinner = null;
    Spinner interdigitTimeoutSpinner = null;
    Spinner terminationTimeoutSpinner = null;
    Spinner speechCompleteTimeoutSpinner = null;
    Spinner speechIncompleteTimeoutSpinner = null;
    Spinner maxSpeechTimeoutSpinner = null;
    Spinner confidenceLevelSpinner = null;
    Spinner sensitivitySpinner = null;
    Spinner speedVsAccuracySpinner = null;
    List<DefaultValueStack> valueStacks = new LinkedList<DefaultValueStack>();

    public Control createControls(Composite parent, boolean supportDefaults) {
        DefaultValueStack lastStack = null;
        Composite settingsComposite = new Composite(parent, 0);
        settingsComposite.setBackground(parent.getBackground());
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Label panelLabel = new Label(settingsComposite, 0);
        panelLabel.setBackground(settingsComposite.getBackground());
        panelLabel.setText("Option Set");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        panelLabel.setLayoutData((Object)gridData);
        Label inputModeLabel = this.createPropertyLabel(settingsComposite, "User Input Style");
        inputModeLabel.setBackground(settingsComposite.getBackground());
        inputModeLabel.setToolTipText("This property selects the valid ways\r\na caller can provide input:\r\n\t*DTMF - Touchtone keypad only\t*Voice - Speech recognition only\t*Hybrid - Touchtone or speech accepted");
        Composite containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "input-mode");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.inputModeCombo = this.createValueDropDown(containerComp);
        this.inputModeCombo.add("Dtmf Only");
        this.inputModeCombo.add("Voice Only");
        this.inputModeCombo.add("Hybrid");
        this.inputModeCombo.select(0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return OptionSetMediaDefaultsPanel.this.inputModeCombo.getItem(OptionSetMediaDefaultsPanel.this.inputModeCombo.getSelectionIndex());
                }

                public void setValue(String value) {
                    if (value == null) {
                        OptionSetMediaDefaultsPanel.this.inputModeCombo.select(0);
                    } else if ("Dtmf Only".equals(value)) {
                        OptionSetMediaDefaultsPanel.this.inputModeCombo.select(0);
                    } else if ("Voice Only".equals(value)) {
                        OptionSetMediaDefaultsPanel.this.inputModeCombo.select(1);
                    } else if ("Hybrid".equals(value)) {
                        OptionSetMediaDefaultsPanel.this.inputModeCombo.select(2);
                    } else {
                        OptionSetMediaDefaultsPanel.this.inputModeCombo.select(0);
                    }
                }
            });
        }
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setBackground(settingsComposite.getBackground());
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "barge-in");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return OptionSetMediaDefaultsPanel.this.barginCombo.getItem(OptionSetMediaDefaultsPanel.this.barginCombo.getSelectionIndex());
                }

                public void setValue(String value) {
                    if (value == null) {
                        OptionSetMediaDefaultsPanel.this.barginCombo.select(0);
                    } else if ("true".equals(value)) {
                        OptionSetMediaDefaultsPanel.this.barginCombo.select(0);
                    } else if ("false".equals(value)) {
                        OptionSetMediaDefaultsPanel.this.barginCombo.select(1);
                    } else {
                        OptionSetMediaDefaultsPanel.this.barginCombo.select(0);
                    }
                }
            });
        }
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setBackground(settingsComposite.getBackground());
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "initial-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.initialTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.initialTimeoutSpinner.setSelection(value == null || value.equals("") ? 3 : Integer.parseInt(value));
                }
            });
        }
        Label interdigitTimeoutLabel = this.createPropertyLabel(settingsComposite, "Interdigit Timeout (Seconds)");
        interdigitTimeoutLabel.setBackground(settingsComposite.getBackground());
        interdigitTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional touchtone if the current\r\ninput does not match the grammar before\r\na NoMatch event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "interdigit-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.interdigitTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.interdigitTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.interdigitTimeoutSpinner.setSelection(value == null || value.equals("") ? 2 : Integer.parseInt(value));
                }
            });
        }
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setBackground(settingsComposite.getBackground());
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "termination-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.terminationTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.terminationTimeoutSpinner.setSelection(value == null || value.equals("") ? 3 : Integer.parseInt(value));
                }
            });
        }
        Label speechIncompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Incomplete Timeout (Seconds)");
        speechIncompleteTimeoutLabel.setBackground(settingsComposite.getBackground());
        speechIncompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\ndoes not match the provided grammar.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "speech-incomplete-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.speechIncompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.speechIncompleteTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.speechIncompleteTimeoutSpinner.setSelection(value == null || value.equals("") ? 3 : Integer.parseInt(value));
                }
            });
        }
        Label speechCompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Completion Timeout (Seconds)");
        speechCompleteTimeoutLabel.setBackground(settingsComposite.getBackground());
        speechCompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\nalready matches the provided grammar.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "speech-complete-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.speechCompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.speechCompleteTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.speechCompleteTimeoutSpinner.setSelection(value == null || value.equals("") ? 3 : Integer.parseInt(value));
                }
            });
        }
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Speech Length (Seconds)");
        maxSpeechTimeoutLabel.setBackground(settingsComposite.getBackground());
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "max-speech-timeout");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 1, 300, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.maxSpeechTimeoutSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.maxSpeechTimeoutSpinner.setSelection(value == null || value.equals("") ? 10 : Integer.parseInt(value));
                }
            });
        }
        Label confidenceLevelLabel = this.createPropertyLabel(settingsComposite, "Minimum Confidence Level Accepted");
        confidenceLevelLabel.setBackground(settingsComposite.getBackground());
        confidenceLevelLabel.setToolTipText("The minimum level of confidence accepted\r\nby the speech recognition provider.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "confidence-level");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.confidenceLevelSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.confidenceLevelSpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.confidenceLevelSpinner.setSelection(value == null || value.equals("") ? 50 : Integer.parseInt(value));
                }
            });
        }
        Label sensitivityLabel = this.createPropertyLabel(settingsComposite, "Typical Caller Environment");
        sensitivityLabel.setBackground(settingsComposite.getBackground());
        sensitivityLabel.setToolTipText("Determines how sensitive the speech recognition\r\nwill be to background noise.  The lower the number,\r\nthe less senitive the system will be");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "sensitivity-level");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.sensitivitySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.sensitivitySpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.sensitivitySpinner.setSelection(value == null || value.equals("") ? 50 : Integer.parseInt(value));
                }
            });
        }
        Label speedVsAccuracyLabel = this.createPropertyLabel(settingsComposite, "Speed Vs Accuracy");
        speedVsAccuracyLabel.setBackground(settingsComposite.getBackground());
        speedVsAccuracyLabel.setToolTipText("A hint to the speech recognition platform indicating\r\nrelative focus between the speed in which the result\r\nis returned and the accuracy of that result.  The\r\nlower the number, the faster the entry is processed\r\nbut accuracy may be reduced.");
        containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "speed-vs-accuracy");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.speedVsAccuracySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return Integer.toString(OptionSetMediaDefaultsPanel.this.speedVsAccuracySpinner.getSelection());
                }

                public void setValue(String value) {
                    OptionSetMediaDefaultsPanel.this.speedVsAccuracySpinner.setSelection(value == null || value.equals("") ? 50 : Integer.parseInt(value));
                }
            });
        }
        return settingsComposite;
    }

    public String getTitle() {
        return "Option Set";
    }

    public void save() {
        if (this.settings.inheritanceSupported()) {
            for (DefaultValueStack dvs : this.valueStacks) {
                dvs.save();
            }
        } else {
            this.settings.getDefaultSetting(interactionType, elementType, "input-mode").setValue(this.inputModeCombo.getItem(this.inputModeCombo.getSelectionIndex()));
            this.settings.getDefaultSetting(interactionType, elementType, "barge-in").setValue(this.barginCombo.getItem(this.barginCombo.getSelectionIndex()));
            this.settings.getDefaultSetting(interactionType, elementType, "initial-timeout").setValue(Integer.toString(this.initialTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "interdigit-timeout").setValue(Integer.toString(this.interdigitTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "termination-timeout").setValue(Integer.toString(this.terminationTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "speech-incomplete-timeout").setValue(Integer.toString(this.speechIncompleteTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "speech-complete-timeout").setValue(Integer.toString(this.speechCompleteTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "max-speech-timeout").setValue(Integer.toString(this.maxSpeechTimeoutSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "confidence-level").setValue(Integer.toString(this.confidenceLevelSpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "sensitivity-level").setValue(Integer.toString(this.sensitivitySpinner.getSelection()));
            this.settings.getDefaultSetting(interactionType, elementType, "speed-vs-accuracy").setValue(Integer.toString(this.speedVsAccuracySpinner.getSelection()));
        }
    }

    public void setDefaultSettings(IMediaDefaultSettings defaultSettings) {
        this.settings = defaultSettings;
        if (this.settings.inheritanceSupported()) {
            for (DefaultValueStack dvs : this.valueStacks) {
                dvs.setSetting(this.settings);
            }
        } else {
            if (this.inputModeCombo != null) {
                String inputMode = this.settings.getDefaultSetting(interactionType, elementType, "input-mode").getValue();
                if (inputMode == null) {
                    this.inputModeCombo.select(0);
                } else if ("Dtmf Only".equals(inputMode)) {
                    this.inputModeCombo.select(0);
                } else if ("Voice Only".equals(inputMode)) {
                    this.inputModeCombo.select(1);
                } else if ("Hybrid".equals(inputMode)) {
                    this.inputModeCombo.select(2);
                } else {
                    this.inputModeCombo.select(0);
                }
            }
            if (this.barginCombo != null) {
                String bargein = this.settings.getDefaultSetting(interactionType, elementType, "barge-in").getValue();
                if (bargein == null) {
                    this.barginCombo.select(0);
                } else if ("true".equals(bargein)) {
                    this.barginCombo.select(0);
                } else if ("false".equals(bargein)) {
                    this.barginCombo.select(1);
                } else {
                    this.barginCombo.select(0);
                }
            }
            if (this.initialTimeoutSpinner != null) {
                String initialTimeout = this.settings.getDefaultSetting(interactionType, elementType, "initial-timeout").getValue();
                this.initialTimeoutSpinner.setSelection(initialTimeout == null || initialTimeout.equals("") ? 3 : Integer.parseInt(initialTimeout));
            }
            if (this.interdigitTimeoutSpinner != null) {
                String interdigitTimeout = this.settings.getDefaultSetting(interactionType, elementType, "interdigit-timeout").getValue();
                this.interdigitTimeoutSpinner.setSelection(interdigitTimeout == null || interdigitTimeout.equals("") ? 2 : Integer.parseInt(interdigitTimeout));
            }
            if (this.terminationTimeoutSpinner != null) {
                String terminationTimeout = this.settings.getDefaultSetting(interactionType, elementType, "termination-timeout").getValue();
                this.terminationTimeoutSpinner.setSelection(terminationTimeout == null || terminationTimeout.equals("") ? 3 : Integer.parseInt(terminationTimeout));
            }
            if (this.speechIncompleteTimeoutSpinner != null) {
                String speechIncompleteTimeout = this.settings.getDefaultSetting(interactionType, elementType, "speech-incomplete-timeout").getValue();
                this.speechIncompleteTimeoutSpinner.setSelection(speechIncompleteTimeout == null || speechIncompleteTimeout.equals("") ? 3 : Integer.parseInt(speechIncompleteTimeout));
            }
            if (this.speechCompleteTimeoutSpinner != null) {
                String speechCompleteTimeout = this.settings.getDefaultSetting(interactionType, elementType, "speech-complete-timeout").getValue();
                this.speechCompleteTimeoutSpinner.setSelection(speechCompleteTimeout == null || speechCompleteTimeout.equals("") ? 3 : Integer.parseInt(speechCompleteTimeout));
            }
            if (this.maxSpeechTimeoutSpinner != null) {
                String maxSpeechTimeout = this.settings.getDefaultSetting(interactionType, elementType, "max-speech-timeout").getValue();
                this.maxSpeechTimeoutSpinner.setSelection(maxSpeechTimeout == null || maxSpeechTimeout.equals("") ? 10 : Integer.parseInt(maxSpeechTimeout));
            }
            if (this.confidenceLevelSpinner != null) {
                String confidenceLevel = this.settings.getDefaultSetting(interactionType, elementType, "confidence-level").getValue();
                this.confidenceLevelSpinner.setSelection(confidenceLevel == null || confidenceLevel.equals("") ? 50 : Integer.parseInt(confidenceLevel));
            }
            if (this.sensitivitySpinner != null) {
                String sensitivity = this.settings.getDefaultSetting(interactionType, elementType, "sensitivity-level").getValue();
                this.sensitivitySpinner.setSelection(sensitivity == null || sensitivity.equals("") ? 50 : Integer.parseInt(sensitivity));
            }
            if (this.speedVsAccuracySpinner != null) {
                String speedVsAccuracy = this.settings.getDefaultSetting(interactionType, elementType, "speed-vs-accuracy").getValue();
                this.speedVsAccuracySpinner.setSelection(speedVsAccuracy == null || speedVsAccuracy.equals("") ? 50 : Integer.parseInt(speedVsAccuracy));
            }
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

