/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.media.core.GrammarBindingViewer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.media.core.ValueStack;
import org.eclipse.vtp.desktop.media.core.ValueStackListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;

public class QuestionMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    private static final String elementType = "org.eclipse.vtp.modules.interactive.question";
    PromptBindingViewer promptViewer;
    GrammarBindingViewer dtmfGrammarViewer;
    GrammarBindingViewer voiceGrammarViewer;
    private FormToolkit toolkit;
    GenericBindingManager bindingManager;
    InteractionBinding interactionBinding = null;
    List<Control> dtmfWidgets = new ArrayList<Control>();
    List<Control> voiceWidgets = new ArrayList<Control>();
    Composite comp = null;
    ScrolledComposite sc = null;
    Map<String, ValueStack> valueStacks = new HashMap<String, ValueStack>();
    String currentLanguage = null;
    IBrand currentBrand = null;

    public QuestionMediaScreen(MediaConfigurationScreenContainer container) {
        super(container);
        IDesignElement element = this.getElement();
        this.bindingManager = (GenericBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.generic");
        this.interactionBinding = this.bindingManager.getInteractionBinding(this.getInteractionType());
        NamedBinding promptBinding = this.interactionBinding.getNamedBinding("Prompt");
        this.promptViewer = new PromptBindingViewer(this.getElement(), promptBinding, this.getInteractionType(), this.getElement().getDesign().getVariablesFor(element));
        NamedBinding dtmfGrammarBinding = this.interactionBinding.getNamedBinding("Grammar");
        this.dtmfGrammarViewer = new GrammarBindingViewer(element, dtmfGrammarBinding, this.getInteractionType());
        NamedBinding voiceGrammarBinding = this.interactionBinding.getNamedBinding("Voice-Grammar");
        this.voiceGrammarViewer = new GrammarBindingViewer(element, voiceGrammarBinding, this.getInteractionType());
    }

    public void save() {
        for (ValueStack dvs : this.valueStacks.values()) {
            dvs.save();
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        GridData gd;
        GridData gd2;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(30);
        this.sc.getVerticalBar().setPageIncrement(275);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        Composite mediaComposite = new Composite(this.comp, 0);
        mediaComposite.setBackground(this.comp.getBackground());
        mediaComposite.setLayoutData((Object)new GridData(768));
        mediaComposite.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = this.toolkit.createSection(mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Media");
        Label promptLabel = this.createPropertyLabel(mediaComposite, "Prompt:");
        Composite containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.promptViewer.createControls(containerComp);
        this.promptViewer.addListener((PromptBindingViewerListener)this);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.promptViewer.getControl().setLayoutData((Object)gridData);
        Label grammarLabel = this.createPropertyLabel(mediaComposite, "DTMF Grammar:");
        containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.dtmfGrammarViewer.createControls(containerComp);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.dtmfGrammarViewer.getControl().setLayoutData((Object)gridData);
        this.dtmfWidgets.add((Control)grammarLabel);
        this.dtmfWidgets.add((Control)containerComp);
        Label voiceGrammarLabel = this.createPropertyLabel(mediaComposite, "Voice Grammar:");
        containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.voiceGrammarViewer.createControls(containerComp);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.voiceGrammarViewer.getControl().setLayoutData((Object)gridData);
        this.voiceWidgets.add((Control)voiceGrammarLabel);
        this.voiceWidgets.add((Control)containerComp);
        Composite spacerComp = new Composite(mediaComposite, 0);
        spacerComp.setBackground(mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label inputModeLabel = this.createPropertyLabel(settingsComposite, "User Input Style");
        inputModeLabel.setToolTipText("This property selects the valid ways\r\na caller can provide input:\r\n\t*DTMF - Touchtone keypad only\t*Voice - Speech recognition only\t*Hybrid - Touchtone or speech accepted");
        containerComp = this.createWrapperComposite(settingsComposite);
        ValueStack lastStack = new ValueStack("input-mode", this.getInteractionType(), elementType, "Dtmf Only", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("input-mode", lastStack);
        final Combo inputModeCombo = this.createValueDropDown(containerComp);
        inputModeCombo.add("Dtmf Only");
        inputModeCombo.add("Voice Only");
        inputModeCombo.add("Hybrid");
        inputModeCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return inputModeCombo.getItem(inputModeCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    inputModeCombo.select(0);
                } else if ("Voice Only".equals(value)) {
                    inputModeCombo.select(1);
                } else if ("Hybrid".equals(value)) {
                    inputModeCombo.select(2);
                } else {
                    inputModeCombo.select(0);
                }
                QuestionMediaScreen.this.updateInputMode();
            }
        });
        lastStack.addListener(new ValueStackListener(){

            public void valueTypeChanged(ValueStack valueStack) {
                QuestionMediaScreen.this.updateInputMode();
            }
        });
        inputModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QuestionMediaScreen.this.updateInputMode();
            }
        });
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("barge-in", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("barge-in", lastStack);
        final Combo barginCombo = this.createValueDropDown(containerComp);
        barginCombo.add("true");
        barginCombo.add("false");
        barginCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return barginCombo.getItem(barginCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    barginCombo.select(0);
                } else if ("true".equals(value)) {
                    barginCombo.select(0);
                } else if ("false".equals(value)) {
                    barginCombo.select(1);
                } else {
                    barginCombo.select(0);
                }
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("initial-timeout", this.getInteractionType(), elementType, "3", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("initial-timeout", lastStack);
        final Spinner initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(initialTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                initialTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label interdigitTimeoutLabel = this.createPropertyLabel(settingsComposite, "Interdigit Timeout (Seconds)");
        interdigitTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional touchtone if the current\r\ninput does not match the grammar before\r\na NoMatch event.");
        this.dtmfWidgets.add((Control)interdigitTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add((Control)containerComp);
        lastStack = new ValueStack("interdigit-timeout", this.getInteractionType(), elementType, "2", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("interdigit-timeout", lastStack);
        final Spinner interdigitTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(interdigitTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                interdigitTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        this.dtmfWidgets.add((Control)terminationTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add((Control)containerComp);
        lastStack = new ValueStack("termination-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("termination-timeout", lastStack);
        final Spinner terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(terminationTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                terminationTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label terminationCharacterLabel = this.createPropertyLabel(settingsComposite, "Termination Character");
        terminationCharacterLabel.setToolTipText("An option touchtone key that can be used\r\nto indicate the caller has reached the end\r\nof their input.");
        this.dtmfWidgets.add((Control)terminationCharacterLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add((Control)containerComp);
        lastStack = new ValueStack("termination-character", this.getInteractionType(), elementType, "#", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("termination-character", lastStack);
        final Combo terminationCharacterCombo = this.createValueDropDown(containerComp);
        terminationCharacterCombo.add("#");
        terminationCharacterCombo.add("0");
        terminationCharacterCombo.add("1");
        terminationCharacterCombo.add("2");
        terminationCharacterCombo.add("3");
        terminationCharacterCombo.add("4");
        terminationCharacterCombo.add("5");
        terminationCharacterCombo.add("6");
        terminationCharacterCombo.add("7");
        terminationCharacterCombo.add("8");
        terminationCharacterCombo.add("9");
        terminationCharacterCombo.add("*");
        terminationCharacterCombo.add("None");
        terminationCharacterCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return terminationCharacterCombo.getItem(terminationCharacterCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                boolean found = false;
                String[] items = terminationCharacterCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(value)) {
                        terminationCharacterCombo.select(i);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    terminationCharacterCombo.select(0);
                }
            }
        });
        Label speechIncompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Incomplete Timeout (Seconds)");
        speechIncompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\ndoes not match the provided grammar.");
        this.voiceWidgets.add((Control)speechIncompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speech-incomplete-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speech-incomplete-timeout", lastStack);
        final Spinner speechIncompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speechIncompleteTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                speechIncompleteTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label speechCompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Completion Timeout (Seconds)");
        speechCompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\nalready matches the provided grammar.");
        this.voiceWidgets.add((Control)speechCompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speech-complete-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speech-complete-timeout", lastStack);
        final Spinner speechCompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speechCompleteTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                speechCompleteTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Speech Length (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        this.voiceWidgets.add((Control)maxSpeechTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("max-speech-timeout", this.getInteractionType(), elementType, "300", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("max-speech-timeout", lastStack);
        final Spinner maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 300, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(maxSpeechTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label confidenceLevelLabel = this.createPropertyLabel(settingsComposite, "Minimum Confidence Level Accepted");
        confidenceLevelLabel.setToolTipText("The minimum level of confidence accepted\r\nby the speech recognition provider.");
        this.voiceWidgets.add((Control)confidenceLevelLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("confidence-level", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("confidence-level", lastStack);
        final Spinner confidenceLevelSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(confidenceLevelSpinner.getSelection());
            }

            public void setValue(String value) {
                confidenceLevelSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label sensitivityLabel = this.createPropertyLabel(settingsComposite, "Typical Caller Environment");
        sensitivityLabel.setToolTipText("Determines how sensitive the speech recognition\r\nwill be to background noise.  The lower the number,\r\nthe less senitive the system will be");
        this.voiceWidgets.add((Control)sensitivityLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("sensitivity-level", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("sensitivity-level", lastStack);
        final Spinner sensitivitySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(sensitivitySpinner.getSelection());
            }

            public void setValue(String value) {
                sensitivitySpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label speedVsAccuracyLabel = this.createPropertyLabel(settingsComposite, "Speed Vs Accuracy");
        speedVsAccuracyLabel.setToolTipText("A hint to the speech recognition platform indicating\r\nrelative focus between the speed in which the result\r\nis returned and the accuracy of that result.  The\r\nlower the number, the faster the entry is processed\r\nbut accuracy may be reduced.");
        this.voiceWidgets.add((Control)speedVsAccuracyLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speed-vs-accuracy", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speed-vs-accuracy", lastStack);
        final Spinner speedVsAccuracySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speedVsAccuracySpinner.getSelection());
            }

            public void setValue(String value) {
                speedVsAccuracySpinner.setSelection(Integer.parseInt(value));
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                QuestionMediaScreen.this.comp.removeControlListener((ControlListener)this);
                QuestionMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = QuestionMediaScreen.this.sc.getClientArea();
                QuestionMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (QuestionMediaScreen.this.sc.getVerticalBar() != null) {
                    QuestionMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                QuestionMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                QuestionMediaScreen.this.sc.layout(true, true);
                QuestionMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentLanguage(language);
        }
        if (this.dtmfGrammarViewer != null) {
            this.dtmfGrammarViewer.setCurrentLanguage(language);
        }
        if (this.voiceGrammarViewer != null) {
            this.voiceGrammarViewer.setCurrentLanguage(language);
        }
        if (this.currentBrand != null) {
            this.setContents();
        }
    }

    public void setBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentBrand(brand);
        }
        if (this.dtmfGrammarViewer != null) {
            this.dtmfGrammarViewer.setCurrentBrand(brand);
        }
        if (this.voiceGrammarViewer != null) {
            this.voiceGrammarViewer.setCurrentBrand(brand);
        }
        if (this.currentLanguage != null) {
            this.setContents();
        }
    }

    public void setContents() {
        NamedBinding namedBinding = this.interactionBinding.getNamedBinding("input-mode");
        LanguageBinding languageBinding = namedBinding.getLanguageBinding("");
        BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        ValueStack valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("barge-in");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("initial-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("interdigit-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("termination-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("termination-character");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("speech-incomplete-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("speech-complete-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("max-speech-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("confidence-level");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("sensitivity-level");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("speed-vs-accuracy");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
    }

    public void updateInputMode() {
        GridData gd;
        GridData gd2;
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        String sel = this.valueStacks.get("input-mode").getValue();
        if (sel.equals("Hybrid") || sel.equals("Dtmf Only")) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel.equals("Hybrid") || sel.equals("Voice Only")) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
        this.comp.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QuestionMediaScreen.this.comp.layout(true, true);
            }
        });
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public void valueChanged(PromptBindingViewer viewer) {
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
    }

    public void invalidConfigurationAttempt(PromptBindingViewer viewer) {
        this.getContainer().cancelMediaConfiguration();
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

