/*--------------------------------------------------------------------------
 * Copyright (c) 2004, 2006-2007 OpenMethods, LLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Trip Gilman (OpenMethods), Lonnie G. Pryor (OpenMethods)
 *    - initial API and implementation
 -------------------------------------------------------------------------*/
package org.eclipse.vtp.desktop.model.core.internal.event;


/**
 * This is the base class for all events generated by the
 * OpenVXML project object model.
 *
 * @author Trip Gilman
 * @version 2.0
 */
public class ObjectEvent
{
	/**
	 * The unique identifier for the source of the event.
	 */
	protected final String objectId;

	/**
	 * The timestamp of when the event was created.
	 */
	protected final long time;

	/**
	 * Creates a new <code>ObjectEvent</code> with the given
	 * object id.  The timestamp is automatically set upon
	 * creation.
	 *
	 * @param objectId The unique identifier of the source object
	 */
	public ObjectEvent(String objectId)
	{
		super();
		this.objectId = objectId;
		this.time = System.currentTimeMillis();
	}

	/**
	 * @return The unique identifier of the source object
	 */
	public String getObjectId()
	{
		return objectId;
	}

	/**
	 * @return The timestamp of the creation of this event
	 */
	public long getTime()
	{
		return time;
	}
}
