/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FieldType {
    public static final FieldType STRING = new FieldType(Primitive.STRING);
    public static final FieldType NUMBER = new FieldType(Primitive.NUMBER);
    public static final FieldType DECIMAL = new FieldType(Primitive.DECIMAL);
    public static final FieldType BOOLEAN = new FieldType(Primitive.BOOLEAN);
    public static final FieldType DATETIME = new FieldType(Primitive.DATETIME);
    public static final int SINGLE = 0;
    public static final int DOUBLE = 1;
    public static final int ABSOLUTE = 2;
    private Primitive primitiveType;
    private IBusinessObject objectType;
    private Primitive primitiveBaseType;
    private IBusinessObject objectBaseType;
    private int precision;

    public FieldType(Primitive type) {
        this.primitiveType = type;
        this.precision = 0;
    }

    public FieldType(IBusinessObject type) {
        this.objectType = type;
    }

    public FieldType(Primitive type, Primitive baseType) {
        if (!type.isMainType()) {
            throw new IllegalArgumentException("Only arrays and maps can have a base type.");
        }
        if (!baseType.isBaseType()) {
            throw new IllegalArgumentException("Arrays and Maps cannot explictly contain other arrays or maps.  Use the wildcard type as the base type instead.");
        }
        this.primitiveType = type;
        this.primitiveBaseType = baseType;
    }

    public FieldType(Primitive type, IBusinessObject baseType) {
        if (!type.isMainType()) {
            throw new IllegalArgumentException("Only arrays and maps can have a base type.");
        }
        this.primitiveType = type;
        this.objectBaseType = baseType;
    }

    public String getName() {
        if (this.primitiveType != null) {
            return this.primitiveType.getName();
        }
        return this.objectType.getName();
    }

    public String getBaseTypeName() {
        if (this.primitiveBaseType != null) {
            return this.primitiveBaseType.getName();
        }
        if (this.objectBaseType != null) {
            return this.objectBaseType.getName();
        }
        return null;
    }

    public boolean hasValue() {
        if (this.primitiveType != null) {
            return this.primitiveType.hasValue();
        }
        return false;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isObject() {
        return this.primitiveType == null;
    }

    public Primitive getPrimitiveType() {
        return this.primitiveType;
    }

    public IBusinessObject getObjectType() {
        return this.objectType;
    }

    public boolean hasBaseType() {
        return this.primitiveType != null && this.primitiveType.hasBaseType();
    }

    public boolean isObjectBaseType() {
        return this.primitiveBaseType == null;
    }

    public Primitive getPrimitiveBaseType() {
        return this.primitiveBaseType;
    }

    public IBusinessObject getObjectBaseType() {
        return this.objectBaseType;
    }

    public void write(Element parent) {
        Element dt = parent.getOwnerDocument().createElement("data-type");
        parent.appendChild(dt);
        if (this.primitiveType != null) {
            dt.setAttribute("type", "primitive:" + this.primitiveType.getName());
            if (this.primitiveType.hasBaseType()) {
                if (this.primitiveBaseType != null) {
                    dt.setAttribute("base-type", "primitive:" + this.primitiveBaseType.getName());
                    if (this.primitiveBaseType.hasPrecision()) {
                        dt.setAttribute("base-precision", Integer.toString(this.getPrecision()));
                    }
                } else {
                    dt.setAttribute("base-type", "object:" + this.objectBaseType.getName());
                }
            }
            if (this.primitiveType.hasPrecision()) {
                dt.setAttribute("precision", Integer.toString(this.getPrecision()));
            }
        } else {
            dt.setAttribute("type", "object:" + this.objectType.getName());
        }
    }

    public static FieldType number(int precision) {
        FieldType ret = new FieldType(Primitive.NUMBER);
        ret.precision = precision;
        return ret;
    }

    public static FieldType numberArray() {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.NUMBER);
        return ret;
    }

    public static FieldType numberArray(int precision) {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.NUMBER);
        ret.precision = precision;
        return ret;
    }

    public static FieldType stringArray() {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.STRING);
        return ret;
    }

    public static FieldType dateTimeArray() {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.DATETIME);
        return ret;
    }

    public static FieldType decimal(int precision) {
        FieldType ret = new FieldType(Primitive.DECIMAL);
        ret.precision = precision;
        return ret;
    }

    public static FieldType decimalArray() {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.DECIMAL);
        return ret;
    }

    public static FieldType decimalArray(int precision) {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.DECIMAL);
        ret.precision = precision;
        return ret;
    }

    public static FieldType booleanArray() {
        FieldType ret = new FieldType(Primitive.ARRAY, Primitive.BOOLEAN);
        return ret;
    }

    public static FieldType load(IBusinessObjectSet objectSet, Element element) {
        if (!element.getTagName().equals("data-type")) {
            throw new IllegalArgumentException("DesignElement Format Exception");
        }
        if (element.getAttributeNode("type") == null) {
            String typeName = null;
            int style = -1;
            int precision = -1;
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 1) {
                    Element child = (Element)nl.item(i);
                    if (child.getTagName().equals("type")) {
                        typeName = XMLUtilities.getElementTextDataNoEx((Element)child, (boolean)true);
                    } else if (child.getTagName().equals("style")) {
                        try {
                            style = Integer.parseInt(child.getAttribute("value"));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    } else if (child.getTagName().equals("precision")) {
                        try {
                            precision = Integer.parseInt(child.getAttribute("value"));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            if (typeName == null || style == -1 || precision == -1) {
                throw new IllegalArgumentException("DesignElement Format Exception");
            }
            FieldType ret = null;
            System.err.println("**************************" + typeName + "***************************");
            Primitive type = Primitive.find(typeName);
            if (type != null) {
                System.err.println("Primitive!");
                ret = (style & 1) == 1 ? new FieldType(Primitive.ARRAY, type) : new FieldType(type);
                if (type.hasPrecision()) {
                    ret.precision = precision;
                }
            } else {
                System.err.println("BusinessObject!");
                IBusinessObject bo = objectSet.getBusinessObject(typeName);
                ret = (style & 1) == 1 ? new FieldType(Primitive.ARRAY, bo) : new FieldType(bo);
            }
            return ret;
        }
        FieldType ret = null;
        int precision = 1;
        String typeName = element.getAttribute("type");
        if (typeName.startsWith("primitive:")) {
            Primitive type = Primitive.find(typeName = typeName.substring(10));
            if (type.hasBaseType()) {
                String baseTypeName = element.getAttribute("base-type");
                if (baseTypeName.startsWith("primitive:")) {
                    baseTypeName = baseTypeName.substring(10);
                    Primitive baseType = Primitive.find(baseTypeName);
                    ret = new FieldType(type, baseType);
                    if (baseType.hasPrecision()) {
                        try {
                            precision = Integer.parseInt(element.getAttribute("precision"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ret.precision = precision;
                    }
                } else {
                    IBusinessObject bo = objectSet.getBusinessObject(baseTypeName = baseTypeName.substring(7));
                    if (bo == null) {
                        throw new RuntimeException("Missing business object definition: " + baseTypeName);
                    }
                    ret = new FieldType(type, bo);
                }
            } else {
                ret = new FieldType(type);
            }
            if (type.hasPrecision()) {
                try {
                    precision = Integer.parseInt(element.getAttribute("precision"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ret.precision = precision;
            }
        } else {
            IBusinessObject bo = objectSet.getBusinessObject(typeName = typeName.substring(7));
            if (bo == null) {
                throw new RuntimeException("Missing business object definition: " + typeName);
            }
            ret = new FieldType(bo);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldType)) {
            return false;
        }
        FieldType type = (FieldType)obj;
        return type.primitiveType == this.primitiveType && type.objectType == this.objectType && type.primitiveBaseType == this.primitiveBaseType && type.objectBaseType == this.objectBaseType;
    }

    public static enum Primitive {
        ANY("ANYTYPE"),
        STRING("String"),
        NUMBER("Number"),
        DECIMAL("Decimal"),
        BOOLEAN("Boolean"),
        DATETIME("DateTime"),
        ARRAY("Array"),
        MAP("Map");

        private String val;

        private Primitive(String val) {
            this.val = val;
        }

        public boolean hasBaseType() {
            switch (this) {
                case ARRAY: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public boolean isMainType() {
            switch (this) {
                case ANY: {
                    return false;
                }
            }
            return true;
        }

        public boolean isBaseType() {
            switch (this) {
                case ARRAY: 
                case MAP: {
                    return false;
                }
            }
            return true;
        }

        public String getName() {
            return this.val;
        }

        public boolean hasPrecision() {
            switch (this) {
                case NUMBER: 
                case DECIMAL: {
                    return true;
                }
            }
            return false;
        }

        public boolean hasValue() {
            switch (this) {
                case STRING: 
                case NUMBER: 
                case DECIMAL: 
                case BOOLEAN: 
                case DATETIME: {
                    return true;
                }
            }
            return false;
        }

        public static Primitive find(String name) {
            Primitive[] primitiveArray = Primitive.values();
            int n = primitiveArray.length;
            int n2 = 0;
            while (n2 < n) {
                Primitive prim = primitiveArray[n2];
                if (prim.getName().equals(name)) {
                    return prim;
                }
                ++n2;
            }
            return null;
        }
    }
}

