/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.configuration;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.osgi.framework.Bundle;

public class ConfigurationManagerRegistry {
    public static final String configurationManagerExtensionId = "org.eclipse.vtp.desktop.model.core.configurationManagers";
    private static final ConfigurationManagerRegistry instance = new ConfigurationManagerRegistry();
    List<ConfigurationManagerRecord> managerRecords = new ArrayList<ConfigurationManagerRecord>();

    public static ConfigurationManagerRegistry getInstance() {
        return instance;
    }

    public ConfigurationManagerRegistry() {
        IConfigurationElement[] managerExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerExtensionId);
        int i = 0;
        while (i < managerExtensions.length) {
            String managerId = managerExtensions[i].getAttribute("id");
            String namespace = managerExtensions[i].getAttribute("xml-namespace");
            String element = managerExtensions[i].getAttribute("xml-tag");
            String className = managerExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)managerExtensions[i].getContributor().getName());
            try {
                Class managerClass = contributor.loadClass(className);
                ConfigurationManagerRecord cmr = new ConfigurationManagerRecord(managerId, namespace, element, managerClass);
                this.managerRecords.add(cmr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public ConfigurationManager getConfigurationManager(IDesign design, String managerId) {
        int i = 0;
        while (i < this.managerRecords.size()) {
            ConfigurationManagerRecord cmr = this.managerRecords.get(i);
            if (cmr.getManagerId().equals(managerId)) {
                return cmr.getManagerInstance(design);
            }
            ++i;
        }
        return null;
    }

    public String convertLegacyXMLtoId(String namespace, String element) {
        int i = 0;
        while (i < this.managerRecords.size()) {
            ConfigurationManagerRecord cmr = this.managerRecords.get(i);
            if (element.equals(cmr.getElement()) && namespace.equals(cmr.getNamespace())) {
                return cmr.managerId;
            }
            ++i;
        }
        return null;
    }

    private class ConfigurationManagerRecord {
        private String managerId;
        private String namespace;
        private String element;
        private Class<ConfigurationManager> managerClass;
        private Constructor<ConfigurationManager> constructor = null;

        public ConfigurationManagerRecord(String managerId, String namespace, String element, Class<ConfigurationManager> managerClass) throws Exception {
            this.managerId = managerId;
            this.namespace = namespace;
            this.element = element;
            this.managerClass = managerClass;
            this.constructor = managerClass.getConstructor(IDesign.class);
        }

        public String getManagerId() {
            return this.managerId;
        }

        public String getElement() {
            return this.element;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ConfigurationManager getManagerInstance(IDesign design) {
            try {
                return this.constructor.newInstance(design);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

