/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObject;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowProject;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.framework.util.Guid;

public class BusinessObjectSet
extends WorkflowResource
implements IBusinessObjectSet,
IResourceChangeListener {
    private static String businessObjectTemplate = "<business-object id=\"[id]\" name=\"[name]\">\t<fields></fields></business-object>";
    private WorkflowProject project;
    private IFolder folder;
    private List<BusinessObject> currentObjects = new ArrayList<BusinessObject>();

    public BusinessObjectSet(WorkflowProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.activateEvents();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public IWorkflowResource getParent() {
        return this.project;
    }

    @Override
    public IBusinessObject getBusinessObject(String typeName) {
        List<IBusinessObject> businessObjects = this.getBusinessObjects();
        for (IBusinessObject businessObject : businessObjects) {
            if (!businessObject.getName().equals(typeName)) continue;
            return businessObject;
        }
        return null;
    }

    @Override
    public synchronized List<IBusinessObject> getBusinessObjects() {
        ArrayList<IBusinessObject> ret = new ArrayList<IBusinessObject>();
        if (this.currentObjects.isEmpty()) {
            try {
                IResource[] res = this.folder.members();
                int i = 0;
                while (i < res.length) {
                    if (res[i] instanceof IFile) {
                        BusinessObject bo = new BusinessObject(this, (IFile)res[i]);
                        this.currentObjects.add(bo);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            for (BusinessObject bo : this.currentObjects) {
                bo.loadModel();
            }
        }
        for (BusinessObject bo : this.currentObjects) {
            ret.add(bo);
        }
        return ret;
    }

    @Override
    public IBusinessObject createBusinessObject(String name) throws CoreException {
        IFile objectFile = this.folder.getFile(String.valueOf(name) + ".dod");
        if (objectFile.exists()) {
            throw new IllegalArgumentException("Business Object with that name already exists: " + name);
        }
        String template = new String(businessObjectTemplate);
        template = template.replaceAll("\\[id\\]", Guid.createGUID());
        template = template.replaceAll("\\[name\\]", name);
        objectFile.create((InputStream)new ByteArrayInputStream(template.getBytes()), true, null);
        BusinessObject bo = new BusinessObject(this, objectFile);
        this.refresh();
        return bo;
    }

    @Override
    public void deleteBusinessObject(IBusinessObject businessObject) throws CoreException {
        businessObject.getUnderlyingFile().delete(true, null);
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        if (BusinessObjectSet.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        return new LinkedList<IWorkflowResource>(this.getBusinessObjects());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BusinessObjectSet) {
            return this.folder.equals(((BusinessObjectSet)obj).getAdapter(IFolder.class));
        }
        return false;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.currentObjects.clear();
    }
}

