/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IDependency;
import org.eclipse.vtp.desktop.model.core.internal.DependencySet;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;

public class Dependency
extends WorkflowResource
implements IDependency {
    private static final String HASHPREFIX = "Dependency";
    private final DependencySet parent;
    private final IFile file;

    public Dependency(DependencySet parent, IFile file) {
        this.parent = parent;
        this.file = file;
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public DependencySet getParent() {
        return this.parent;
    }

    @Override
    public void delete() throws CoreException {
        this.parent.removeDependency(this);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.file.getClass())) {
            return this.file;
        }
        if (Dependency.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dependency) {
            return this.file.equals((Object)((Dependency)obj).file);
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.file.toString()).hashCode();
    }
}

