/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignDocumentListener;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.IWorkflowReference;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignExitPoint;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.DesignParser;
import org.eclipse.vtp.desktop.model.core.internal.DesignWriter;
import org.eclipse.vtp.desktop.model.core.internal.PartialDesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndex;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndexService;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignConnector;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignTraversalHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementResolutionVisitor;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DesignDocument
extends WorkflowResource
implements IDesignDocument,
ElementResolutionVisitor {
    private static final String HASHPREFIX = "DesignDocument";
    private IDesignItemContainer parent = null;
    private IFile file = null;
    private boolean isWorking = false;
    private boolean externalReferencesFollowed = false;
    private List<Design> dialogs = new LinkedList<Design>();
    private Design mainDesign = null;
    private List<IDesignDocumentListener> listeners = new LinkedList<IDesignDocumentListener>();

    public DesignDocument(IDesignItemContainer container, IFile file) {
        this.parent = container;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IWorkflowResource getParent() {
        return this.parent;
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public IDesignItemContainer getParentDesignContainer() {
        return this.parent;
    }

    @Override
    public IFile getUnderlyingFile() {
        return this.file;
    }

    @Override
    public synchronized boolean isWorkingCopy() {
        return this.isWorking;
    }

    @Override
    public void becomeWorkingCopy() {
        this.becomeWorkingCopy(true);
    }

    @Override
    public synchronized void becomeWorkingCopy(boolean followExternalReferences) {
        if (!this.isWorking || followExternalReferences != this.externalReferencesFollowed) {
            this.externalReferencesFollowed = followExternalReferences;
            this.isWorking = true;
            this.mainDesign = null;
            this.dialogs.clear();
            DesignParser designParser = new DesignParser();
            try {
                NodeList mainList;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(this.file.getContents());
                Element rootElement = document.getDocumentElement();
                NodeList dialogsList = rootElement.getElementsByTagName("dialogs");
                if (dialogsList.getLength() > 0) {
                    NodeList dialogList = ((Element)dialogsList.item(0)).getElementsByTagName("workflow");
                    int i = 0;
                    while (i < dialogList.getLength()) {
                        Element dialogElement = (Element)dialogList.item(i);
                        this.dialogs.add(designParser.parseDesign(this, dialogElement, null, followExternalReferences));
                        ++i;
                    }
                }
                if ((mainList = rootElement.getElementsByTagName("workflow")).getLength() > 0) {
                    Element mainElement = (Element)mainList.item(0);
                    this.mainDesign = designParser.parseDesign(this, mainElement, this, followExternalReferences);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void commitWorkingCopy() throws Exception {
        DesignWriter writer = new DesignWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.getDOMImplementation().createDocument(null, "design-document", null);
        Element rootElement = document.getDocumentElement();
        rootElement.setAttribute("xml-version", "4.0.0");
        writer.writeDesign(rootElement, this.mainDesign);
        Element dialogsElement = rootElement.getOwnerDocument().createElement("dialogs");
        rootElement.appendChild(dialogsElement);
        for (IDesign dialogDesign : this.getDialogDesigns()) {
            writer.writeDesign(dialogsElement, (Design)dialogDesign);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory transfactory = TransformerFactory.newInstance();
        Transformer t = transfactory.newTransformer();
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("encoding", "UTF-8");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        t.transform(new DOMSource(document), new XMLWriter((OutputStream)baos).toXMLResult());
        this.file.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
    }

    public synchronized boolean canMergeAll(IDesign target, PartialDesignDocument partialDocument) {
        if (!this.mainDesign.equals(target) && !this.dialogs.contains(target)) {
            System.err.println("trying to merge into design not in this document");
            return false;
        }
        IDesign mergeMain = partialDocument.getMainDesign();
        List<IDesignElement> mergeElements = mergeMain.getDesignElements();
        for (IDesignElement mergeElement : mergeElements) {
            if (mergeElement.canBeContainedBy(target)) continue;
            return false;
        }
        return true;
    }

    public synchronized void merge(IDesign target, PartialDesignDocument partialDocument) {
        this.merge(target, partialDocument, true);
    }

    public synchronized void merge(IDesign target, PartialDesignDocument partialDocument, boolean overrideIds) {
        try {
            System.out.println("merging partial document: " + partialDocument);
            if (!this.mainDesign.equals(target) && !this.dialogs.contains(target)) {
                System.err.println("trying to merge into design not in this document");
                return;
            }
            if (overrideIds) {
                partialDocument.forceNewIds();
            }
            if (this.mainDesign.equals(target)) {
                List<IDesign> mergeDialogs = partialDocument.getDialogDesigns();
                for (IDesign mergeDialog : mergeDialogs) {
                    Design md = (Design)mergeDialog;
                    this.dialogs.add(md);
                    md.setDocument(this);
                    for (IDesignDocumentListener iDesignDocumentListener : this.listeners) {
                        iDesignDocumentListener.dialogDesignAdded(this, md);
                    }
                }
            } else {
                partialDocument.removeAllDialogs();
            }
            IDesign mergeMain = partialDocument.getMainDesign();
            List<IDesignElement> mergeElements = mergeMain.getDesignElements();
            System.out.println("merging " + mergeElements.size() + " elements");
            LinkedList<IDesignElement> droppedElements = new LinkedList<IDesignElement>();
            for (IDesignElement mergeElement : mergeElements) {
                System.out.println("processing element: [" + mergeElement.getId() + "] " + mergeElement.getName());
                if (mergeElement.canBeContainedBy(target)) {
                    System.out.println("adding to target design");
                    target.addDesignElement(mergeElement);
                    continue;
                }
                System.out.println("skipping element as it cannot be contained by target design");
                droppedElements.add(mergeElement);
            }
            LinkedList<IDesignConnector> droppedConnectors = new LinkedList<IDesignConnector>();
            for (IDesignConnector iDesignConnector : mergeMain.getDesignConnectors()) {
                IDesignElement source = null;
                IDesignElement dest = null;
                for (IDesignElement element : target.getDesignElements()) {
                    if (element.getId().equals(iDesignConnector.getOrigin().getId())) {
                        source = element;
                    }
                    if (element.getId().equals(iDesignConnector.getDestination().getId())) {
                        dest = element;
                    }
                    if (source != null && dest != null) break;
                }
                if (source != null && dest != null) {
                    ((Design)target).addDesignConnector((DesignConnector)iDesignConnector);
                    continue;
                }
                droppedConnectors.add(iDesignConnector);
            }
            for (IDesignElement iDesignElement : droppedElements) {
                partialDocument.getMainDesign().removeDesignElement(iDesignElement);
            }
            for (IDesignConnector iDesignConnector : droppedConnectors) {
                partialDocument.getMainDesign().removeDesignConnector(iDesignConnector);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reverse(IDesign target, PartialDesignDocument partialDocument) {
        if (!this.mainDesign.equals(target) && !this.dialogs.contains(target)) {
            System.err.println("trying to merge into design not in this document");
            return;
        }
        for (IDesignConnector remConnector : partialDocument.getMainDesign().getDesignConnectors()) {
            System.out.println("processing connector: [" + remConnector.getId() + "]");
            IDesignConnector rc = target.getDesignConnector(remConnector.getId());
            target.removeDesignConnector(rc);
        }
        for (IDesignElement targetElement : target.getDesignElements()) {
            System.out.println("target element: [" + targetElement.getId() + "] " + targetElement.getName());
        }
        for (IDesignElement remElement : partialDocument.getMainDesign().getDesignElements()) {
            System.out.println("processing element: [" + remElement.getId() + "] " + remElement.getName());
            IDesignElement re = target.getDesignElement(remElement.getId());
            System.out.println("found element: [" + re.getId() + "] " + re.getName());
            target.removeDesignElement(re);
        }
        for (IDesign dialogDesign : partialDocument.getDialogDesigns()) {
            this.removeDialogDesign(dialogDesign.getDesignId());
        }
    }

    @Override
    public synchronized void restoreWorkingCopy() {
    }

    @Override
    public synchronized void discardWorkingCopy() {
    }

    @Override
    public Image getDesignThumbnail(String designId) {
        File workingPath = this.file.getProject().getWorkingLocation("org.eclipse.vtp.model.core").toFile();
        File iconPath = new File(workingPath, this.file.getProjectRelativePath().toString());
        File iconFile = new File(iconPath, String.valueOf(designId) + ".jpg");
        if (iconFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(iconFile);
                Image icon = new Image((Device)Display.getCurrent(), (InputStream)fis);
                fis.close();
                return icon;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IDesign getMainDesign() {
        return this.mainDesign;
    }

    @Override
    public List<IDesign> getDialogDesigns() {
        return new LinkedList<IDesign>(this.dialogs);
    }

    @Override
    public IDesign addDialogDesign(String id, URL templateURL) {
        DesignParser designParser = new DesignParser();
        Design dialogDesign = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(templateURL.openStream());
            Element rootElement = document.getDocumentElement();
            NodeList mainList = rootElement.getElementsByTagName("workflow");
            if (mainList.getLength() > 0) {
                Element mainElement = (Element)mainList.item(0);
                dialogDesign = designParser.parseDesign(this, mainElement, this, true);
                dialogDesign.setDesignId(id);
                this.dialogs.add(dialogDesign);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (IDesignDocumentListener listener : this.listeners) {
            listener.dialogDesignAdded(this, dialogDesign);
        }
        return dialogDesign;
    }

    public void removeDialogDesign(String id) {
        int i = 0;
        while (i < this.dialogs.size()) {
            if (this.dialogs.get(i).getDesignId().equals(id)) {
                this.dialogs.remove(i);
                break;
            }
            ++i;
        }
        for (IDesignDocumentListener listener : this.listeners) {
            listener.dialogDesignRemoved(this, id);
        }
    }

    @Override
    public IDesign getDialogDesign(String id) {
        for (Design dialog : this.dialogs) {
            if (!dialog.getDesignId().equals(id)) continue;
            return dialog;
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.file.getClass())) {
            return this.file;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DesignDocument) {
            return this.file.equals((Object)((DesignDocument)obj).getUnderlyingFile());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.file.toString()).hashCode();
    }

    @Override
    public void resolveElement(DesignElement element) {
    }

    @Override
    public List<IDesignEntryPoint> getDesignEntryPoints() {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDesignElements(this.mainDesign, IDesignEntryPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDesignEntries(this);
    }

    @Override
    public List<IDesignEntryPoint> getUpStreamDesignEntries(IWorkflowExit workflowExit) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getUpStreamDesignElements((IDesignElement)workflowExit.getAdapter(IDesignElement.class), IDesignEntryPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getUpstreamDesignEntries((IDesignDocument)this, workflowExit);
    }

    @Override
    public List<IDesignEntryPoint> getUpStreamDesignEntries(IDesignExitPoint designExit) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getUpStreamDesignElements((IDesignElement)designExit.getAdapter(IDesignElement.class), IDesignEntryPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getUpstreamDesignEntries((IDesignDocument)this, designExit);
    }

    @Override
    public List<IDesignExitPoint> getDesignExitPoints() {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDesignElements(this.mainDesign, IDesignExitPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDesignExits(this);
    }

    @Override
    public List<IDesignExitPoint> getDownStreamDesignExits(IWorkflowEntry workflowEntry) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDownStreamDesignElements((IDesignElement)workflowEntry.getAdapter(IDesignElement.class), IDesignExitPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDownstreamDesignExits((IDesignDocument)this, workflowEntry);
    }

    @Override
    public List<IDesignExitPoint> getDownStreamDesignExits(IDesignEntryPoint designEntry) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDownStreamDesignElements((IDesignElement)designEntry.getAdapter(IDesignElement.class), IDesignExitPoint.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDownstreamDesignExits((IDesignDocument)this, designEntry);
    }

    @Override
    public boolean hasWorkflowEntry() {
        return this.getWorkflowEntries().size() > 0;
    }

    @Override
    public List<IWorkflowEntry> getWorkflowEntries() {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDesignElements(this.mainDesign, IWorkflowEntry.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getWorkflowEntries(this);
    }

    @Override
    public List<IWorkflowEntry> getUpStreamWorkflowEntries(IDesignExitPoint designExit) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getUpStreamDesignElements((IDesignElement)designExit.getAdapter(IDesignElement.class), IWorkflowEntry.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getUpstreamWorkflowEntries((IDesignDocument)this, designExit);
    }

    @Override
    public List<IWorkflowEntry> getUpStreamWorkflowEntries(IWorkflowExit workflowExit) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getUpStreamDesignElements((IDesignElement)workflowExit.getAdapter(IDesignElement.class), IWorkflowEntry.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getUpstreamWorkflowEntries((IDesignDocument)this, workflowExit);
    }

    @Override
    public List<IWorkflowExit> getWorkflowExits() {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDesignElements(this.mainDesign, IWorkflowExit.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getWorkflowExits(this);
    }

    @Override
    public List<IWorkflowReference> getWorkflowReferences() {
        ArrayList<IWorkflowReference> ret = new ArrayList<IWorkflowReference>();
        if (this.mainDesign != null) {
            ret.addAll(DesignTraversalHelper.getDesignElements(this.mainDesign, IWorkflowReference.class));
            for (Design dialog : this.dialogs) {
                ret.addAll(DesignTraversalHelper.getDesignElements(dialog, IWorkflowReference.class));
            }
        }
        return ret;
    }

    @Override
    public List<IWorkflowExit> getDownStreamWorkflowExits(IDesignEntryPoint designEntry) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDownStreamDesignElements((IDesignElement)designEntry.getAdapter(IDesignElement.class), IWorkflowExit.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDownstreamWorkflowExits((IDesignDocument)this, designEntry);
    }

    @Override
    public List<IWorkflowExit> getDownStreamWorkflowExits(IWorkflowEntry workflowEntry) {
        if (this.mainDesign != null) {
            return DesignTraversalHelper.getDownStreamDesignElements((IDesignElement)workflowEntry.getAdapter(IDesignElement.class), IWorkflowExit.class);
        }
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getProject().getUnderlyingProject());
        return index.getDownstreamWorkflowExits((IDesignDocument)this, workflowEntry);
    }

    @Override
    public void addDocumentListener(IDesignDocumentListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeDocumentListener(IDesignDocumentListener listener) {
        this.listeners.remove(listener);
    }

    public class IndexedDesignEntry
    implements IDesignEntryPoint {
        private String id = null;
        private String name = null;

        IndexedDesignEntry(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public class IndexedDesignExit
    implements IDesignExitPoint {
        private String id = null;
        private String targetId = null;
        private String targetName = null;
        private List<Variable> exportedVariables = new ArrayList<Variable>();

        IndexedDesignExit(String id, String targetId, String targetName) {
            this.id = id;
            this.targetId = targetId;
            this.targetName = targetName;
        }

        void addExportedVariable(Variable exportedVariable) {
            this.exportedVariables.add(exportedVariable);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getTargetId() {
            return this.targetId;
        }

        @Override
        public String getTargetName() {
            return this.targetName;
        }

        @Override
        public List<Variable> getExportedDesignVariables() {
            return Collections.unmodifiableList(this.exportedVariables);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public class IndexedWorkflowEntry
    implements IWorkflowEntry {
        private String id = null;
        private String name = null;
        private List<Variable> inputVariables = new ArrayList<Variable>();

        IndexedWorkflowEntry(String id, String name) {
            this.id = id;
            this.name = name;
        }

        void addInputVariable(Variable inputVariable) {
            this.inputVariables.add(inputVariable);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Variable> getInputVariables() {
            return Collections.unmodifiableList(this.inputVariables);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public class IndexedWorkflowExit
    implements IWorkflowExit {
        private String id = null;
        private String name = null;
        private String type = null;
        private List<Variable> exportedVariables = new ArrayList<Variable>();

        IndexedWorkflowExit(String id, String name, String type) {
            this.id = id;
            this.name = name;
            this.type = type;
        }

        void addExportedVariable(Variable exportedVariable) {
            this.exportedVariables.add(exportedVariable);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<Variable> getExportedVariables() {
            return Collections.unmodifiableList(this.exportedVariables);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public static class IndexedWorkflowReference
    implements IWorkflowReference {
        private String id;
        private String targetId;
        private String entryId;

        IndexedWorkflowReference(String id, String targetId, String entryId) {
            this.id = id;
            this.targetId = targetId;
            this.entryId = entryId;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getTargetId() {
            return this.targetId;
        }

        @Override
        public String getEntryId() {
            return this.entryId;
        }
    }
}

