/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignDocumentListener;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowReference;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignExitPoint;
import org.eclipse.vtp.desktop.model.core.event.IRefreshListener;
import org.eclipse.vtp.desktop.model.core.internal.DesignParser;
import org.eclipse.vtp.desktop.model.core.internal.DesignWriter;
import org.eclipse.vtp.desktop.model.core.internal.IDesignFilter;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementResolutionVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PartialDesignDocument
implements IDesignDocument,
ElementResolutionVisitor {
    private boolean dialogOnly = false;
    private List<Design> dialogs = new LinkedList<Design>();
    private Design mainDesign = null;
    private IDesignDocument backingDocument = null;
    private Design baseDesign = null;

    public PartialDesignDocument(IDesignDocument baseDocument, Design baseDesign, Document document) {
        this.backingDocument = baseDocument;
        this.baseDesign = baseDesign;
        DesignParser parser = new DesignParser();
        Element rootElement = document.getDocumentElement();
        if (rootElement.getAttribute("dialog-only").equals("true")) {
            this.dialogOnly = true;
            NodeList mainList = rootElement.getElementsByTagName("workflow");
            if (mainList.getLength() > 0) {
                Element mainElement = (Element)mainList.item(0);
                this.mainDesign = parser.parseDesign(this, baseDesign, mainElement, this, true);
            }
        } else {
            NodeList mainList;
            NodeList dialogsList = rootElement.getElementsByTagName("dialogs");
            if (dialogsList.getLength() > 0) {
                NodeList dialogList = ((Element)dialogsList.item(0)).getElementsByTagName("workflow");
                int i = 0;
                while (i < dialogList.getLength()) {
                    Element dialogElement = (Element)dialogList.item(i);
                    this.dialogs.add(parser.parseDesign(this, dialogElement, null, true));
                    ++i;
                }
            }
            if ((mainList = rootElement.getElementsByTagName("workflow")).getLength() > 0) {
                Element mainElement = (Element)mainList.item(0);
                this.mainDesign = parser.parseDesign(this, baseDesign, mainElement, this, true);
            }
        }
    }

    public Document toDocument() {
        Document document = null;
        try {
            DesignWriter writer = new DesignWriter();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.getDOMImplementation().createDocument(null, "design-fragment", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", "4.0.0");
            IDesignFilter filter = new IDesignFilter(){

                @Override
                public boolean matches(IDesignComponent component) {
                    return true;
                }
            };
            if (this.dialogOnly) {
                rootElement.setAttribute("dialog-only", "true");
                writer.writeDesign(rootElement, this.mainDesign, filter);
            } else {
                writer.writeDesign(rootElement, this.mainDesign, filter);
                Element dialogsElement = rootElement.getOwnerDocument().createElement("dialogs");
                rootElement.appendChild(dialogsElement);
                for (IDesign iDesign : this.dialogs) {
                    writer.writeDesign(dialogsElement, (Design)iDesign);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public PartialDesignDocument clone() {
        return new PartialDesignDocument(this.backingDocument, this.baseDesign, this.toDocument());
    }

    public void forceNewIds() {
        for (Design dialogDesign : this.dialogs) {
            dialogDesign.forceNewIds();
        }
        this.mainDesign.forceNewIds();
    }

    @Override
    public IDesign getMainDesign() {
        return this.mainDesign;
    }

    @Override
    public List<IDesign> getDialogDesigns() {
        return new LinkedList<IDesign>(this.dialogs);
    }

    public void removeAllDialogs() {
        this.dialogs.clear();
    }

    @Override
    public IDesign getDialogDesign(String id) {
        for (Design dialog : this.dialogs) {
            if (!dialog.getDesignId().equals(id)) continue;
            return dialog;
        }
        return null;
    }

    @Override
    public void resolveElement(DesignElement element) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public IWorkflowResource getParent() {
        return null;
    }

    @Override
    public void addRefreshListener(IRefreshListener listener) {
    }

    @Override
    public void removeRefreshListener(IRefreshListener listener) {
    }

    @Override
    public void deferEvents() {
    }

    @Override
    public void resumeEvents() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public IWorkflowProject getProject() {
        return this.backingDocument.getProject();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public IDesignItemContainer getParentDesignContainer() {
        return null;
    }

    @Override
    public boolean hasWorkflowEntry() {
        return false;
    }

    @Override
    public List<IWorkflowEntry> getWorkflowEntries() {
        return null;
    }

    @Override
    public List<IWorkflowEntry> getUpStreamWorkflowEntries(IWorkflowExit workflowExit) {
        return null;
    }

    @Override
    public List<IWorkflowEntry> getUpStreamWorkflowEntries(IDesignExitPoint designExit) {
        return null;
    }

    @Override
    public List<IWorkflowExit> getWorkflowExits() {
        return null;
    }

    @Override
    public List<IWorkflowReference> getWorkflowReferences() {
        return null;
    }

    @Override
    public List<IWorkflowExit> getDownStreamWorkflowExits(IWorkflowEntry workflowEntry) {
        return null;
    }

    @Override
    public List<IWorkflowExit> getDownStreamWorkflowExits(IDesignEntryPoint designEntry) {
        return null;
    }

    @Override
    public List<IDesignEntryPoint> getDesignEntryPoints() {
        return null;
    }

    @Override
    public List<IDesignEntryPoint> getUpStreamDesignEntries(IWorkflowExit workflowExit) {
        return null;
    }

    @Override
    public List<IDesignEntryPoint> getUpStreamDesignEntries(IDesignExitPoint designExit) {
        return null;
    }

    @Override
    public List<IDesignExitPoint> getDesignExitPoints() {
        return null;
    }

    @Override
    public List<IDesignExitPoint> getDownStreamDesignExits(IWorkflowEntry workflowEntry) {
        return null;
    }

    @Override
    public List<IDesignExitPoint> getDownStreamDesignExits(IDesignEntryPoint designEntry) {
        return null;
    }

    @Override
    public void becomeWorkingCopy() {
    }

    @Override
    public void becomeWorkingCopy(boolean followExternalReferences) {
    }

    @Override
    public void discardWorkingCopy() {
    }

    @Override
    public void restoreWorkingCopy() {
    }

    @Override
    public void commitWorkingCopy() {
    }

    @Override
    public boolean isWorkingCopy() {
        return false;
    }

    @Override
    public IDesign addDialogDesign(String id, URL templateURL) {
        return null;
    }

    @Override
    public IFile getUnderlyingFile() {
        return null;
    }

    @Override
    public Image getDesignThumbnail(String designId) {
        return null;
    }

    @Override
    public void addDocumentListener(IDesignDocumentListener listener) {
    }

    @Override
    public void removeDocumentListener(IDesignDocumentListener listener) {
    }
}

