/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IWebserviceDescriptor;
import org.eclipse.vtp.desktop.model.core.IWebserviceSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.model.core.internal.WebserviceDescriptor;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;

public class WebserviceSet
extends WorkflowResource
implements IWebserviceSet {
    private final IWorkflowProject project;
    private final IFolder folder;

    public WebserviceSet(IWorkflowProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public IWorkflowResource getParent() {
        return this.project;
    }

    @Override
    public List<IWebserviceDescriptor> getWebserviceDescriptors() {
        return this.getWebserviceDescriptors(false);
    }

    @Override
    public List<IWebserviceDescriptor> getWebserviceDescriptors(boolean validate) {
        LinkedList<IWebserviceDescriptor> results = new LinkedList<IWebserviceDescriptor>();
        try {
            IResource[] members = this.folder.members();
            int i = 0;
            while (i < members.length) {
                block7: {
                    if (members[i].getType() == 1) {
                        WebserviceDescriptor descriptor = new WebserviceDescriptor(this, (IFile)members[i]);
                        if (validate) {
                            try {
                                descriptor.getWSDL();
                            }
                            catch (Exception ex) {
                                break block7;
                            }
                        }
                        results.add(descriptor);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results;
    }

    @Override
    public IWebserviceDescriptor createWebserviceDescriptor(String name, InputStream content) {
        IFile file = this.folder.getFile(name);
        try {
            if (!file.exists()) {
                file.create(content, true, null);
            } else {
                file.setContents(content, true, false, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
        return new WebserviceDescriptor(this, file);
    }

    @Override
    public void deleteWebserviceDescriptor(IWebserviceDescriptor dependency) {
        IFile file = this.folder.getFile(dependency.getName());
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        if (WebserviceSet.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        return new LinkedList<IWorkflowResource>(this.getWebserviceDescriptors());
    }

    @Override
    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebserviceSet) {
            return this.folder.equals((Object)((WebserviceSet)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return this.folder.toString().hashCode();
    }
}

